/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionLabel
extends Expression {
    String name;

    public ExpressionLabel(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInitLabel() {
        return this.getName().equals("init");
    }

    public boolean isDeadlockLabel() {
        return this.getName().equals("deadlock");
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate labels", this);
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate labels", this);
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionLabel expressionLabel = new ExpressionLabel(this.name);
        expressionLabel.setType(this.type);
        expressionLabel.setPosition(this);
        return expressionLabel;
    }

    @Override
    public String toString() {
        return "\"" + this.name + "\"";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionLabel expressionLabel = (ExpressionLabel)object;
        return !(this.name == null ? expressionLabel.name != null : !this.name.equals(expressionLabel.name));
    }
}

