/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import common.SafeCast;
import java.util.ArrayList;
import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;
import prism.PrismUtils;

public class ExpressionFunc
extends Expression {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int FLOOR = 2;
    public static final int CEIL = 3;
    public static final int ROUND = 4;
    public static final int POW = 5;
    public static final int MOD = 6;
    public static final int LOG = 7;
    public static final int MULTI = 8;
    public static final String[] names = new String[]{"min", "max", "floor", "ceil", "round", "pow", "mod", "log", "multi"};
    public static final int[] minArities = new int[]{2, 2, 1, 1, 1, 2, 2, 2, 1};
    public static final int[] maxArities = new int[]{-1, -1, 1, 1, 1, 2, 2, 2, -1};
    private String name = "";
    private int code = -1;
    private ArrayList<Expression> operands;
    private boolean oldStyle = false;

    public ExpressionFunc() {
        this.operands = new ArrayList();
    }

    public ExpressionFunc(String string) {
        this.setName(string);
        this.operands = new ArrayList();
    }

    public void setName(String string) {
        this.name = string;
        int n = names.length;
        this.code = -1;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(names[i])) continue;
            this.code = i;
            break;
        }
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }

    public void setOperand(int n, Expression expression) {
        this.operands.set(n, expression);
    }

    public void setOldStyle(boolean bl) {
        this.oldStyle = bl;
    }

    public String getName() {
        return this.name;
    }

    public int getNameCode() {
        return this.code;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public Expression getOperand(int n) {
        return this.operands.get(n);
    }

    public boolean getOldStyle() {
        return this.oldStyle;
    }

    public int getMinArity() {
        return this.code == -1 ? Integer.MAX_VALUE : minArities[this.code];
    }

    public int getMaxArity() {
        return this.code == -1 ? -1 : maxArities[this.code];
    }

    @Override
    public boolean isConstant() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isProposition() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).isProposition()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        switch (this.code) {
            case 0: {
                return this.evaluateMin(evaluateContext);
            }
            case 1: {
                return this.evaluateMax(evaluateContext);
            }
            case 2: {
                return this.evaluateFloor(evaluateContext);
            }
            case 3: {
                return this.evaluateCeil(evaluateContext);
            }
            case 4: {
                return this.evaluateRound(evaluateContext);
            }
            case 5: {
                return this.evaluatePow(evaluateContext);
            }
            case 6: {
                return this.evaluateMod(evaluateContext);
            }
            case 7: {
                return this.evaluateLog(evaluateContext);
            }
        }
        throw new PrismLangException("Unknown function \"" + this.name + "\"", this);
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        switch (this.code) {
            case 0: {
                return this.evaluateMinExact(evaluateContext);
            }
            case 1: {
                return this.evaluateMaxExact(evaluateContext);
            }
            case 2: {
                return this.evaluateFloorExact(evaluateContext);
            }
            case 3: {
                return this.evaluateCeilExact(evaluateContext);
            }
            case 4: {
                return this.evaluateRoundExact(evaluateContext);
            }
            case 5: {
                return this.evaluatePowExact(evaluateContext);
            }
            case 6: {
                return this.evaluateModExact(evaluateContext);
            }
            case 7: {
                return this.evaluateLogExact(evaluateContext);
            }
        }
        throw new PrismLangException("Unknown function \"" + this.name + "\"", this);
    }

    private Object evaluateMin(EvaluateContext evaluateContext) throws PrismLangException {
        if (this.type instanceof TypeInt) {
            int n = this.getOperand(0).evaluateInt(evaluateContext);
            int n2 = this.getNumOperands();
            for (int i = 1; i < n2; ++i) {
                int n3 = this.getOperand(i).evaluateInt(evaluateContext);
                n = n3 < n ? n3 : n;
            }
            return n;
        }
        double d = this.getOperand(0).evaluateDouble(evaluateContext);
        int n = this.getNumOperands();
        for (int i = 1; i < n; ++i) {
            double d2 = this.getOperand(i).evaluateDouble(evaluateContext);
            d = d2 < d ? d2 : d;
        }
        return d;
    }

    private BigRational evaluateMinExact(EvaluateContext evaluateContext) throws PrismLangException {
        BigRational bigRational = this.getOperand(0).evaluateExact(evaluateContext);
        int n = this.getNumOperands();
        for (int i = 1; i < n; ++i) {
            bigRational = bigRational.min(this.getOperand(i).evaluateExact(evaluateContext));
        }
        return bigRational;
    }

    private Object evaluateMax(EvaluateContext evaluateContext) throws PrismLangException {
        if (this.type instanceof TypeInt) {
            int n = this.getOperand(0).evaluateInt(evaluateContext);
            int n2 = this.getNumOperands();
            for (int i = 1; i < n2; ++i) {
                int n3 = this.getOperand(i).evaluateInt(evaluateContext);
                n = n3 > n ? n3 : n;
            }
            return n;
        }
        double d = this.getOperand(0).evaluateDouble(evaluateContext);
        int n = this.getNumOperands();
        for (int i = 1; i < n; ++i) {
            double d2 = this.getOperand(i).evaluateDouble(evaluateContext);
            d = d2 > d ? d2 : d;
        }
        return d;
    }

    private BigRational evaluateMaxExact(EvaluateContext evaluateContext) throws PrismLangException {
        BigRational bigRational = this.getOperand(0).evaluateExact(evaluateContext);
        int n = this.getNumOperands();
        for (int i = 1; i < n; ++i) {
            bigRational = bigRational.max(this.getOperand(i).evaluateExact(evaluateContext));
        }
        return bigRational;
    }

    public Integer evaluateFloor(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return ExpressionFunc.evaluateFloor(this.getOperand(0).evaluateDouble(evaluateContext));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateFloor(double d) throws PrismLangException {
        try {
            return SafeCast.toIntExact(Math.floor(d));
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Cannot take floor() of " + d + ": " + arithmeticException.getMessage());
        }
    }

    public Integer evaluateCeil(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return ExpressionFunc.evaluateCeil(this.getOperand(0).evaluateDouble(evaluateContext));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateCeil(double d) throws PrismLangException {
        try {
            return SafeCast.toIntExact(Math.ceil(d));
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Cannot take ceil() of " + d + ": " + arithmeticException.getMessage());
        }
    }

    public Integer evaluateRound(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return ExpressionFunc.evaluateRound(this.getOperand(0).evaluateDouble(evaluateContext));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateRound(double d) throws PrismLangException {
        try {
            return SafeCast.toIntExact(Math.round(d));
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Cannot take round() of " + d + ": " + arithmeticException.getMessage());
        }
    }

    public BigRational evaluateFloorExact(EvaluateContext evaluateContext) throws PrismLangException {
        return this.getOperand(0).evaluateExact(evaluateContext).floor();
    }

    public BigRational evaluateCeilExact(EvaluateContext evaluateContext) throws PrismLangException {
        return this.getOperand(0).evaluateExact(evaluateContext).ceil();
    }

    public BigRational evaluateRoundExact(EvaluateContext evaluateContext) throws PrismLangException {
        return this.getOperand(0).evaluateExact(evaluateContext).round();
    }

    public Object evaluatePow(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            if (this.type instanceof TypeInt) {
                return ExpressionFunc.evaluatePowInt(this.getOperand(0).evaluateInt(evaluateContext), this.getOperand(1).evaluateInt(evaluateContext));
            }
            return ExpressionFunc.evaluatePowDouble(this.getOperand(0).evaluateDouble(evaluateContext), this.getOperand(1).evaluateDouble(evaluateContext));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluatePowInt(int n, int n2) throws PrismLangException {
        if (n2 < 0) {
            throw new PrismLangException("Negative exponent not allowed for integer power");
        }
        try {
            return SafeCast.toIntExact(Math.pow(n, n2));
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException("Overflow evaluating integer power: " + arithmeticException.getMessage());
        }
    }

    public static double evaluatePowDouble(double d, double d2) throws PrismLangException {
        return Math.pow(d, d2);
    }

    public BigRational evaluatePowExact(EvaluateContext evaluateContext) throws PrismLangException {
        BigRational bigRational = this.getOperand(0).evaluateExact(evaluateContext);
        BigRational bigRational2 = this.getOperand(1).evaluateExact(evaluateContext);
        try {
            int n = bigRational2.toInt();
            return bigRational.pow(n);
        }
        catch (PrismLangException prismLangException) {
            throw new PrismLangException("Can not compute pow exactly, as there is a problem with the exponent: " + prismLangException.getMessage(), this);
        }
    }

    public Object evaluateMod(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return ExpressionFunc.evaluateMod(this.getOperand(0).evaluateInt(evaluateContext), this.getOperand(1).evaluateInt(evaluateContext));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static int evaluateMod(int n, int n2) throws PrismLangException {
        if (n2 <= 0) {
            throw new PrismLangException("Attempt to compute modulo with non-positive divisor");
        }
        int n3 = n % n2;
        return n3 < 0 ? n3 + n2 : n3;
    }

    public BigRational evaluateModExact(EvaluateContext evaluateContext) throws PrismLangException {
        BigRational bigRational = this.getOperand(0).evaluateExact(evaluateContext);
        BigRational bigRational2 = this.getOperand(1).evaluateExact(evaluateContext);
        if (!bigRational.isInteger() && !bigRational2.isInteger()) {
            throw new PrismLangException("Can not compute mod for non-integer arguments", this);
        }
        return new BigRational(bigRational.getNum().mod(bigRational2.getNum()));
    }

    public Object evaluateLog(EvaluateContext evaluateContext) throws PrismLangException {
        try {
            return ExpressionFunc.evaluateLog(this.getOperand(0).evaluateDouble(evaluateContext), this.getOperand(1).evaluateDouble(evaluateContext));
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(this);
            throw prismLangException;
        }
    }

    public static double evaluateLog(double d, double d2) throws PrismLangException {
        return PrismUtils.log(d, d2);
    }

    public BigRational evaluateLogExact(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Currently, can not compute log exactly", this);
    }

    @Override
    public boolean returnsSingleValue() {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            if (this.getOperand(i).returnsSingleValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionFunc expressionFunc = new ExpressionFunc(this.name);
        expressionFunc.setOldStyle(this.oldStyle);
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            expressionFunc.addOperand(this.getOperand(i).deepCopy());
        }
        expressionFunc.setType(this.type);
        expressionFunc.setPosition(this);
        return expressionFunc;
    }

    @Override
    public String toString() {
        Object object = "";
        boolean bl = true;
        object = !this.oldStyle ? (String)object + this.name + "(" : (String)object + "func(" + this.name + ", ";
        int n = this.operands.size();
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                object = (String)object + ", ";
            } else {
                bl = false;
            }
            object = (String)object + this.getOperand(i);
        }
        object = (String)object + ")";
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.code;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.oldStyle ? 1231 : 1237);
        n = 31 * n + (this.operands == null ? 0 : this.operands.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionFunc expressionFunc = (ExpressionFunc)object;
        if (this.code != expressionFunc.code) {
            return false;
        }
        if (this.name == null ? expressionFunc.name != null : !this.name.equals(expressionFunc.name)) {
            return false;
        }
        if (this.oldStyle != expressionFunc.oldStyle) {
            return false;
        }
        return !(this.operands == null ? expressionFunc.operands != null : !this.operands.equals(expressionFunc.operands));
    }
}

