/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;
import param.DagFunctionFactory;
import param.DagOperator;
import param.Function;
import param.FunctionFactory;
import param.Point;

public class DagFunction
extends Function {
    private DagFunctionFactory dagFactory;
    private DagOperator num;
    private DagOperator den;
    int type;
    static final int NORMAL = 0;
    static final int INF = 1;
    static final int MINF = 2;
    static final int NAN = 3;

    public DagFunction(FunctionFactory functionFactory, DagOperator dagOperator, DagOperator dagOperator2) {
        super(functionFactory);
        this.dagFactory = (DagFunctionFactory)functionFactory;
        this.num = dagOperator;
        this.den = dagOperator2;
        this.type = 0;
    }

    public DagFunction(FunctionFactory functionFactory, int n) {
        super(functionFactory);
        this.type = n;
        this.num = null;
        this.den = null;
    }

    public DagOperator getNum() {
        return this.num;
    }

    public DagOperator getDen() {
        return this.den;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DagFunction)) {
            return false;
        }
        DagFunction dagFunction = (DagFunction)object;
        if (this.type != 0) {
            return this.type == dagFunction.type;
        }
        if (dagFunction.type != 0) {
            return false;
        }
        BigRational bigRational = new BigRational(this.num.getCValue(), this.den.getCValue());
        BigRational bigRational2 = new BigRational(dagFunction.num.getCValue(), dagFunction.den.getCValue());
        return bigRational.equals(bigRational2);
    }

    public int hashCode() {
        if (this.type != 0) {
            return this.type;
        }
        BigRational bigRational = new BigRational(this.num.getCValue(), this.den.getCValue());
        return bigRational.hashCode();
    }

    @Override
    public Function add(Function function) {
        return this.dagFactory.add(this, (DagFunction)function);
    }

    @Override
    public Function negate() {
        return this.dagFactory.negate(this);
    }

    @Override
    public Function subtract(Function function) {
        return this.dagFactory.subtract(this, (DagFunction)function);
    }

    @Override
    public Function multiply(Function function) {
        return this.dagFactory.multiply(this, (DagFunction)function);
    }

    @Override
    public Function divide(Function function) {
        return this.dagFactory.divide(this, (DagFunction)function);
    }

    @Override
    public Function star() {
        return this.dagFactory.star(this);
    }

    @Override
    public Function toConstraint() {
        return this.dagFactory.toConstraint(this);
    }

    @Override
    public BigRational evaluate(Point point, boolean bl) {
        BigRational bigRational = this.dagFactory.evaluate(this, point, bl);
        return bigRational;
    }

    @Override
    public BigRational asBigRational() {
        switch (this.type) {
            case 0: {
                return this.dagFactory.asBigRational(this);
            }
            case 3: {
                return BigRational.NAN;
            }
            case 1: {
                return BigRational.INF;
            }
            case 2: {
                return BigRational.MINF;
            }
        }
        throw new RuntimeException("Illegal type");
    }

    @Override
    public boolean isNaN() {
        return this.type == 3;
    }

    @Override
    public boolean isInf() {
        return this.type == 1;
    }

    @Override
    public boolean isMInf() {
        return this.type == 2;
    }

    @Override
    public boolean isOne() {
        return this.dagFactory.isOne(this);
    }

    @Override
    public boolean isZero() {
        return this.dagFactory.isZero(this);
    }

    public String toString() {
        return this.dagFactory.toString(this);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean isConstant() {
        if (this.type != 0) {
            return true;
        }
        return this.dagFactory.isConstant(this.num) && this.dagFactory.isConstant(this.den);
    }
}

