/*
 * Decompiled with CFR 0.152.
 */
package org.spg.PrismAPI;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismDevNullLog;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.Result;

public class PrismAPI {
    private String MODEL_FILENAME;
    private String PROPERTIES_FILENAME;
    private String modelString;
    private File propsFile;
    private PrismLog mainLog;
    private Prism prism;
    private ModulesFile modulesFile;
    private PropertiesFile propertiesFile;

    public PrismAPI() {
        this(null);
    }

    public PrismAPI(String outputFilename) {
        try {
            this.mainLog = outputFilename == null ? new PrismDevNullLog() : (outputFilename == "stdout" ? new PrismFileLog("stdout") : new PrismFileLog(outputFilename, false));
            this.prism = new Prism(this.mainLog);
            this.prism.initialise();
            this.prism.setLinEqMethod(3);
            this.prism.setMaxIters(100000);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void setPropertiesFile(String propertiesFilename) {
        this.PROPERTIES_FILENAME = propertiesFilename;
        this.propsFile = new File(this.PROPERTIES_FILENAME);
    }

    public void parseModelAndPropertiesFiles(String modelFilename, String propertiesFilename) {
        this.MODEL_FILENAME = modelFilename;
        String model = this.readModelFile(this.MODEL_FILENAME);
        this.parseModelAndProperties(model, propertiesFilename);
    }

    public void parseModelAndProperties(String model, String propertiesFilename) {
        try {
            this.modelString = model;
            this.PROPERTIES_FILENAME = propertiesFilename;
            this.propsFile = new File(this.PROPERTIES_FILENAME);
            this.modulesFile = this.prism.parseModelString(this.modelString);
            this.modulesFile.setUndefinedConstants(null);
            this.propertiesFile = this.prism.parsePropertiesFile(this.modulesFile, this.propsFile);
            this.propertiesFile.setUndefinedConstants(null);
        }
        catch (FileNotFoundException | PrismLangException e) {
            e.printStackTrace();
        }
    }

    public PropertiesFile getPrismPropertiesFile() {
        return this.propertiesFile;
    }

    public void buildModel() {
        try {
            this.prism.loadPRISMModel(this.modulesFile);
            this.prism.buildModel();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public List<Double> runPrism() {
        ArrayList<Double> results = new ArrayList<Double>();
        try {
            for (int i = 0; i < this.propertiesFile.getNumProperties(); ++i) {
                Result result = this.prism.modelCheck(this.propertiesFile, this.propertiesFile.getProperty(i));
                if (result.getResult() instanceof Boolean) {
                    boolean booleanResult = (Boolean)result.getResult();
                    if (booleanResult) {
                        results.add(1.0);
                        continue;
                    }
                    results.add(0.0);
                    continue;
                }
                results.add(Double.parseDouble(result.getResult().toString()));
            }
        }
        catch (Exception e) {
            return null;
        }
        return results;
    }

    public void closeDown() {
        if (this.mainLog != null) {
            this.mainLog.close();
        }
        this.modulesFile = null;
        this.propertiesFile = null;
        this.propsFile = null;
        this.prism = null;
    }

    public String readModelFile(String modelFileName) {
        try {
            File f = new File(modelFileName);
            if (!f.exists() || f.isDirectory()) {
                throw new IOException("File does not exist! " + f);
            }
            StringBuilder model = new StringBuilder(100);
            BufferedReader bfr = null;
            bfr = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = bfr.readLine()) != null) {
                model.append(line + "\n");
            }
            model.delete(model.length() - 1, model.length());
            return model.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

