/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.IterableBitSet;
import common.IterableStateSet;
import common.IteratorTools;
import common.functions.primitive.PairPredicateInt;
import common.iterable.FilteringIterator;
import common.iterable.MappingIterator;
import explicit.BasicModelTransformation;
import explicit.MDP;
import explicit.modelviews.EquivalenceRelationInteger;
import explicit.modelviews.MDPAdditionalChoices;
import explicit.modelviews.MDPDroppedChoicesCached;
import explicit.modelviews.MDPView;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import parser.State;
import parser.Values;
import parser.VarList;

public class MDPEquiv
extends MDPView {
    protected MDP model;
    protected EquivalenceRelationInteger identify;
    protected int[] numChoices;
    protected StateChoicePair[][] originalChoices;
    protected BitSet hasTransitionToNonRepresentative;

    protected MDPEquiv() {
    }

    public MDPEquiv(MDP mDP, EquivalenceRelationInteger equivalenceRelationInteger) {
        this.model = mDP;
        this.identify = equivalenceRelationInteger;
        int n = mDP.getNumStates();
        this.numChoices = new int[n];
        this.originalChoices = new StateChoicePair[n][];
        PrimitiveIterator.OfInt ofInt = new IterableStateSet(equivalenceRelationInteger.nonRepresentatives, n, true).iterator();
        while (ofInt.hasNext()) {
            int n2 = ofInt.nextInt();
            BitSet bitSet = this.identify.getEquivalenceClassOrNull(n2);
            if (bitSet == null || bitSet.cardinality() == 1) {
                this.numChoices[n2] = mDP.getNumChoices(n2);
                continue;
            }
            IterableBitSet iterableBitSet = new IterableBitSet(bitSet);
            this.numChoices[n2] = IteratorTools.sum(new MappingIterator.FromIntToInt(iterableBitSet, mDP::getNumChoices));
            this.originalChoices[n2] = new StateChoicePair[this.numChoices[n2]];
            StateChoicePair[] stateChoicePairArray = this.originalChoices[n2];
            assert (n2 == bitSet.nextSetBit(0));
            int n3 = mDP.getNumChoices(n2);
            PrimitiveIterator.OfInt ofInt2 = iterableBitSet.iterator();
            ofInt2.nextInt();
            while (ofInt2.hasNext()) {
                int n4 = ofInt2.nextInt();
                int n5 = mDP.getNumChoices(n4);
                for (int i = 0; i < n5; ++i) {
                    stateChoicePairArray[n3++] = new StateChoicePair(n4, i);
                }
            }
        }
        this.hasTransitionToNonRepresentative = new BitSet();
        for (int i = 0; i < n; ++i) {
            if (!mDP.someSuccessorsInSet(i, equivalenceRelationInteger.getNonRepresentatives())) continue;
            this.hasTransitionToNonRepresentative.set(i, true);
        }
    }

    public MDPEquiv(MDPEquiv mDPEquiv) {
        super(mDPEquiv);
        this.model = mDPEquiv.model;
        this.identify = mDPEquiv.identify;
        this.numChoices = mDPEquiv.numChoices;
        this.originalChoices = mDPEquiv.originalChoices;
        this.hasTransitionToNonRepresentative = mDPEquiv.hasTransitionToNonRepresentative;
    }

    public MDPEquiv clone() {
        return new MDPEquiv(this);
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.model.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.model.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.model.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.model.isInitialState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.model.getStatesList();
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        return this.model.getConstantValues();
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.model.getLabelStates(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.model.getLabels();
    }

    @Override
    public boolean hasLabel(String string) {
        return this.model.hasLabel(string);
    }

    @Override
    public int getNumChoices(int n) {
        return this.numChoices[n];
    }

    @Override
    public Object getAction(int n, int n2) {
        StateChoicePair stateChoicePair = this.mapToOriginalModelOrNull(n, n2);
        return stateChoicePair == null ? this.model.getAction(n, n2) : this.model.getAction(stateChoicePair.state, stateChoicePair.choice);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        StateChoicePair stateChoicePair = this.mapToOriginalModelOrNull(n, n2);
        return stateChoicePair == null ? this.model.getNumTransitions(n, n2) : this.model.getNumTransitions(stateChoicePair.state, stateChoicePair.choice);
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        int n3;
        int n4;
        StateChoicePair stateChoicePair = this.mapToOriginalModelOrNull(n, n2);
        if (stateChoicePair == null) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = stateChoicePair.state;
            n3 = stateChoicePair.choice;
        }
        Iterator<Integer> iterator = this.model.getSuccessorsIterator(n4, n3);
        if (this.hasTransitionToNonRepresentative.get(n4)) {
            return FilteringIterator.dedupe(new MappingIterator.From<Integer, Integer>(iterator, this::mapStateToRestrictedModel));
        }
        return iterator;
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n, int n2) {
        int n3;
        int n4;
        StateChoicePair stateChoicePair = this.mapToOriginalModelOrNull(n, n2);
        if (stateChoicePair == null) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = stateChoicePair.state;
            n3 = stateChoicePair.choice;
        }
        Iterator<Map.Entry<Integer, Double>> iterator = this.model.getTransitionsIterator(n4, n3);
        if (this.hasTransitionToNonRepresentative.get(n4)) {
            return new MappingIterator.From<Map.Entry, Map.Entry>(iterator, this::mapTransitionToRestrictedModel);
        }
        return iterator;
    }

    @Override
    protected void fixDeadlocks() {
        assert (!this.fixedDeadlocks) : "deadlocks already fixed";
        this.model = MDPAdditionalChoices.fixDeadlocks(this.clone());
        this.identify = new EquivalenceRelationInteger();
        int n = this.model.getNumStates();
        this.numChoices = new int[n];
        for (int i = 0; i < n; ++i) {
            this.numChoices[i] = this.model.getNumChoices(i);
        }
        this.originalChoices = new StateChoicePair[n][];
        this.hasTransitionToNonRepresentative = new BitSet();
    }

    public Integer mapStateToRestrictedModel(int n) {
        return this.identify.getRepresentative(n);
    }

    public AbstractMap.SimpleImmutableEntry<Integer, Double> mapTransitionToRestrictedModel(Map.Entry<Integer, Double> entry) {
        Integer n = this.identify.getRepresentative(entry.getKey());
        Double d = entry.getValue();
        return new AbstractMap.SimpleImmutableEntry<Integer, Double>(n, d);
    }

    public StateChoicePair mapToOriginalModel(int n, int n2) {
        StateChoicePair stateChoicePair = this.mapToOriginalModelOrNull(n, n2);
        if (stateChoicePair == null) {
            stateChoicePair = new StateChoicePair(n, n2);
        }
        return stateChoicePair;
    }

    public StateChoicePair mapToOriginalModelOrNull(int n, int n2) {
        StateChoicePair[] stateChoicePairArray = this.originalChoices[n];
        if (stateChoicePairArray == null) {
            return null;
        }
        return stateChoicePairArray[n2];
    }

    public BitSet getNonRepresentativeStates() {
        return this.identify.getNonRepresentatives();
    }

    public static BasicModelTransformation<MDP, MDPEquiv> transform(MDP mDP, EquivalenceRelationInteger equivalenceRelationInteger) {
        return new BasicModelTransformation<MDP, MDPEquiv>(mDP, new MDPEquiv(mDP, equivalenceRelationInteger));
    }

    public static BasicModelTransformation<MDP, MDPEquiv> transformDroppingLoops(final MDP mDP, final EquivalenceRelationInteger equivalenceRelationInteger) {
        MDPDroppedChoicesCached mDPDroppedChoicesCached = new MDPDroppedChoicesCached(mDP, new PairPredicateInt(){

            @Override
            public boolean test(int n, int n2) {
                Iterator<Integer> iterator = mDP.getSuccessorsIterator(n, n2);
                while (iterator.hasNext()) {
                    if (equivalenceRelationInteger.test(n, iterator.next())) continue;
                    return false;
                }
                return true;
            }
        });
        return new BasicModelTransformation<MDP, MDPEquiv>(mDP, new MDPEquiv(mDPDroppedChoicesCached, equivalenceRelationInteger));
    }

    public class StateChoicePair {
        final int state;
        final int choice;

        protected StateChoicePair(int n, int n2) {
            this.state = n;
            this.choice = n2;
        }

        public int getState() {
            return this.state;
        }

        public int getChoice() {
            return this.choice;
        }
    }
}

