/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.functions.primitive.PairPredicateInt;
import explicit.Distribution;
import explicit.MDP;
import explicit.modelviews.MDPAdditionalChoices;
import explicit.modelviews.MDPView;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.State;
import parser.Values;
import parser.VarList;

public class MDPDroppedChoicesCached
extends MDPView {
    private MDP model;
    private int[] startChoice;
    private int[] mapping;

    public MDPDroppedChoicesCached(MDP mDP, PairPredicateInt pairPredicateInt) {
        int n;
        this.model = mDP;
        int n2 = mDP.getNumStates();
        this.startChoice = new int[mDP.getNumStates() + 1];
        this.mapping = new int[mDP.getNumChoices()];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            this.startChoice[n] = n3;
            int n4 = mDP.getNumChoices(n);
            for (int i = 0; i < n4; ++i) {
                if (pairPredicateInt.test(n, i)) continue;
                this.mapping[n3] = i;
                ++n3;
            }
        }
        this.startChoice[n2] = n3;
        n = n3;
        if (n < this.mapping.length) {
            this.mapping = Arrays.copyOf(this.mapping, n);
        }
    }

    public MDPDroppedChoicesCached(MDPDroppedChoicesCached mDPDroppedChoicesCached) {
        super(mDPDroppedChoicesCached);
        this.model = mDPDroppedChoicesCached.model;
        this.startChoice = mDPDroppedChoicesCached.startChoice;
        this.mapping = mDPDroppedChoicesCached.mapping;
    }

    public MDPDroppedChoicesCached clone() {
        return new MDPDroppedChoicesCached(this);
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.model.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.model.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.model.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.model.isInitialState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.model.getStatesList();
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        return this.model.getConstantValues();
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.model.getLabelStates(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.model.getLabels();
    }

    @Override
    public boolean hasLabel(String string) {
        return this.model.hasLabel(string);
    }

    @Override
    public int getNumChoices() {
        return this.mapping.length;
    }

    @Override
    public int getNumChoices(int n) {
        return this.startChoice[n + 1] - this.startChoice[n];
    }

    @Override
    public Object getAction(int n, int n2) {
        int n3 = this.mapChoiceToOriginalModel(n, n2);
        return this.model.getAction(n, n3);
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        return this.model.areAllChoiceActionsUnique() ? true : super.areAllChoiceActionsUnique();
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        int n3 = this.mapChoiceToOriginalModel(n, n2);
        return this.model.getSuccessorsIterator(n, n3);
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n, int n2) {
        int n3 = this.mapChoiceToOriginalModel(n, n2);
        return this.model.getTransitionsIterator(n, n3);
    }

    @Override
    protected void fixDeadlocks() {
        assert (!this.fixedDeadlocks) : "deadlocks already fixed";
        this.model = MDPAdditionalChoices.fixDeadlocks(this.clone());
    }

    public static MDPDroppedChoicesCached dropDenormalizedDistributions(final MDP mDP) {
        PairPredicateInt pairPredicateInt = new PairPredicateInt(){

            @Override
            public boolean test(int n, int n2) {
                Distribution distribution = new Distribution(mDP.getTransitionsIterator(n, n2));
                return distribution.sum() < 1.0;
            }
        };
        return new MDPDroppedChoicesCached(mDP, pairPredicateInt);
    }

    public int mapChoiceToOriginalModel(int n, int n2) {
        int n3 = this.startChoice[n];
        if (n2 >= this.getNumChoices(n)) {
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
        return this.mapping[n3 + n2];
    }
}

