/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.IterableStateSet;
import common.IteratorTools;
import common.iterable.MappingIterator;
import explicit.DTMC;
import explicit.Distribution;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.modelviews.ModelView;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.function.IntFunction;
import prism.ModelType;
import prism.Pair;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public abstract class DTMCView
extends ModelView
implements DTMC,
Cloneable {
    public DTMCView() {
    }

    public DTMCView(ModelView modelView) {
        super(modelView);
    }

    public String toString() {
        IntFunction<Map.Entry<Integer, Distribution>> intFunction = new IntFunction<Map.Entry<Integer, Distribution>>(){

            @Override
            public final Map.Entry<Integer, Distribution> apply(int n) {
                Distribution distribution = new Distribution(DTMCView.this.getTransitionsIterator(n));
                return new AbstractMap.SimpleImmutableEntry<Integer, Distribution>(n, distribution);
            }
        };
        Object object = "trans: [ ";
        IterableStateSet iterableStateSet = new IterableStateSet(this.getNumStates());
        MappingIterator.FromInt<Map.Entry<Integer, Distribution>> fromInt = new MappingIterator.FromInt<Map.Entry<Integer, Distribution>>(iterableStateSet, intFunction);
        while (fromInt.hasNext()) {
            Map.Entry entry = (Map.Entry)fromInt.next();
            object = (String)object + entry.getKey() + ": " + entry.getValue();
            if (!fromInt.hasNext()) continue;
            object = (String)object + ", ";
        }
        return (String)object + " ]";
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public int getNumTransitions() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumTransitions(i);
        }
        return n;
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        final Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n);
        return SuccessorsIterator.from(new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return (Integer)((Map.Entry)iterator.next()).getKey();
            }
        }, true);
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        prismLog.print(this.getNumStates() + " " + this.getNumTransitions() + "\n");
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Double> entry = iterator.next();
                treeMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Integer, Double> entry : treeMap.entrySet()) {
                prismLog.print(i + " " + entry.getKey() + " " + PrismUtils.formatDouble(entry.getValue()) + "\n");
            }
            treeMap.clear();
        }
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        try (FileWriter fileWriter = new FileWriter(string);){
            fileWriter.write(this.getModelType().keyword() + "\n");
            fileWriter.write("module M\nx : [0.." + (this.getNumStates() - 1) + "];\n");
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            int n = this.getNumStates();
            for (int i = 0; i < n; ++i) {
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                fileWriter.write("[]x=" + i + "->");
                boolean bl = true;
                for (Map.Entry entry : treeMap.entrySet()) {
                    if (bl) {
                        bl = false;
                    } else {
                        fileWriter.write("+");
                    }
                    fileWriter.write(PrismUtils.formatDouble((Double)entry.getValue()) + ":(x'=" + entry.getKey() + ")");
                }
                fileWriter.write(";\n");
                treeMap.clear();
            }
            fileWriter.write("endmodule\n");
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + this.getModelType() + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    public String infoString() {
        Object object = "";
        object = (String)object + this.getNumStates() + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        return object;
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.getNumStates() + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        return object;
    }

    @Override
    public int getNumTransitions(int n) {
        return IteratorTools.count(this.getTransitionsIterator(n));
    }

    public static Map.Entry<Integer, Pair<Double, Object>> attachAction(Map.Entry<Integer, Double> entry, Object object) {
        Integer n = entry.getKey();
        Double d = entry.getValue();
        return new AbstractMap.SimpleImmutableEntry<Integer, Pair<Double, Object>>(n, new Pair<Double, Object>(d, object));
    }

    @Override
    public Iterator<Map.Entry<Integer, Pair<Double, Object>>> getTransitionsAndActionsIterator(int n) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n);
        return new MappingIterator.From<Map.Entry, Map.Entry>(iterator, entry -> DTMCView.attachAction(entry, null));
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Double> entry = iterator.next();
            prismLog.print(n + " -> " + entry.getKey());
            Decoration decoration = new Decoration();
            decoration.setLabel(entry.getValue().toString());
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration = decorator.decorateProbability(n, entry.getKey(), entry.getValue(), decoration);
                }
            }
            prismLog.println(decoration.toString());
        }
    }
}

