/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableBitSet;
import common.functions.primitive.PairPredicateInt;
import explicit.BasicModelTransformation;
import explicit.ECComputer;
import explicit.ECComputerDefault;
import explicit.MDP;
import explicit.Model;
import explicit.Product;
import explicit.modelviews.EquivalenceRelationInteger;
import explicit.modelviews.MDPDroppedChoicesCached;
import explicit.modelviews.MDPEquiv;
import explicit.rewards.MDPRewards;
import java.util.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import prism.PrismComponent;
import prism.PrismException;

public class ZeroRewardECQuotient {
    private MDPEquiv quotient;
    private MDPRewards quotientRewards;
    private int numberOfZMECs;
    private static final boolean debug = false;

    private ZeroRewardECQuotient(MDPEquiv mDPEquiv, MDPRewards mDPRewards, int n) {
        this.quotient = mDPEquiv;
        this.quotientRewards = mDPRewards;
        this.numberOfZMECs = n;
    }

    public MDP getModel() {
        return this.quotient;
    }

    public MDPRewards getRewards() {
        return this.quotientRewards;
    }

    public int getNumberOfZeroRewardMECs() {
        return this.numberOfZMECs;
    }

    public BitSet getNonRepresentativeStates() {
        return this.quotient.getNonRepresentativeStates();
    }

    public void mapResults(double[] dArray) {
        PrimitiveIterator.OfInt ofInt = new IterableBitSet(this.quotient.getNonRepresentativeStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            int n2 = this.quotient.mapStateToRestrictedModel(n);
            dArray[n] = dArray[n2];
        }
    }

    public static ZeroRewardECQuotient getQuotient(PrismComponent prismComponent, MDP mDP, BitSet bitSet, final MDPRewards mDPRewards) throws PrismException {
        PairPredicateInt pairPredicateInt = (n, n2) -> {
            if (mDPRewards.getStateReward(n) > 0.0) {
                return true;
            }
            return mDPRewards.getTransitionReward(n, n2) > 0.0;
        };
        MDPDroppedChoicesCached mDPDroppedChoicesCached = new MDPDroppedChoicesCached(mDP, pairPredicateInt);
        ECComputer eCComputer = ECComputerDefault.createECComputer(prismComponent, mDPDroppedChoicesCached);
        eCComputer.computeMECStates(bitSet);
        List<BitSet> list = eCComputer.getMECStates();
        if (list.isEmpty()) {
            return null;
        }
        EquivalenceRelationInteger equivalenceRelationInteger = new EquivalenceRelationInteger(list);
        PairPredicateInt pairPredicateInt2 = (n, n3) -> {
            if (pairPredicateInt.test(n, n3)) {
                return false;
            }
            boolean bl = mDP.allSuccessorsMatch(n, n3, n2 -> equivalenceRelationInteger.test(n, n2));
            return bl;
        };
        final MDPDroppedChoicesCached mDPDroppedChoicesCached2 = new MDPDroppedChoicesCached(mDP, pairPredicateInt2);
        BasicModelTransformation<MDP, MDPEquiv> basicModelTransformation = MDPEquiv.transform(mDPDroppedChoicesCached2, equivalenceRelationInteger);
        final MDPEquiv mDPEquiv = basicModelTransformation.getTransformedModel();
        MDPRewards mDPRewards2 = new MDPRewards(){

            @Override
            public double getStateReward(int n) {
                return mDPRewards.getStateReward(n);
            }

            @Override
            public double getTransitionReward(int n, int n2) {
                MDPEquiv.StateChoicePair stateChoicePair = mDPEquiv.mapToOriginalModel(n, n2);
                int n3 = mDPDroppedChoicesCached2.mapChoiceToOriginalModel(stateChoicePair.getState(), stateChoicePair.getChoice());
                return mDPRewards.getTransitionReward(stateChoicePair.getState(), n3);
            }

            @Override
            public MDPRewards liftFromModel(Product<? extends Model> product) {
                throw new RuntimeException("Not implemented");
            }

            @Override
            public boolean hasTransitionRewards() {
                return mDPRewards.hasTransitionRewards();
            }
        };
        return new ZeroRewardECQuotient(mDPEquiv, mDPRewards2, list.size());
    }
}

