/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.ModelSimple;
import explicit.SuccessorsIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.PrismException;

public class DTMCSimple
extends DTMCExplicit
implements ModelSimple {
    protected List<Distribution> trans;
    protected int numTransitions;

    public DTMCSimple() {
        this.initialise(0);
    }

    public DTMCSimple(int n) {
        this.initialise(n);
    }

    public DTMCSimple(DTMCSimple dTMCSimple) {
        this(dTMCSimple.numStates);
        this.copyFrom(dTMCSimple);
        for (int i = 0; i < this.numStates; ++i) {
            this.trans.set(i, new Distribution(dTMCSimple.trans.get(i)));
        }
        this.numTransitions = dTMCSimple.numTransitions;
    }

    public DTMCSimple(DTMCSimple dTMCSimple, int[] nArray) {
        this(dTMCSimple.numStates);
        this.copyFrom(dTMCSimple, nArray);
        for (int i = 0; i < this.numStates; ++i) {
            this.trans.set(nArray[i], new Distribution(dTMCSimple.trans.get(i), nArray));
        }
        this.numTransitions = dTMCSimple.numTransitions;
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.trans = new ArrayList<Distribution>(n);
        for (int i = 0; i < n; ++i) {
            this.trans.add(new Distribution());
        }
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        this.numTransitions -= this.trans.get(n).size();
        this.trans.get(n).clear();
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new Distribution());
            ++this.numStates;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));){
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                throw new PrismException("Missing first line of .tra file");
            }
            String[] stringArray = string2.split(" ");
            int n2 = Integer.parseInt(stringArray[0]);
            this.initialise(n2);
            string2 = bufferedReader.readLine();
            ++n;
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    stringArray = string2.split(" ");
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    double d = Double.parseDouble(stringArray[2]);
                    this.setProbability(n3, n4, d);
                }
                string2 = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + string + "\": " + iOException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Problem in .tra file (line " + n + ") for " + this.getModelType());
        }
    }

    public void setProbability(int n, int n2, double d) {
        Distribution distribution = this.trans.get(n);
        if (distribution.get(n2) != 0.0) {
            --this.numTransitions;
        }
        if (d != 0.0) {
            ++this.numTransitions;
        }
        distribution.set(n2, d);
    }

    public void addToProbability(int n, int n2, double d) {
        if (!this.trans.get(n).add(n2, d) && d != 0.0) {
            ++this.numTransitions;
        }
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        return this.trans.get(n).getSupport().iterator();
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        return SuccessorsIterator.from(this.getSuccessorsIterator(n), true);
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        return this.trans.get(n).contains(n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return this.trans.get(n).isSubsetOf(bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return this.trans.get(n).containsOneOf(bitSet);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            this.setProbability(i, i, 1.0);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("DTMC has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumTransitions(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        return this.trans.get(n).iterator();
    }

    public Distribution getTransitions(int n) {
        return this.trans.get(n);
    }

    public String toString() {
        Object object = "";
        boolean bl = true;
        object = "trans: [ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": " + this.trans.get(i);
        }
        object = (String)object + " ]";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCSimple)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DTMCSimple dTMCSimple = (DTMCSimple)object;
        if (!this.trans.equals(dTMCSimple.trans)) {
            return false;
        }
        return this.numTransitions == dTMCSimple.numTransitions;
    }
}

