/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.DTMC;
import explicit.ModelExplicit;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import prism.ModelType;
import prism.Pair;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public abstract class DTMCExplicit
extends ModelExplicit
implements DTMC {
    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        prismLog.print(this.numStates + " " + this.getNumTransitions() + "\n");
        TreeMap<Integer, Pair> treeMap = new TreeMap<Integer, Pair>();
        for (int i = 0; i < this.numStates; ++i) {
            Iterator<Map.Entry<Integer, Pair<Double, Object>>> iterator = this.getTransitionsAndActionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<Double, Object>> entry = iterator.next();
                treeMap.put((Integer)entry.getKey(), (Pair)entry.getValue());
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                prismLog.print(i + " " + entry.getKey() + " " + PrismUtils.formatDouble((Double)((Pair)entry.getValue()).first));
                Object y = ((Pair)entry.getValue()).second;
                if (y != null && !"".equals(y)) {
                    prismLog.print(" " + y);
                }
                prismLog.print("\n");
            }
            treeMap.clear();
        }
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Double> entry = iterator.next();
            prismLog.print(n + " -> " + entry.getKey());
            Decoration decoration = new Decoration();
            decoration.setLabel(entry.getValue().toString());
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration = decorator.decorateProbability(n, entry.getKey(), entry.getValue(), decoration);
                }
            }
            prismLog.println(decoration.toString());
        }
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.getModelType().keyword() + "\n");
            fileWriter.write("module M\nx : [0.." + (this.numStates - 1) + "];\n");
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            for (int i = 0; i < this.numStates; ++i) {
                Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(i);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                fileWriter.write("[]x=" + i + "->");
                boolean bl = true;
                for (Map.Entry entry : treeMap.entrySet()) {
                    if (bl) {
                        bl = false;
                    } else {
                        fileWriter.write("+");
                    }
                    fileWriter.write(PrismUtils.formatDouble((Double)entry.getValue()) + ":(x'=" + entry.getKey() + ")");
                }
                fileWriter.write(";\n");
                treeMap.clear();
            }
            fileWriter.write("endmodule\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + this.getModelType() + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    public Iterator<Map.Entry<Integer, Pair<Double, Object>>> getTransitionsAndActionsIterator(int n) {
        return new AddDefaultActionToTransitionsIterator(this.getTransitionsIterator(n), null);
    }

    public class AddDefaultActionToTransitionsIterator
    implements Iterator<Map.Entry<Integer, Pair<Double, Object>>> {
        private Iterator<Map.Entry<Integer, Double>> transIter;
        private Object defaultAction;
        private Map.Entry<Integer, Double> next;

        public AddDefaultActionToTransitionsIterator(Iterator<Map.Entry<Integer, Double>> iterator, Object object) {
            this.transIter = iterator;
            this.defaultAction = object;
        }

        @Override
        public Map.Entry<Integer, Pair<Double, Object>> next() {
            this.next = this.transIter.next();
            Integer n = this.next.getKey();
            Double d = this.next.getValue();
            return new AbstractMap.SimpleImmutableEntry<Integer, Pair<Double, Object>>(n, new Pair<Double, Object>(d, this.defaultAction));
        }

        @Override
        public boolean hasNext() {
            return this.transIter.hasNext();
        }

        @Override
        public void remove() {
        }
    }
}

