/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.CTMDPSimple;
import explicit.DTMCSimple;
import explicit.DTMCSparse;
import explicit.Distribution;
import explicit.IndexedSet;
import explicit.MDPSimple;
import explicit.MDPSparse;
import explicit.Model;
import explicit.ModelExplicit;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ModulesFile;
import prism.ModelGenerator;
import prism.ModelType;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismPrintStreamLog;
import prism.ProgressDisplay;
import prism.UndefinedConstants;
import simulator.ModulesFileModelGenerator;

public class ConstructModel
extends PrismComponent {
    protected boolean findDeadlocks = true;
    protected boolean fixDeadlocks = true;
    protected boolean sortStates = true;
    protected boolean buildSparse = true;
    protected boolean distinguishActions = true;
    protected boolean attachLabels = true;
    protected List<State> statesList;

    public ConstructModel(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public List<State> getStatesList() {
        return this.statesList;
    }

    public void setFixDeadlocks(boolean bl) {
        this.fixDeadlocks = bl;
    }

    public void setSortStates(boolean bl) {
        this.sortStates = bl;
    }

    public void setBuildSparse(boolean bl) {
        this.buildSparse = bl;
    }

    public void setDistinguishActions(boolean bl) {
        this.distinguishActions = bl;
    }

    public void setAttachLabels(boolean bl) {
        this.attachLabels = bl;
    }

    public List<State> computeReachableStates(ModelGenerator modelGenerator) throws PrismException {
        this.constructModel(modelGenerator, true);
        return this.getStatesList();
    }

    public Model constructModel(ModelGenerator modelGenerator) throws PrismException {
        return this.constructModel(modelGenerator, false);
    }

    public Model constructModel(ModelGenerator modelGenerator, boolean bl) throws PrismException {
        ModelExplicit modelExplicit = null;
        DTMCSimple dTMCSimple = null;
        CTMCSimple cTMCSimple = null;
        MDPSimple mDPSimple = null;
        CTMDPSimple cTMDPSimple = null;
        ModelExplicit modelExplicit2 = null;
        Distribution distribution = null;
        ModelType modelType = modelGenerator.getModelType();
        VarList varList = modelGenerator.createVarList();
        if (modelGenerator.containsUnboundedVariables()) {
            this.mainLog.printWarning("Model contains one or more unbounded variables: model construction may not terminate");
        }
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        if (!bl) {
            switch (modelType) {
                case DTMC: {
                    dTMCSimple = new DTMCSimple();
                    modelExplicit = dTMCSimple;
                    dTMCSimple.setVarList(varList);
                    break;
                }
                case CTMC: {
                    cTMCSimple = new CTMCSimple();
                    modelExplicit = cTMCSimple;
                    cTMCSimple.setVarList(varList);
                    break;
                }
                case MDP: {
                    mDPSimple = new MDPSimple();
                    modelExplicit = mDPSimple;
                    mDPSimple.setVarList(varList);
                    break;
                }
                case CTMDP: {
                    cTMDPSimple = new CTMDPSimple();
                    modelExplicit = cTMDPSimple;
                    cTMDPSimple.setVarList(varList);
                    break;
                }
                case STPG: 
                case SMG: 
                case PTA: 
                case LTS: {
                    throw new PrismNotSupportedException("Model construction not supported for " + modelType + "s");
                }
            }
        }
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State state : modelGenerator.getInitialStates()) {
            linkedList.add(state);
            indexedSet.add(state);
            if (bl) continue;
            modelExplicit.addState();
            modelExplicit.addInitialState(modelExplicit.getNumStates() - 1);
        }
        int n = -1;
        while (!linkedList.isEmpty()) {
            State state = (State)linkedList.removeFirst();
            ++n;
            modelGenerator.exploreState(state);
            int n2 = modelGenerator.getNumChoices();
            for (int i = 0; i < n2; ++i) {
                if (!bl && modelType.nondeterministic()) {
                    distribution = new Distribution();
                }
                int n3 = modelGenerator.getNumTransitions(i);
                block23: for (int j = 0; j < n3; ++j) {
                    State state2 = modelGenerator.computeTransitionTarget(i, j);
                    if (indexedSet.add(state2)) {
                        linkedList.add(state2);
                        if (!bl) {
                            modelExplicit.addState();
                        }
                    }
                    int n4 = indexedSet.getIndexOfLastAdd();
                    if (bl) continue;
                    switch (modelType) {
                        case DTMC: {
                            dTMCSimple.addToProbability(n, n4, modelGenerator.getTransitionProbability(i, j));
                            continue block23;
                        }
                        case CTMC: {
                            cTMCSimple.addToProbability(n, n4, modelGenerator.getTransitionProbability(i, j));
                            continue block23;
                        }
                        case MDP: 
                        case CTMDP: {
                            distribution.add(n4, modelGenerator.getTransitionProbability(i, j));
                            continue block23;
                        }
                        case STPG: 
                        case SMG: 
                        case PTA: 
                        case LTS: {
                            throw new PrismNotSupportedException("Model construction not supported for " + modelType + "s");
                        }
                    }
                }
                if (bl) continue;
                if (modelType == ModelType.MDP) {
                    if (this.distinguishActions) {
                        mDPSimple.addActionLabelledChoice(n, distribution, modelGenerator.getChoiceAction(i));
                        continue;
                    }
                    mDPSimple.addChoice(n, distribution);
                    continue;
                }
                if (modelType != ModelType.CTMDP) continue;
                if (this.distinguishActions) {
                    cTMDPSimple.addActionLabelledChoice(n, distribution, modelGenerator.getChoiceAction(i));
                    continue;
                }
                cTMDPSimple.addChoice(n, distribution);
            }
            progressDisplay.updateIfReady(n + 1);
        }
        progressDisplay.update(n + 1);
        progressDisplay.end(" states");
        this.mainLog.print("Reachable states exploration" + (bl ? "" : " and model construction"));
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        if (!bl && this.findDeadlocks) {
            modelExplicit.findDeadlocks(this.fixDeadlocks);
        }
        Object object = null;
        if (this.sortStates) {
            this.mainLog.println("Sorting reachable states list...");
            object = indexedSet.buildSortingPermutation();
            this.statesList = indexedSet.toPermutedArrayList((int[])object);
        } else {
            this.statesList = indexedSet.toArrayList();
        }
        indexedSet.clear();
        indexedSet = null;
        if (!bl) {
            switch (modelType) {
                case DTMC: {
                    if (this.buildSparse) {
                        modelExplicit2 = this.sortStates ? new DTMCSparse(dTMCSimple, (int[])object) : new DTMCSparse(dTMCSimple);
                        break;
                    }
                    modelExplicit2 = this.sortStates ? new DTMCSimple(dTMCSimple, (int[])object) : dTMCSimple;
                    break;
                }
                case CTMC: {
                    modelExplicit2 = this.sortStates ? new CTMCSimple(cTMCSimple, (int[])object) : cTMCSimple;
                    break;
                }
                case MDP: {
                    if (this.buildSparse) {
                        modelExplicit2 = this.sortStates ? new MDPSparse(mDPSimple, true, (int[])object) : new MDPSparse(mDPSimple);
                        break;
                    }
                    modelExplicit2 = this.sortStates ? new MDPSimple(mDPSimple, (int[])object) : mDPSimple;
                    break;
                }
                case CTMDP: {
                    modelExplicit2 = this.sortStates ? new CTMDPSimple(cTMDPSimple, (int[])object) : mDPSimple;
                    break;
                }
                case STPG: 
                case SMG: 
                case PTA: 
                case LTS: {
                    throw new PrismNotSupportedException("Model construction not supported for " + modelType + "s");
                }
            }
            modelExplicit2.setStatesList(this.statesList);
            modelExplicit2.setConstantValues(new Values(modelGenerator.getConstantValues()));
        }
        object = null;
        if (!bl && this.attachLabels) {
            this.attachLabels(modelGenerator, modelExplicit2);
        }
        return modelExplicit2;
    }

    private void attachLabels(ModelGenerator modelGenerator, ModelExplicit modelExplicit) throws PrismException {
        int n;
        List<State> list = modelExplicit.getStatesList();
        int n2 = list.size();
        int n3 = modelGenerator.getNumLabels();
        if (n3 == 0) {
            return;
        }
        BitSet[] bitSetArray = new BitSet[n3];
        for (n = 0; n < n3; ++n) {
            bitSetArray[n] = new BitSet();
        }
        for (n = 0; n < n2; ++n) {
            State state = list.get(n);
            modelGenerator.exploreState(state);
            for (int i = 0; i < n3; ++i) {
                if (!modelGenerator.isLabelTrue(i)) continue;
                bitSetArray[i].set(n);
            }
        }
        for (n = 0; n < n3; ++n) {
            modelExplicit.addLabel(modelGenerator.getLabelName(n), bitSetArray[n]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.out);
            Prism prism = new Prism(prismPrintStreamLog);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            UndefinedConstants undefinedConstants = new UndefinedConstants(modulesFile, null);
            if (stringArray.length > 2) {
                undefinedConstants.defineUsingConstSwitch(stringArray[2]);
            }
            modulesFile.setUndefinedConstants(undefinedConstants.getMFConstantValues());
            ConstructModel constructModel = new ConstructModel(prism);
            constructModel.setSortStates(true);
            ModulesFileModelGenerator modulesFileModelGenerator = new ModulesFileModelGenerator(modulesFile, constructModel);
            Model model = constructModel.constructModel(modulesFileModelGenerator);
            model.exportToPrismExplicitTra(stringArray[1]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

