/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorsMap;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorModularTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorModularTest.suite());
    }

    public FactorModularTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorModularTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testModularFactorization() {
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(primeList.get(3));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        for (int i = 1; i < 4; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial = null;
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((ModInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorModular.baseFactors(genPolynomial = genPolynomial.monic());
            if (sortedMap.size() >= n) {
                FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
            FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testModularFactorizationExam() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(7L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder, stringArray);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        int n = 3;
        GenPolynomial genPolynomial = genPolynomialRing.parse("(x^12+5)");
        SortedMap sortedMap = factorModular.baseFactors(genPolynomial = genPolynomial.monic());
        if (sortedMap.size() >= n) {
            FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
        } else {
            long l = 0L;
            for (Long l2 : sortedMap.values()) {
                l += l2.longValue();
            }
            FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
        }
        boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
        FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }

    public void testModular2Factorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        for (int i = 1; i < 4; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial = null;
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((ModInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorModular.baseFactors(genPolynomial = genPolynomial.monic());
            if (sortedMap.size() >= n) {
                FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
            FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testMultivariateModularFactorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(13L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, termOrder);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        for (int i = 1; i < 2; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial = null;
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((ModInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorModular.factors(genPolynomial);
            if (sortedMap.size() >= n) {
                FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
            FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testBaseModularAbsoluteFactorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(17L);
        String[] stringArray = new String[]{"alpha"};
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder, stringArray);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0, 4L);
        genPolynomial = genPolynomial.sum((ModInteger)genPolynomialRing.fromInteger(1L));
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        FactorsMap<ModInteger> factorsMap = factorModular.baseFactorsAbsolute(genPolynomial);
        boolean bl = factorModular.isAbsoluteFactorization(factorsMap);
        FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }
}

