/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Interval;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealRoots;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class RealRootsAbstract<C extends RingElem<C> & Rational>
implements RealRoots<C> {
    private static final Logger logger = Logger.getLogger(RealRootsAbstract.class);

    @Override
    public C realRootBound(GenPolynomial<C> genPolynomial) {
        RingElem ringElem4;
        if (genPolynomial == null) {
            return null;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        RingElem ringElem2 = (RingElem)ringFactory.getONE();
        if (genPolynomial.isZERO()) {
            return (C)ringElem2;
        }
        if (genPolynomial.isConstant()) {
            ringElem2 = (RingElem)((RingElem)genPolynomial.leadingBaseCoefficient().abs()).sum((AbelianGroupElem)ringFactory.getONE());
            return (C)ringElem2;
        }
        RingElem ringElem3 = (RingElem)genPolynomial.leadingBaseCoefficient().abs();
        for (RingElem ringElem4 : genPolynomial.getMap().values()) {
            RingElem ringElem5 = ((RingElem)ringElem4.abs()).divide(ringElem3);
            if (ringElem2.compareTo(ringElem5) >= 0) continue;
            ringElem2 = ringElem5;
        }
        BigRational bigRational = ((Rational)((Object)ringElem2)).getRational();
        logger.info("rational root bound: " + bigRational);
        ringElem4 = new BigInteger(bigRational.numerator().divide(bigRational.denominator()));
        ringElem4 = ((BigInteger)ringElem4).sum(BigInteger.ONE);
        ringElem2 = (RingElem)ringFactory.fromInteger(((BigInteger)ringElem4).getVal());
        ringElem2 = (RingElem)ringElem2.sum((AbelianGroupElem)genPolynomial.ring.coFac.getONE());
        logger.info("integer root bound: " + ringElem2);
        return (C)ringElem2;
    }

    public C magnitudeBound(Interval<C> interval, GenPolynomial<C> genPolynomial) {
        RingFactory ringFactory;
        RingElem ringElem;
        if (genPolynomial == null) {
            return null;
        }
        if (genPolynomial.isZERO()) {
            return (C)((RingElem)genPolynomial.ring.coFac.getONE());
        }
        if (genPolynomial.isConstant()) {
            return (C)((RingElem)genPolynomial.leadingBaseCoefficient().abs());
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial.map(new UnaryFunctor<C, C>(){

            @Override
            public C eval(C c) {
                return (RingElem)c.abs();
            }
        });
        RingElem ringElem2 = (RingElem)interval.left.abs();
        if (ringElem2.compareTo(interval.right.abs()) < 0) {
            ringElem2 = (RingElem)interval.right.abs();
        }
        if ((ringElem = PolyUtil.evaluateMain(ringFactory = genPolynomial.ring.coFac, genPolynomial2, ringElem2)) instanceof RealAlgebraicNumber) {
            RealAlgebraicNumber realAlgebraicNumber = (RealAlgebraicNumber)ringElem;
            BigRational bigRational = realAlgebraicNumber.magnitude();
            ringElem = (RingElem)((RingElem)ringFactory.fromInteger(bigRational.numerator())).divide((MonoidElem)ringFactory.fromInteger(bigRational.denominator()));
        }
        return (C)ringElem;
    }

    public C bisectionPoint(Interval<C> interval, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return null;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        RingElem ringElem = (RingElem)ringFactory.fromInteger(2L);
        RingElem ringElem2 = (RingElem)interval.left.sum(interval.right);
        ringElem2 = ringElem2.divide(ringElem);
        if (genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return (C)ringElem2;
        }
        RingElem ringElem3 = PolyUtil.evaluateMain(ringFactory, genPolynomial, ringElem2);
        while (ringElem3.isZERO()) {
            RingElem ringElem4 = interval.left.sum((RingElem)ringElem2);
            if ((ringElem4 = ringElem4.divide(ringElem)).equals(ringElem2)) {
                ringElem4 = interval.right.sum((RingElem)ringElem2);
                if ((ringElem4 = ringElem4.divide(ringElem)).equals(ringElem2)) {
                    throw new RuntimeException("should not happen " + interval);
                }
            }
            ringElem2 = ringElem4;
            ringElem3 = PolyUtil.evaluateMain(ringFactory, genPolynomial, ringElem2);
        }
        return (C)ringElem2;
    }

    @Override
    public abstract List<Interval<C>> realRoots(GenPolynomial<C> var1);

    @Override
    public List<Interval<C>> realRoots(GenPolynomial<C> genPolynomial, C c) {
        List<Interval<C>> list = this.realRoots(genPolynomial);
        return this.refineIntervals(list, genPolynomial, c);
    }

    @Override
    public List<Interval<C>> realRoots(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RingElem ringElem = (RingElem)genPolynomial.ring.coFac.parse(bigRational.toString());
        return this.realRoots(genPolynomial, ringElem);
    }

    @Override
    public boolean signChange(Interval<C> interval, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return false;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        Object c = PolyUtil.evaluateMain(ringFactory, genPolynomial, interval.left);
        Object c2 = PolyUtil.evaluateMain(ringFactory, genPolynomial, interval.right);
        return c.signum() * c2.signum() < 0;
    }

    @Override
    public abstract long realRootCount(Interval<C> var1, GenPolynomial<C> var2);

    public Interval<C> halfInterval(Interval<C> interval, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return interval;
        }
        RingElem ringElem = interval.length();
        RingElem ringElem2 = (RingElem)ringElem.factory().fromInteger(2L);
        RingElem ringElem3 = ringElem.divide((RingElem)ringElem2);
        return this.refineInterval(interval, genPolynomial, ringElem3);
    }

    @Override
    public Interval<C> refineInterval(Interval<C> interval, GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || c == null) {
            return interval;
        }
        if (interval.length().compareTo(c) < 0) {
            return interval;
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        RingElem ringElem = (RingElem)ringFactory.fromInteger(2L);
        Interval<Object> interval2 = interval;
        while (interval2.length().compareTo(c) >= 0) {
            RingElem ringElem2 = (RingElem)interval2.left.sum(interval2.right);
            if (PolyUtil.evaluateMain(ringFactory, genPolynomial, ringElem2 = ringElem2.divide(ringElem)).isZERO()) {
                interval2 = new Interval<RingElem>(ringElem2, ringElem2);
                break;
            }
            Interval<RingElem> interval3 = new Interval<RingElem>((RingElem)interval2.left, ringElem2);
            if (this.signChange(interval3, genPolynomial)) {
                interval2 = interval3;
                continue;
            }
            interval2 = new Interval<RingElem>(ringElem2, (RingElem)interval2.right);
        }
        return interval2;
    }

    @Override
    public List<Interval<C>> refineIntervals(List<Interval<C>> list, GenPolynomial<C> genPolynomial, C c) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || c == null) {
            return list;
        }
        ArrayList<Interval<C>> arrayList = new ArrayList<Interval<C>>();
        for (Interval<C> interval : list) {
            Interval<C> interval2 = this.refineInterval(interval, genPolynomial, c);
            arrayList.add(interval2);
        }
        return arrayList;
    }

    public abstract Interval<C> invariantSignInterval(Interval<C> var1, GenPolynomial<C> var2, GenPolynomial<C> var3);

    public int realIntervalSign(Interval<C> interval, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return 0;
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial2.signum();
        }
        if (genPolynomial2.isConstant()) {
            return genPolynomial2.signum();
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        RingElem ringElem = (RingElem)interval.left.sum(interval.right);
        ringElem = (RingElem)ringElem.divide((MonoidElem)ringFactory.fromInteger(2L));
        RingElem ringElem2 = PolyUtil.evaluateMain(ringFactory, genPolynomial2, ringElem);
        return ringElem2.signum();
    }

    @Override
    public int realSign(Interval<C> interval, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return 0;
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial2.signum();
        }
        if (genPolynomial2.isConstant()) {
            return genPolynomial2.signum();
        }
        Interval<C> interval2 = this.invariantSignInterval(interval, genPolynomial, genPolynomial2);
        return this.realIntervalSign(interval2, genPolynomial, genPolynomial2);
    }

    public Interval<C> invariantMagnitudeInterval(Interval<C> interval, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, C c) {
        Interval<Object> interval2 = interval;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return interval2;
        }
        if (genPolynomial2.isConstant()) {
            return interval2;
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return interval2;
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        C c2 = this.magnitudeBound(interval, genPolynomial3);
        RingFactory ringFactory = genPolynomial.ring.coFac;
        RingElem ringElem = (RingElem)ringFactory.fromInteger(2L);
        while (((RingElem)c2.multiply(interval2.length())).compareTo(c) >= 0) {
            RingElem ringElem2 = (RingElem)interval2.left.sum(interval2.right);
            Interval<RingElem> interval3 = new Interval<RingElem>(ringElem2 = ringElem2.divide(ringElem), (RingElem)interval2.right);
            if (this.signChange(interval3, genPolynomial)) {
                interval2 = interval3;
                continue;
            }
            interval2 = new Interval<RingElem>((RingElem)interval2.left, ringElem2);
        }
        return interval2;
    }

    public C realIntervalMagnitude(Interval<C> interval, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2.isZERO() || genPolynomial2.isConstant()) {
            return genPolynomial2.leadingBaseCoefficient();
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        Object c = PolyUtil.evaluateMain(ringFactory, genPolynomial2, interval.left);
        Object c2 = PolyUtil.evaluateMain(ringFactory, genPolynomial2, interval.right);
        Object c3 = c;
        if (c.compareTo(c2) <= 0) {
            c3 = c2;
        }
        return c3;
    }

    @Override
    public C realMagnitude(Interval<C> interval, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, C c) {
        if (genPolynomial2.isZERO() || genPolynomial2.isConstant()) {
            return genPolynomial2.leadingBaseCoefficient();
        }
        Interval<C> interval2 = this.invariantMagnitudeInterval(interval, genPolynomial, genPolynomial2, c);
        return this.realIntervalMagnitude(interval2, genPolynomial, genPolynomial2);
    }

    public BigDecimal approximateRoot(Interval<C> interval, GenPolynomial<C> genPolynomial, C c) throws NoConvergenceException {
        if (interval == null) {
            throw new IllegalArgumentException("null interval not allowed");
        }
        BigDecimal bigDecimal = interval.toDecimal();
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || c == null) {
            return bigDecimal;
        }
        if (interval.length().compareTo(c) < 0) {
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = new BigDecimal(((Rational)interval.left).getRational());
        BigDecimal bigDecimal3 = new BigDecimal(((Rational)interval.right).getRational());
        BigRational bigRational = ((Rational)c).getRational();
        BigDecimal bigDecimal4 = new BigDecimal(bigRational);
        BigDecimal bigDecimal5 = new BigDecimal("0.25");
        bigDecimal4 = bigDecimal4.multiply(bigDecimal);
        BigDecimal bigDecimal6 = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal6, genPolynomial.ring);
        GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        GenPolynomial<BigDecimal> genPolynomial4 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial3);
        int n = 0;
        int n2 = 0;
        while (n++ < 50) {
            BigDecimal bigDecimal7 = PolyUtil.evaluateMain(bigDecimal6, genPolynomial2, bigDecimal);
            if (bigDecimal7.isZERO()) {
                return bigDecimal;
            }
            BigDecimal bigDecimal8 = PolyUtil.evaluateMain(bigDecimal6, genPolynomial4, bigDecimal);
            if (bigDecimal8.isZERO()) {
                throw new NoConvergenceException("zero deriviative should not happen");
            }
            BigDecimal bigDecimal9 = bigDecimal7.divide(bigDecimal8);
            BigDecimal bigDecimal10 = bigDecimal.subtract(bigDecimal9);
            if (bigDecimal.subtract(bigDecimal10).abs().compareTo(bigDecimal4) <= 0) {
                return bigDecimal10;
            }
            while (bigDecimal10.compareTo(bigDecimal2) < 0 || bigDecimal10.compareTo(bigDecimal3) > 0) {
                BigDecimal bigDecimal11;
                if (n++ > 50) {
                    throw new NoConvergenceException("no convergence after " + n + " steps");
                }
                if (n > 25 && n2 == 0) {
                    bigDecimal = bigDecimal11 = new BigDecimal(((Rational)interval.randomPoint()).getRational());
                    bigDecimal9 = bigDecimal11.getZERO();
                    logger.info("trying new random starting point " + bigDecimal);
                    n = 0;
                    n2 = 1;
                }
                if (n > 25 && n2 == 1) {
                    bigDecimal = bigDecimal11 = new BigDecimal(((Rational)interval.randomPoint()).getRational());
                    bigDecimal9 = bigDecimal11.getZERO();
                    logger.info("trying new random starting point " + bigDecimal);
                    n2 = 2;
                }
                bigDecimal9 = bigDecimal9.multiply(bigDecimal5);
                bigDecimal10 = bigDecimal.subtract(bigDecimal9);
            }
            bigDecimal = bigDecimal10;
        }
        throw new NoConvergenceException("no convergence after " + n + " steps");
    }

    public List<BigDecimal> approximateRoots(GenPolynomial<C> genPolynomial, C c) {
        List<Interval<C>> list = this.realRoots(genPolynomial);
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(list.size());
        for (Interval<C> interval : list) {
            BigDecimal bigDecimal = null;
            while (bigDecimal == null) {
                try {
                    bigDecimal = this.approximateRoot(interval, genPolynomial, c);
                    arrayList.add(bigDecimal);
                }
                catch (NoConvergenceException noConvergenceException) {
                    MonoidElem monoidElem = interval.length();
                    monoidElem = (RingElem)monoidElem.divide((MonoidElem)((MonoidElem)genPolynomial.ring.coFac.fromInteger(1000L)));
                    interval = this.refineInterval(interval, genPolynomial, monoidElem);
                    logger.info("fall back rootRefinement = " + interval);
                }
            }
        }
        return arrayList;
    }

    public boolean isApproximateRoot(BigDecimal bigDecimal, GenPolynomial<C> genPolynomial, C c) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null root not allowed");
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || c == null) {
            return true;
        }
        BigDecimal bigDecimal2 = new BigDecimal(((Rational)c).getRational());
        bigDecimal2 = bigDecimal2.multiply(new BigDecimal("1000"));
        BigDecimal bigDecimal3 = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal3, genPolynomial.ring);
        GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        GenPolynomial<BigDecimal> genPolynomial4 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial3);
        return this.isApproximateRoot(bigDecimal, genPolynomial2, genPolynomial4, bigDecimal2);
    }

    public boolean isApproximateRoot(BigDecimal bigDecimal, GenPolynomial<BigDecimal> genPolynomial, GenPolynomial<BigDecimal> genPolynomial2, BigDecimal bigDecimal2) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null root not allowed");
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || bigDecimal2 == null) {
            return true;
        }
        BigDecimal bigDecimal3 = BigDecimal.ONE;
        BigDecimal bigDecimal4 = PolyUtil.evaluateMain(bigDecimal3, genPolynomial, bigDecimal);
        if (bigDecimal4.isZERO()) {
            return true;
        }
        BigDecimal bigDecimal5 = PolyUtil.evaluateMain(bigDecimal3, genPolynomial2, bigDecimal);
        if (bigDecimal5.isZERO()) {
            return false;
        }
        BigDecimal bigDecimal6 = bigDecimal4.divide(bigDecimal5);
        if (bigDecimal6.isZERO()) {
            return true;
        }
        if (bigDecimal6.abs().compareTo(bigDecimal2) <= 0) {
            return true;
        }
        System.out.println("x     = " + bigDecimal);
        System.out.println("d     = " + bigDecimal6);
        return false;
    }

    public boolean isApproximateRoot(List<BigDecimal> list, GenPolynomial<C> genPolynomial, C c) {
        if (list == null) {
            throw new IllegalArgumentException("null root not allowed");
        }
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant() || c == null) {
            return true;
        }
        BigDecimal bigDecimal = new BigDecimal(((Rational)c).getRational());
        bigDecimal = bigDecimal.multiply(new BigDecimal("1000"));
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(bigDecimal2, genPolynomial.ring);
        GenPolynomial<BigDecimal> genPolynomial2 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial);
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        GenPolynomial<BigDecimal> genPolynomial4 = PolyUtil.decimalFromRational(genPolynomialRing, genPolynomial3);
        for (BigDecimal bigDecimal3 : list) {
            if (this.isApproximateRoot(bigDecimal3, genPolynomial2, genPolynomial4, bigDecimal)) continue;
            return false;
        }
        return true;
    }
}

