/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.OrderedPairlist;
import edu.jas.ps.PSUtil;
import edu.jas.ps.Pair;
import edu.jas.ps.ReductionSeq;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StandardBaseSeq<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(StandardBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    public final ReductionSeq<C> red;

    public StandardBaseSeq() {
        this(new ReductionSeq());
    }

    public StandardBaseSeq(ReductionSeq<C> reductionSeq) {
        this.red = reductionSeq;
    }

    public List<MultiVarPowerSeries<C>> normalizeZerosOnes(List<MultiVarPowerSeries<C>> list) {
        ArrayList<MultiVarPowerSeries<C>> arrayList = new ArrayList<MultiVarPowerSeries<C>>(list.size());
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (MultiVarPowerSeries<C> multiVarPowerSeries : list) {
            if (multiVarPowerSeries == null || multiVarPowerSeries.isZERO()) continue;
            if (multiVarPowerSeries.isUnit()) {
                arrayList.clear();
                arrayList.add((MultiVarPowerSeries<C>)multiVarPowerSeries.ring.getONE());
                return arrayList;
            }
            arrayList.add((MultiVarPowerSeries<C>)multiVarPowerSeries.abs());
        }
        return arrayList;
    }

    public boolean isSTD(List<MultiVarPowerSeries<C>> list) {
        return this.isSTD(0, list);
    }

    public boolean isSTD(int n, List<MultiVarPowerSeries<C>> list) {
        if (list == null) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            MultiVarPowerSeries<C> multiVarPowerSeries = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                MultiVarPowerSeries<C> multiVarPowerSeries2;
                MultiVarPowerSeries<C> multiVarPowerSeries3;
                MultiVarPowerSeries<C> multiVarPowerSeries4 = list.get(j);
                if (!this.red.moduleCriterion(n, multiVarPowerSeries, multiVarPowerSeries4) || (multiVarPowerSeries3 = this.red.SPolynomial(multiVarPowerSeries, multiVarPowerSeries4)).isZERO() || (multiVarPowerSeries2 = this.red.normalform(list, multiVarPowerSeries3)).isZERO()) continue;
                System.out.println("pi = " + multiVarPowerSeries + ", pj = " + multiVarPowerSeries4);
                System.out.println("s  = " + multiVarPowerSeries3 + ", h = " + multiVarPowerSeries2);
                return false;
            }
        }
        return true;
    }

    public List<MultiVarPowerSeries<C>> STD(List<MultiVarPowerSeries<C>> list) {
        return this.STD(0, list);
    }

    public List<MultiVarPowerSeries<C>> STD(int n, List<MultiVarPowerSeries<C>> list) {
        List<MultiVarPowerSeries<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PSUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        MultiVarPowerSeriesRing multiVarPowerSeriesRing = list2.get((int)0).ring;
        if (!multiVarPowerSeriesRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        OrderedPairlist<C> orderedPairlist = new OrderedPairlist<C>(n, multiVarPowerSeriesRing);
        orderedPairlist.put(list2);
        logger.info("start " + orderedPairlist);
        while (orderedPairlist.hasNext()) {
            MultiVarPowerSeries<C> multiVarPowerSeries;
            ExpVector expVector;
            MultiVarPowerSeries<C> multiVarPowerSeries2;
            Pair pair = orderedPairlist.removeNext();
            if (pair == null) continue;
            MultiVarPowerSeries multiVarPowerSeries3 = pair.pi;
            MultiVarPowerSeries multiVarPowerSeries4 = pair.pj;
            if (this.debug) {
                logger.debug("pi    = " + multiVarPowerSeries3);
                logger.debug("pj    = " + multiVarPowerSeries4);
            }
            if ((multiVarPowerSeries2 = this.red.SPolynomial(multiVarPowerSeries3, multiVarPowerSeries4)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isInfoEnabled()) {
                expVector = multiVarPowerSeries2.orderExpVector();
                logger.info("ht(S) = " + expVector.toString(multiVarPowerSeries2.ring.vars) + ", " + expVector);
            }
            if ((multiVarPowerSeries = this.red.normalform(list2, multiVarPowerSeries2)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isInfoEnabled()) {
                expVector = multiVarPowerSeries.orderExpVector();
                logger.info("ht(H) = " + expVector.toString(multiVarPowerSeries2.ring.vars) + ", " + expVector);
            }
            if (multiVarPowerSeries.isUnit()) {
                list2.clear();
                list2.add(multiVarPowerSeries);
                return list2;
            }
            if (logger.isDebugEnabled()) {
                logger.info("H = " + multiVarPowerSeries);
            }
            list2.add(multiVarPowerSeries);
            orderedPairlist.put(multiVarPowerSeries);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.minimalSTD(list2);
        logger.info("" + orderedPairlist);
        return list2;
    }

    public List<MultiVarPowerSeries<C>> minimalSTD(List<MultiVarPowerSeries<C>> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<MultiVarPowerSeries<C>> serializable2 = new ArrayList<MultiVarPowerSeries<C>>(list.size());
        for (MultiVarPowerSeries<C> multiVarPowerSeries : list) {
            if (multiVarPowerSeries == null || multiVarPowerSeries.isZERO()) continue;
            MultiVarPowerSeries<C> multiVarPowerSeries2 = multiVarPowerSeries.monic();
            serializable2.add(multiVarPowerSeries2);
        }
        if (serializable2.size() <= 1) {
            return serializable2;
        }
        ArrayList arrayList = new ArrayList(serializable2.size());
        while (serializable2.size() > 0) {
            MultiVarPowerSeries multiVarPowerSeries = (MultiVarPowerSeries)serializable2.remove(0);
            if (this.red.isTopReducible(serializable2, multiVarPowerSeries) || this.red.isTopReducible(arrayList, multiVarPowerSeries)) {
                if (!this.debug) continue;
                System.out.println("dropped " + multiVarPowerSeries);
                ArrayList<MultiVarPowerSeries<C>> arrayList2 = new ArrayList<MultiVarPowerSeries<C>>(serializable2);
                arrayList2.addAll(arrayList);
                if ((multiVarPowerSeries = this.red.normalform(arrayList2, multiVarPowerSeries)).isZERO()) continue;
                System.out.println("error, nf(a) " + multiVarPowerSeries);
                continue;
            }
            arrayList.add(multiVarPowerSeries);
        }
        serializable2 = arrayList;
        return serializable2;
    }
}

