/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ResidueRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class Residue<C extends RingElem<C>>
implements RingElem<Residue<C>> {
    private static final Logger logger = Logger.getLogger(Residue.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final ResidueRing<C> ring;
    protected final C val;
    protected int isunit = -1;

    public Residue(ResidueRing<C> residueRing) {
        this(residueRing, (RingElem)residueRing.ring.getZERO(), 0);
    }

    public Residue(ResidueRing<C> residueRing, C c) {
        this(residueRing, c, -1);
    }

    public Residue(ResidueRing<C> residueRing, C c, int n) {
        this.ring = residueRing;
        RingElem ringElem = (RingElem)c.remainder(this.ring.modul);
        if (ringElem.signum() < 0) {
            ringElem = (RingElem)ringElem.sum(this.ring.modul);
        }
        this.val = ringElem;
        if (n == 0 || n == 1) {
            this.isunit = n;
            return;
        }
        if (this.val.isZERO()) {
            this.isunit = 0;
            return;
        }
        if (this.val.isUnit()) {
            this.isunit = 1;
        }
        this.isunit = -1;
    }

    @Override
    public ResidueRing<C> factory() {
        return this.ring;
    }

    @Override
    public Residue<C> copy() {
        return new Residue<C>(this.ring, this.val);
    }

    @Override
    public boolean isZERO() {
        return this.val.equals(this.ring.ring.getZERO());
    }

    @Override
    public boolean isONE() {
        return this.val.equals(this.ring.ring.getONE());
    }

    @Override
    public boolean isUnit() {
        if (this.isunit == 1) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.val instanceof GcdRingElem && this.ring.modul instanceof GcdRingElem) {
            boolean bl;
            GcdRingElem gcdRingElem = (GcdRingElem)this.val;
            GcdRingElem gcdRingElem2 = (GcdRingElem)this.ring.modul;
            GcdRingElem gcdRingElem3 = gcdRingElem.gcd(gcdRingElem2);
            if (this.debug) {
                logger.info("gcd = " + gcdRingElem3);
            }
            this.isunit = (bl = gcdRingElem3.isONE()) ? 1 : 0;
            return bl;
        }
        return false;
    }

    public String toString() {
        return "Residue[ " + this.val.toString() + " mod " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "Residue( " + this.val.toScript() + " , " + this.ring.toScript() + " )";
    }

    @Override
    public String toScriptFactory() {
        return ((ResidueRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Residue<C> residue) {
        Object object = residue.val;
        if (!this.ring.equals(residue.ring)) {
            object = (RingElem)object.remainder(this.ring.modul);
        }
        return this.val.compareTo(object);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Residue)) {
            return false;
        }
        Residue residue = (Residue)object;
        return 0 == this.compareTo(residue);
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.val.hashCode();
        return n;
    }

    @Override
    public Residue<C> abs() {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.abs());
    }

    @Override
    public Residue<C> sum(Residue<C> residue) {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.sum(residue.val));
    }

    @Override
    public Residue<C> negate() {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.negate());
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public Residue<C> subtract(Residue<C> residue) {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.subtract(residue.val));
    }

    @Override
    public Residue<C> divide(Residue<C> residue) {
        return this.multiply((Residue<C>)residue.inverse());
    }

    @Override
    public Residue<C> inverse() {
        if (this.isunit == 0) {
            throw new NotInvertibleException("element not invertible (0) " + this);
        }
        if (this.val instanceof GcdRingElem && this.ring.modul instanceof GcdRingElem) {
            GcdRingElem gcdRingElem = (GcdRingElem)this.val;
            GcdRingElem gcdRingElem2 = (GcdRingElem)this.ring.modul;
            RingElem[] ringElemArray = gcdRingElem.egcd(gcdRingElem2);
            if (this.debug) {
                logger.info("egcd = " + ringElemArray[0] + ", f = " + ringElemArray[1]);
            }
            if (!ringElemArray[0].isONE()) {
                this.isunit = 0;
                throw new NotInvertibleException("element not invertible (gcd)" + this);
            }
            this.isunit = 1;
            RingElem ringElem = ringElemArray[1];
            return new Residue<RingElem>(this.ring, ringElem);
        }
        if (this.val.isUnit()) {
            RingElem ringElem = (RingElem)this.val.inverse();
            return new Residue<RingElem>(this.ring, ringElem);
        }
        System.out.println("isunit = " + this.isunit + ", isUnit() = " + this.isUnit());
        throw new NotInvertibleException("element not invertible (!gcd)" + this);
    }

    @Override
    public Residue<C> remainder(Residue<C> residue) {
        RingElem ringElem = (RingElem)this.val.remainder(residue.val);
        return new Residue<RingElem>(this.ring, ringElem);
    }

    public Residue<C>[] quotientRemainder(Residue<C> residue) {
        return new Residue[]{this.divide(residue), this.remainder(residue)};
    }

    @Override
    public Residue<C> multiply(Residue<C> residue) {
        return new Residue<RingElem>(this.ring, (RingElem)this.val.multiply(residue.val));
    }

    @Override
    public Residue<C> gcd(Residue<C> residue) {
        throw new UnsupportedOperationException("gcd not implemented " + this.getClass().getName());
    }

    public Residue<C>[] egcd(Residue<C> residue) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

