/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.RecSolvableWordPolynomialRing;
import edu.jas.poly.TableRelation;
import edu.jas.poly.Word;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class RecSolvableWordPolynomial<C extends RingElem<C>>
extends GenSolvablePolynomial<GenWordPolynomial<C>> {
    public final RecSolvableWordPolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(RecSolvableWordPolynomial.class);
    private final boolean debug = logger.isDebugEnabled();

    public RecSolvableWordPolynomial(RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing) {
        super(recSolvableWordPolynomialRing);
        this.ring = recSolvableWordPolynomialRing;
    }

    public RecSolvableWordPolynomial(RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing, ExpVector expVector) {
        this(recSolvableWordPolynomialRing);
        this.val.put(expVector, this.ring.getONECoefficient());
    }

    public RecSolvableWordPolynomial(RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing, GenWordPolynomial<C> genWordPolynomial, ExpVector expVector) {
        this(recSolvableWordPolynomialRing);
        if (genWordPolynomial != null && !genWordPolynomial.isZERO()) {
            this.val.put(expVector, genWordPolynomial);
        }
    }

    public RecSolvableWordPolynomial(RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing, GenWordPolynomial<C> genWordPolynomial) {
        this(recSolvableWordPolynomialRing, genWordPolynomial, recSolvableWordPolynomialRing.evzero);
    }

    public RecSolvableWordPolynomial(RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing, GenSolvablePolynomial<GenWordPolynomial<C>> genSolvablePolynomial) {
        this(recSolvableWordPolynomialRing, genSolvablePolynomial.val);
    }

    protected RecSolvableWordPolynomial(RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing, SortedMap<ExpVector, GenWordPolynomial<C>> sortedMap) {
        this(recSolvableWordPolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public RecSolvableWordPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public RecSolvableWordPolynomial<C> copy() {
        return new RecSolvableWordPolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof RecSolvableWordPolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RecSolvableWordPolynomial<C> multiply(RecSolvableWordPolynomial<C> recSolvableWordPolynomial) {
        if (recSolvableWordPolynomial == null || recSolvableWordPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == recSolvableWordPolynomial.ring.nvar);
        if (this.debug) {
            logger.info("ring = " + this.ring.toScript());
        }
        boolean bl = this.ring.table.isEmpty();
        boolean bl2 = this.ring.coeffTable.isEmpty();
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.getZERO();
        ExpVector expVector = this.ring.evzero;
        GenWordPolynomial genWordPolynomial = (GenWordPolynomial)this.ring.getONECoefficient();
        GenSolvablePolynomial genSolvablePolynomial3 = null;
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial2 = null;
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = recSolvableWordPolynomial.val;
        Set set = sortedMap2.entrySet();
        if (this.debug) {
            logger.info("input A = " + this);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenWordPolynomial genWordPolynomial2 = (GenWordPolynomial)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            if (this.debug) {
                logger.info("e = " + expVector2 + ", a = " + genWordPolynomial2);
            }
            int[] nArray = expVector2.dependencyOnVariables();
            int n = this.ring.nvar + 1;
            if (nArray.length > 0) {
                n = nArray[0];
            }
            if (this.debug) {
                logger.info("input B = " + recSolvableWordPolynomial);
            }
            for (Map.Entry entry2 : set) {
                void var29_49;
                Object object;
                Object object2;
                ExpVector expVector3;
                MonoidElem<Word> monoidElem;
                Object object3;
                RingElem ringElem;
                RingElem ringElem2;
                GenWordPolynomial genWordPolynomial3 = (GenWordPolynomial)entry2.getValue();
                ExpVector expVector4 = (ExpVector)entry2.getKey();
                if (this.debug) {
                    logger.info("f = " + expVector4 + ", b = " + genWordPolynomial3);
                }
                int[] nArray2 = expVector4.dependencyOnVariables();
                int n2 = 0;
                if (nArray2.length > 0) {
                    n2 = nArray2[nArray2.length - 1];
                }
                int n3 = this.ring.nvar + 1 - n2;
                GenSolvablePolynomial genSolvablePolynomial4 = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
                RecSolvableWordPolynomial<Object> recSolvableWordPolynomial4 = null;
                if (bl2 || genWordPolynomial3.isConstant() || expVector2.isZERO()) {
                    genSolvablePolynomial4.doAddTo(genWordPolynomial3, expVector2);
                    if (this.debug) {
                        logger.info("symmetric coeff, e*b: b = " + genWordPolynomial3 + ", e = " + expVector2);
                    }
                } else {
                    if (this.debug) {
                        logger.info("unsymmetric coeff, e*b: b = " + genWordPolynomial3 + ", e = " + expVector2);
                    }
                    for (Map.Entry entry3 : genWordPolynomial3.val.entrySet()) {
                        GenWordPolynomial genWordPolynomial4;
                        ringElem2 = (RingElem)entry3.getValue();
                        ringElem = ((GenWordPolynomial)genWordPolynomial3.ring.getONE()).multiply(ringElem2);
                        object3 = (Word)entry3.getKey();
                        if (this.debug) {
                            logger.info("g = " + object3 + ", c = " + ringElem2);
                        }
                        ExpVector expVector5 = ((Word)object3).leadingExpVector();
                        monoidElem = ((Word)object3).reductum();
                        expVector3 = expVector2;
                        object2 = expVector;
                        if (!expVector2.isZERO()) {
                            expVector3 = expVector2.subst(n, 0L);
                            object2 = expVector.subst(n, expVector2.getVal(n));
                        }
                        if (this.debug) {
                            logger.info("coeff, e1 = " + expVector3 + ", e2 = " + object2 + ", Cps = " + genSolvablePolynomial4);
                            logger.info("coeff, g2 = " + expVector5 + ", g1 = " + monoidElem);
                        }
                        TableRelation tableRelation = this.ring.coeffTable.lookup((ExpVector)object2, expVector5);
                        if (this.debug) {
                            logger.info("coeff, crel = " + tableRelation.p);
                        }
                        recSolvableWordPolynomial4 = new RecSolvableWordPolynomial<C>(this.ring, tableRelation.p);
                        if (tableRelation.f != null) {
                            genWordPolynomial4 = genWordPolynomial3.ring.valueOf(tableRelation.f);
                            recSolvableWordPolynomial2 = this.ring.valueOf(genWordPolynomial4);
                            recSolvableWordPolynomial4 = recSolvableWordPolynomial4.multiply(recSolvableWordPolynomial2);
                            object = tableRelation.e == null ? object2 : ((ExpVector)object2).subtract(tableRelation.e);
                            this.ring.coeffTable.update((ExpVector)object, expVector5, (GenSolvablePolynomial<GenWordPolynomial<Object>>)recSolvableWordPolynomial4);
                        }
                        if (tableRelation.e != null) {
                            genSolvablePolynomial3 = this.ring.valueOf(tableRelation.e);
                            recSolvableWordPolynomial4 = ((RecSolvableWordPolynomial)genSolvablePolynomial3).multiply(recSolvableWordPolynomial4);
                            this.ring.coeffTable.update((ExpVector)object2, expVector5, (GenSolvablePolynomial<GenWordPolynomial<Object>>)recSolvableWordPolynomial4);
                        }
                        if (!((Word)monoidElem).isONE()) {
                            genWordPolynomial4 = genWordPolynomial3.ring.valueOf((Word)monoidElem);
                            recSolvableWordPolynomial2 = this.ring.valueOf(genWordPolynomial4);
                            recSolvableWordPolynomial4 = recSolvableWordPolynomial4.multiply(recSolvableWordPolynomial2);
                        }
                        if (!expVector3.isZERO()) {
                            genSolvablePolynomial3 = this.ring.valueOf(expVector3);
                            recSolvableWordPolynomial4 = ((RecSolvableWordPolynomial)genSolvablePolynomial3).multiply(recSolvableWordPolynomial4);
                        }
                        recSolvableWordPolynomial4 = recSolvableWordPolynomial4.multiplyLeft((GenWordPolynomial<Object>)ringElem);
                        genSolvablePolynomial4.doAddTo(recSolvableWordPolynomial4);
                    }
                    if (this.debug) {
                        logger.info("coeff, Cs = " + recSolvableWordPolynomial4 + ", Cps = " + genSolvablePolynomial4);
                    }
                }
                if (this.debug) {
                    logger.info("coeff-poly: Cps = " + genSolvablePolynomial4);
                }
                GenSolvablePolynomial genSolvablePolynomial5 = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
                Object var29_32 = null;
                if (bl || genSolvablePolynomial4.isConstant() || expVector4.isZERO()) {
                    if (this.debug) {
                        logger.info("symmetric poly, P_eb*f: Cps = " + genSolvablePolynomial4 + ", f = " + expVector4);
                    }
                    object3 = expVector2.sum(expVector4);
                    if (genSolvablePolynomial4.isConstant()) {
                        RecSolvableWordPolynomial<C> recSolvableWordPolynomial3 = this.ring.valueOf((GenWordPolynomial)genSolvablePolynomial4.leadingBaseCoefficient(), (ExpVector)object3);
                    } else {
                        RecSolvableWordPolynomial<C> recSolvableWordPolynomial5 = this.shift((RecSolvableWordPolynomial<C>)genSolvablePolynomial4, expVector4);
                    }
                } else {
                    if (this.debug) {
                        logger.info("unsymmetric poly, P_eb*f: Cps = " + genSolvablePolynomial4 + ", f = " + expVector4);
                    }
                    for (Map.Entry entry4 : ((RecSolvableWordPolynomial)genSolvablePolynomial4).val.entrySet()) {
                        void var29_46;
                        int n4;
                        monoidElem = (GenWordPolynomial)entry4.getValue();
                        expVector3 = (ExpVector)entry4.getKey();
                        if (this.debug) {
                            logger.info("g = " + expVector3 + ", c = " + monoidElem);
                        }
                        object2 = expVector3.dependencyOnVariables();
                        Object object4 = this.ring.nvar + 1;
                        if (((Object)object2).length > 0) {
                            object4 = object2[0];
                        }
                        if ((n4 = this.ring.nvar + 1 - object4) <= n3) {
                            object = expVector3.sum(expVector4);
                            if (this.debug) {
                                logger.info("disjoint poly: g = " + expVector3 + ", f = " + expVector4 + ", h = " + object);
                            }
                            RecSolvableWordPolynomial recSolvableWordPolynomial6 = (RecSolvableWordPolynomial)genSolvablePolynomial2.sum(genWordPolynomial, (ExpVector)object);
                        } else {
                            object = expVector3.subst((int)object4, 0L);
                            ExpVector expVector6 = expVector.subst((int)object4, expVector3.getVal((int)object4));
                            ExpVector expVector7 = expVector4.subst(n2, 0L);
                            ExpVector expVector8 = expVector.subst(n2, expVector4.getVal(n2));
                            if (this.debug) {
                                logger.info("poly, g1 = " + object + ", f1 = " + expVector7 + ", Dps = " + genSolvablePolynomial5);
                                logger.info("poly, g2 = " + expVector6 + ", f2 = " + expVector8);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector6, expVector8);
                            if (this.debug) {
                                logger.info("poly, g  = " + expVector3 + ", f  = " + expVector4 + ", rel = " + tableRelation);
                            }
                            RecSolvableWordPolynomial<RingElem> recSolvableWordPolynomial7 = new RecSolvableWordPolynomial<RingElem>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                ringElem = this.ring.valueOf(tableRelation.f);
                                RecSolvableWordPolynomial<RingElem> recSolvableWordPolynomial8 = recSolvableWordPolynomial7.multiply((RecSolvableWordPolynomial<RingElem>)ringElem);
                                ExpVector expVector9 = tableRelation.e == null ? expVector6 : expVector6.subtract(tableRelation.e);
                                this.ring.table.update(expVector9, expVector8, recSolvableWordPolynomial8);
                            }
                            if (tableRelation.e != null) {
                                void var29_40;
                                ringElem2 = this.ring.valueOf(tableRelation.e);
                                RecSolvableWordPolynomial<C> recSolvableWordPolynomial9 = ((RecSolvableWordPolynomial)ringElem2).multiply((RecSolvableWordPolynomial<C>)var29_40);
                                this.ring.table.update(expVector6, expVector8, recSolvableWordPolynomial9);
                            }
                            if (!expVector7.isZERO()) {
                                void var29_42;
                                ringElem = this.ring.valueOf(expVector7);
                                RecSolvableWordPolynomial<RingElem> recSolvableWordPolynomial10 = var29_42.multiply((RecSolvableWordPolynomial<C>)ringElem);
                            }
                            if (!((ExpVector)object).isZERO()) {
                                void var29_44;
                                ringElem2 = this.ring.valueOf((ExpVector)object);
                                RecSolvableWordPolynomial<C> recSolvableWordPolynomial11 = ((RecSolvableWordPolynomial)ringElem2).multiply((RecSolvableWordPolynomial<C>)var29_44);
                            }
                        }
                        RecSolvableWordPolynomial<Word> recSolvableWordPolynomial12 = var29_46.multiplyLeft((GenWordPolynomial<C>)monoidElem);
                        genSolvablePolynomial5.doAddTo(recSolvableWordPolynomial12);
                    }
                    Object object5 = genSolvablePolynomial5;
                }
                if (this.debug) {
                    logger.info("recursion+: Ds = " + var29_49 + ", a = " + genWordPolynomial2);
                }
                RecSolvableWordPolynomial<C> recSolvableWordPolynomial32 = var29_49.multiplyLeft(genWordPolynomial2);
                if (this.debug) {
                    logger.info("recursion-: Ds = " + recSolvableWordPolynomial32);
                }
                genSolvablePolynomial.doAddTo(recSolvableWordPolynomial32);
                if (!this.debug) continue;
                logger.info("end B loop: Dp = " + genSolvablePolynomial);
            }
            if (!this.debug) continue;
            logger.info("end A loop: Dp = " + genSolvablePolynomial);
        }
        return genSolvablePolynomial;
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(RecSolvableWordPolynomial<C> recSolvableWordPolynomial, RecSolvableWordPolynomial<C> recSolvableWordPolynomial2) {
        if (recSolvableWordPolynomial.isZERO() || recSolvableWordPolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (recSolvableWordPolynomial.isONE()) {
            return this.multiply(recSolvableWordPolynomial2);
        }
        if (recSolvableWordPolynomial2.isONE()) {
            return recSolvableWordPolynomial.multiply(this);
        }
        return recSolvableWordPolynomial.multiply(this).multiply(recSolvableWordPolynomial2);
    }

    public RecSolvableWordPolynomial<C> recMultiply(GenWordPolynomial<C> genWordPolynomial) {
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return recSolvableWordPolynomial;
        }
        recSolvableWordPolynomial = this.ring.valueOf(genWordPolynomial);
        return this.multiply(recSolvableWordPolynomial);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(GenWordPolynomial<C> genWordPolynomial, GenWordPolynomial<C> genWordPolynomial2) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genWordPolynomial2 == null || genWordPolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial = this.ring.valueOf(genWordPolynomial);
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial2 = this.ring.valueOf(genWordPolynomial2);
        return recSolvableWordPolynomial.multiply(this).multiply(recSolvableWordPolynomial2);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GenWordPolynomial genWordPolynomial = (GenWordPolynomial)this.ring.getONECoefficient();
        return this.multiply(genWordPolynomial, expVector);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        GenWordPolynomial genWordPolynomial = (GenWordPolynomial)this.ring.getONECoefficient();
        return this.multiply(genWordPolynomial, expVector, genWordPolynomial, expVector2);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(GenWordPolynomial<C> genWordPolynomial, ExpVector expVector) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial = this.ring.valueOf(genWordPolynomial, expVector);
        return this.multiply(recSolvableWordPolynomial);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(GenWordPolynomial<C> genWordPolynomial, ExpVector expVector, GenWordPolynomial<C> genWordPolynomial2, ExpVector expVector2) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (genWordPolynomial2 == null || genWordPolynomial2.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial = this.ring.valueOf(genWordPolynomial, expVector);
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial2 = this.ring.valueOf(genWordPolynomial2, expVector2);
        return this.multiply(recSolvableWordPolynomial, recSolvableWordPolynomial2);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiplyLeft(GenWordPolynomial<C> genWordPolynomial, ExpVector expVector) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        RecSolvableWordPolynomial<C> recSolvableWordPolynomial = this.ring.valueOf(genWordPolynomial, expVector);
        return recSolvableWordPolynomial.multiply(this);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GenSolvablePolynomial genSolvablePolynomial = this.ring.valueOf(expVector);
        return ((RecSolvableWordPolynomial)genSolvablePolynomial).multiply(this);
    }

    @Override
    public RecSolvableWordPolynomial<C> multiplyLeft(GenWordPolynomial<C> genWordPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        SortedMap sortedMap = ((RecSolvableWordPolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenWordPolynomial genWordPolynomial2 = (GenWordPolynomial)entry.getValue();
            GenWordPolynomial<GenWordPolynomial> genWordPolynomial3 = genWordPolynomial.multiply(genWordPolynomial2);
            if (genWordPolynomial3.isZERO()) continue;
            sortedMap.put(expVector, genWordPolynomial3);
        }
        return genSolvablePolynomial;
    }

    @Override
    public RecSolvableWordPolynomial<C> multiplyLeft(Map.Entry<ExpVector, GenWordPolynomial<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(entry.getValue(), entry.getKey());
    }

    @Override
    public RecSolvableWordPolynomial<C> multiply(Map.Entry<ExpVector, GenWordPolynomial<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply(entry.getValue(), entry.getKey());
    }

    protected RecSolvableWordPolynomial<C> shift(RecSolvableWordPolynomial<C> recSolvableWordPolynomial, ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (recSolvableWordPolynomial == null || recSolvableWordPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return recSolvableWordPolynomial;
        }
        SortedMap sortedMap = ((RecSolvableWordPolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = recSolvableWordPolynomial.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            GenWordPolynomial genWordPolynomial = (GenWordPolynomial)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (genWordPolynomial.isZERO()) continue;
            sortedMap.put(expVector3, genWordPolynomial);
        }
        return genSolvablePolynomial;
    }
}

