/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PolynomialList<C extends RingElem<C>>
implements Comparable<PolynomialList<C>>,
Serializable {
    public final GenPolynomialRing<C> ring;
    public final List<GenPolynomial<C>> list;
    private static final Logger logger = Logger.getLogger(PolynomialList.class);

    public PolynomialList(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        this.ring = genPolynomialRing;
        this.list = list;
    }

    public PolynomialList(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list) {
        this((GenPolynomialRing<C>)genSolvablePolynomialRing, PolynomialList.castToList(list));
    }

    public PolynomialList<C> copy() {
        return new PolynomialList<C>(this.ring, new ArrayList<GenPolynomial<C>>(this.list));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PolynomialList)) {
            System.out.println("no PolynomialList");
            return false;
        }
        PolynomialList polynomialList = (PolynomialList)object;
        if (!this.ring.equals(polynomialList.ring)) {
            System.out.println("not same Ring " + this.ring.toScript() + ", " + polynomialList.ring.toScript());
            return false;
        }
        return this.compareTo(polynomialList) == 0;
    }

    @Override
    public int compareTo(PolynomialList<C> polynomialList) {
        int n = polynomialList.list.size();
        if (this.list.size() < n) {
            n = this.list.size();
        }
        int n2 = 0;
        List<GenPolynomial<C>> list = OrderedPolynomialList.sort(this.ring, this.list);
        List<GenPolynomial<C>> list2 = OrderedPolynomialList.sort(this.ring, polynomialList.list);
        for (int i = 0; i < n; ++i) {
            GenPolynomial<C> genPolynomial;
            GenPolynomial<C> genPolynomial2 = list.get(i);
            n2 = genPolynomial2.compareTo(genPolynomial = list2.get(i));
            if (n2 == 0) continue;
            return n2;
        }
        if (this.list.size() > n) {
            return 1;
        }
        if (polynomialList.list.size() > n) {
            return -1;
        }
        return n2;
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + (this.list == null ? 0 : this.list.hashCode());
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = null;
        if (this.ring != null) {
            stringBuffer.append(this.ring.toString());
            stringArray = this.ring.getVars();
        }
        boolean bl = true;
        stringBuffer.append("\n(\n");
        String string = null;
        for (GenPolynomial<C> genPolynomial : this.list) {
            string = stringArray != null ? genPolynomial.toString(stringArray) : genPolynomial.toString();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
                if (string.length() > 10) {
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append("( " + string + " )");
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ring instanceof GenSolvablePolynomialRing) {
            switch (Scripting.getLang()) {
                case Ruby: {
                    stringBuffer.append("SolvIdeal.new(");
                    break;
                }
                default: {
                    stringBuffer.append("SolvableIdeal(");
                    break;
                }
            }
        } else {
            switch (Scripting.getLang()) {
                case Ruby: {
                    stringBuffer.append("SimIdeal.new(");
                    break;
                }
                default: {
                    stringBuffer.append("Ideal(");
                }
            }
        }
        if (this.ring != null) {
            stringBuffer.append(this.ring.toScript());
        }
        if (this.list == null) {
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append(",\"\",[");
                break;
            }
            default: {
                stringBuffer.append(",list=[");
            }
        }
        boolean bl = true;
        String string = null;
        for (GenPolynomial<C> genPolynomial : this.list) {
            string = genPolynomial.toScript();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public ModuleList<C> getModuleList(int n) {
        GenPolynomialRing<C> genPolynomialRing = this.ring.contract(n);
        logger.debug("contracted ring = " + genPolynomialRing);
        ArrayList arrayList = null;
        if (this.list == null) {
            return new ModuleList<C>(genPolynomialRing, arrayList);
        }
        int n2 = this.list.size();
        arrayList = new ArrayList(n2);
        if (n2 == 0) {
            return new ModuleList<C>(genPolynomialRing, arrayList);
        }
        ArrayList<AbelianGroupElem> arrayList2 = new ArrayList<AbelianGroupElem>(n - 1);
        AbelianGroupElem abelianGroupElem = genPolynomialRing.getZERO();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(i, abelianGroupElem);
        }
        for (GenPolynomial<C> genPolynomial : this.list) {
            if (genPolynomial == null) continue;
            Map<ExpVector, GenPolynomial<C>> map = genPolynomial.contract(genPolynomialRing);
            ArrayList<GenPolynomial<C>> arrayList3 = new ArrayList<GenPolynomial<C>>(arrayList2);
            for (Map.Entry<ExpVector, GenPolynomial<C>> entry : map.entrySet()) {
                ExpVector expVector = entry.getKey();
                int[] nArray = expVector.dependencyOnVariables();
                int n3 = 0;
                if (nArray.length > 1) {
                    throw new IllegalArgumentException("wrong dependencyOnVariables " + expVector);
                }
                if (nArray.length == 1) {
                    n3 = nArray[0];
                }
                GenPolynomial<C> genPolynomial2 = entry.getValue();
                arrayList3.set(n3, genPolynomial2);
            }
            arrayList.add(arrayList3);
        }
        return new ModuleList<C>(genPolynomialRing, arrayList);
    }

    public List<GenPolynomial<C>> getList() {
        return this.list;
    }

    public List<GenSolvablePolynomial<C>> castToSolvableList() {
        return PolynomialList.castToSolvableList(this.list);
    }

    public List<GenSolvablePolynomial<C>> getSolvableList() {
        return PolynomialList.castToSolvableList(this.list);
    }

    public GenSolvablePolynomialRing<C> getSolvableRing() {
        return (GenSolvablePolynomialRing)this.ring;
    }

    public static <C extends RingElem<C>> List<GenSolvablePolynomial<C>> castToSolvableList(List<GenPolynomial<C>> list) {
        ArrayList<GenSolvablePolynomial<C>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            if (!(genPolynomial instanceof GenSolvablePolynomial)) {
                throw new IllegalArgumentException("no solvable polynomial " + genPolynomial);
            }
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)genPolynomial;
            arrayList.add(genSolvablePolynomial);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<List<GenSolvablePolynomial<C>>> castToSolvableMatrix(List<List<GenPolynomial<C>>> list) {
        ArrayList<List<GenSolvablePolynomial<C>>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<GenSolvablePolynomial<C>>>(list.size());
        for (List<GenPolynomial<C>> list2 : list) {
            List<GenSolvablePolynomial<C>> list3 = PolynomialList.castToSolvableList(list2);
            arrayList.add(list3);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> castToList(List<? extends GenPolynomial<C>> list) {
        logger.debug("warn: can lead to wrong method dispatch");
        ArrayList<GenPolynomial<C>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> castToMatrix(List<List<? extends GenPolynomial<C>>> list) {
        logger.debug("warn: can lead to wrong method dispatch");
        ArrayList<List<GenPolynomial<C>>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<GenPolynomial<C>>>(list.size());
        for (List<GenPolynomial<C>> list2 : list) {
            arrayList.add(PolynomialList.castToList(list2));
        }
        return arrayList;
    }

    public boolean isZERO() {
        if (this.list == null) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : this.list) {
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            return false;
        }
        return true;
    }

    public boolean isONE() {
        if (this.list == null) {
            return false;
        }
        for (GenPolynomial<C> genPolynomial : this.list) {
            if (genPolynomial == null || !genPolynomial.isONE()) continue;
            return true;
        }
        return false;
    }

    public PolynomialList<C> homogenize() {
        GenPolynomialRing<C> genPolynomialRing = this.ring.extend(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.list.size());
        for (GenPolynomial<C> genPolynomial : this.list) {
            GenPolynomial<C> genPolynomial2 = genPolynomial.homogenize(genPolynomialRing);
            arrayList.add(genPolynomial2);
        }
        return new PolynomialList<C>(genPolynomialRing, arrayList);
    }

    public PolynomialList<C> deHomogenize() {
        GenPolynomialRing<C> genPolynomialRing = this.ring.contract(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.list.size());
        for (GenPolynomial<C> genPolynomial : this.list) {
            GenPolynomial<C> genPolynomial2 = genPolynomial.deHomogenize(genPolynomialRing);
            arrayList.add(genPolynomial2);
        }
        return new PolynomialList<C>(genPolynomialRing, arrayList);
    }

    public boolean isHomogeneous() {
        if (this.list == null) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : this.list) {
            if (genPolynomial == null || genPolynomial.isHomogeneous()) continue;
            return false;
        }
        return true;
    }
}

