/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSet<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(MultiplicativeSet.class);
    public final List<GenPolynomial<C>> mset;
    public final GenPolynomialRing<C> ring;

    public MultiplicativeSet(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing, new ArrayList<GenPolynomial<C>>());
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("only for non null rings");
        }
    }

    protected MultiplicativeSet(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        if (list == null || genPolynomialRing == null) {
            throw new IllegalArgumentException("only for non null parts");
        }
        this.ring = genPolynomialRing;
        this.mset = list;
    }

    public String toString() {
        return "MultiplicativeSet" + this.mset;
    }

    public boolean equals(Object object) {
        MultiplicativeSet multiplicativeSet = null;
        try {
            multiplicativeSet = (MultiplicativeSet)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (multiplicativeSet == null) {
            return false;
        }
        if (!this.ring.equals(multiplicativeSet.ring)) {
            return false;
        }
        return this.mset.equals(multiplicativeSet.mset);
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        n <<= 17;
        return n += this.mset.hashCode();
    }

    public boolean isEmpty() {
        return this.mset.size() == 0;
    }

    public boolean contains(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        if (genPolynomial.isConstant()) {
            return true;
        }
        if (this.mset.isEmpty()) {
            return false;
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial;
        for (GenPolynomial<C> genPolynomial3 : this.mset) {
            GenPolynomial<C> genPolynomial4;
            if (genPolynomial3.isONE()) continue;
            do {
                GenPolynomial<C>[] genPolynomialArray = genPolynomial2.quotientRemainder(genPolynomial3);
                GenPolynomial<C> genPolynomial5 = genPolynomialArray[0];
                genPolynomial4 = genPolynomialArray[1];
                if (!genPolynomial4.isZERO()) continue;
                if (genPolynomial5.isConstant()) {
                    return true;
                }
                genPolynomial2 = genPolynomial5;
            } while (genPolynomial4.isZERO() && !genPolynomial2.isConstant());
        }
        return genPolynomial2.isConstant();
    }

    public boolean contains(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            if (this.contains(genPolynomial)) continue;
            return false;
        }
        return true;
    }

    public MultiplicativeSet<C> add(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            genPolynomial = genPolynomial.monic();
        }
        if (this.mset.size() == 0) {
            ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(1);
            arrayList.add(genPolynomial);
            return new MultiplicativeSet<C>(this.ring, arrayList);
        }
        GenPolynomial<C> genPolynomial2 = this.removeFactors(genPolynomial);
        if (genPolynomial2.isConstant()) {
            logger.info("skipped unit or constant = " + genPolynomial2);
            return this;
        }
        if (this.ring.coFac.isField()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        if (this.mset.size() == 0) {
            logger.info("added to empty mset = " + genPolynomial2);
        } else {
            logger.info("added to mset = " + genPolynomial2);
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.mset);
        arrayList.add(genPolynomial2);
        return new MultiplicativeSet<C>(this.ring, arrayList);
    }

    public MultiplicativeSet<C> replace(List<GenPolynomial<C>> list) {
        MultiplicativeSet<C> multiplicativeSet = new MultiplicativeSet<C>(this.ring);
        if (list == null || list.size() == 0) {
            return multiplicativeSet;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            multiplicativeSet = multiplicativeSet.add(genPolynomial);
        }
        return multiplicativeSet;
    }

    public GenPolynomial<C> removeFactors(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial;
        }
        if (this.mset.size() == 0) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial;
        for (GenPolynomial<C> genPolynomial3 : this.mset) {
            GenPolynomial<C> genPolynomial4;
            if (genPolynomial3.isConstant()) continue;
            do {
                GenPolynomial<C>[] genPolynomialArray = genPolynomial2.quotientRemainder(genPolynomial3);
                GenPolynomial<C> genPolynomial5 = genPolynomialArray[0];
                genPolynomial4 = genPolynomialArray[1];
                if (!genPolynomial4.isZERO()) continue;
                if (genPolynomial5.isConstant()) {
                    return genPolynomial5;
                }
                genPolynomial2 = genPolynomial5;
            } while (genPolynomial4.isZERO() && !genPolynomial2.isConstant());
        }
        return genPolynomial2;
    }

    public List<GenPolynomial<C>> removeFactors(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        if (this.mset.size() == 0) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            genPolynomial = this.removeFactors(genPolynomial);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }
}

