/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.BasicLinAlg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public abstract class SolvableGroebnerBaseAbstract<C extends RingElem<C>>
implements SolvableGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(SolvableGroebnerBaseAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    public SolvableReduction<C> sred;
    public final Reduction<C> red = new ReductionSeq();
    public final PairList<C> strategy;
    protected final BasicLinAlg<GenPolynomial<C>> blas;
    public final GroebnerBaseAbstract<C> cbb;

    public SolvableGroebnerBaseAbstract() {
        this(new SolvableReductionSeq());
    }

    public SolvableGroebnerBaseAbstract(SolvableReduction<C> solvableReduction) {
        this(solvableReduction, new OrderedPairlist());
    }

    public SolvableGroebnerBaseAbstract(PairList<C> pairList) {
        this(new SolvableReductionSeq(), pairList);
    }

    public SolvableGroebnerBaseAbstract(SolvableReduction<C> solvableReduction, PairList<C> pairList) {
        this.sred = solvableReduction;
        this.strategy = pairList;
        this.blas = new BasicLinAlg();
        this.cbb = new GroebnerBaseSeq();
    }

    public List<GenSolvablePolynomial<C>> normalizeZerosOnes(List<GenSolvablePolynomial<C>> list) {
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) continue;
            if (genSolvablePolynomial.isUnit()) {
                arrayList.clear();
                arrayList.add((GenSolvablePolynomial<C>)genSolvablePolynomial.ring.getONE());
                return arrayList;
            }
            arrayList.add((GenSolvablePolynomial)genSolvablePolynomial.abs());
        }
        return arrayList;
    }

    @Override
    public boolean isLeftGB(List<GenSolvablePolynomial<C>> list) {
        return this.isLeftGB(0, list, true);
    }

    public boolean isLeftGB(List<GenSolvablePolynomial<C>> list, boolean bl) {
        return this.isLeftGB(0, list, bl);
    }

    @Override
    public boolean isLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        return this.isLeftGB(n, list, true);
    }

    public boolean isLeftGB(int n, List<GenSolvablePolynomial<C>> list, boolean bl) {
        if (bl) {
            return this.isLeftGBsimple(n, list);
        }
        return this.isLeftGBidem(n, list);
    }

    public boolean isLeftGBsimple(int n, List<GenSolvablePolynomial<C>> list) {
        for (int i = 0; i < list.size(); ++i) {
            GenSolvablePolynomial<C> genSolvablePolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenSolvablePolynomial<C> genSolvablePolynomial2;
                GenSolvablePolynomial<C> genSolvablePolynomial3;
                GenSolvablePolynomial<C> genSolvablePolynomial4 = list.get(j);
                if (!this.red.moduleCriterion(n, genSolvablePolynomial, genSolvablePolynomial4) || (genSolvablePolynomial3 = this.sred.leftSPolynomial(genSolvablePolynomial, genSolvablePolynomial4)).isZERO() || (genSolvablePolynomial2 = this.sred.leftNormalform(list, genSolvablePolynomial3)).isZERO()) continue;
                logger.info("no left GB: pi = " + genSolvablePolynomial + ", pj = " + genSolvablePolynomial4);
                logger.info("s  = " + genSolvablePolynomial3 + ", h = " + genSolvablePolynomial2);
                return false;
            }
        }
        return true;
    }

    public boolean isLeftGBidem(int n, List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        PolynomialList polynomialList = new PolynomialList(genSolvablePolynomialRing, list);
        List<GenSolvablePolynomial<C>> list2 = this.leftGB(n, list);
        PolynomialList polynomialList2 = new PolynomialList(genSolvablePolynomialRing, list2);
        return polynomialList.compareTo(polynomialList2) == 0;
    }

    @Override
    public boolean isTwosidedGB(List<GenSolvablePolynomial<C>> list) {
        return this.isTwosidedGB(0, list);
    }

    @Override
    public boolean isTwosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        int n2;
        int n3;
        if (list == null || list.size() == 0) {
            return true;
        }
        if (list.size() == 1 && list.get(0).isONE()) {
            return true;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        List list2 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = " + list2);
        ArrayList arrayList = new ArrayList(list.size() * (1 + list2.size()));
        arrayList.addAll(list);
        for (n3 = 0; n3 < list.size(); ++n3) {
            GenSolvablePolynomial genSolvablePolynomial = list.get(n3);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                GenSolvablePolynomial genSolvablePolynomial2 = list2.get(n2);
                if (genSolvablePolynomial2.isONE()) continue;
                GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.multiply(genSolvablePolynomial2);
                if ((genSolvablePolynomial3 = this.sred.leftNormalform(arrayList, genSolvablePolynomial3)).isZERO()) continue;
                return false;
            }
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)arrayList.get(n3);
            for (n2 = n3 + 1; n2 < arrayList.size(); ++n2) {
                GenSolvablePolynomial<C> genSolvablePolynomial4;
                GenSolvablePolynomial<C> genSolvablePolynomial5;
                GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)arrayList.get(n2);
                if (!this.red.moduleCriterion(n, genSolvablePolynomial, genSolvablePolynomial6) || (genSolvablePolynomial5 = this.sred.leftSPolynomial(genSolvablePolynomial, genSolvablePolynomial6)).isZERO() || (genSolvablePolynomial4 = this.sred.leftNormalform(arrayList, genSolvablePolynomial5)).isZERO()) continue;
                logger.info("is not TwosidedGB: " + genSolvablePolynomial4);
                return false;
            }
        }
        return true;
    }

    public boolean isTwosidedGBidem(List<GenSolvablePolynomial<C>> list) {
        return this.isTwosidedGBidem(0, list);
    }

    public boolean isTwosidedGBidem(int n, List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        PolynomialList polynomialList = new PolynomialList(genSolvablePolynomialRing, list);
        List<GenSolvablePolynomial<C>> list2 = this.twosidedGB(n, list);
        PolynomialList polynomialList2 = new PolynomialList(genSolvablePolynomialRing, list2);
        return polynomialList.compareTo(polynomialList2) == 0;
    }

    @Override
    public boolean isRightGB(List<GenSolvablePolynomial<C>> list) {
        return this.isRightGB(0, list);
    }

    @Override
    public boolean isRightGB(int n, List<GenSolvablePolynomial<C>> list) {
        for (int i = 0; i < list.size(); ++i) {
            GenSolvablePolynomial<C> genSolvablePolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenSolvablePolynomial<C> genSolvablePolynomial2;
                GenSolvablePolynomial<C> genSolvablePolynomial3;
                GenSolvablePolynomial<C> genSolvablePolynomial4 = list.get(j);
                if (!this.red.moduleCriterion(n, genSolvablePolynomial, genSolvablePolynomial4) || (genSolvablePolynomial3 = this.sred.rightSPolynomial(genSolvablePolynomial, genSolvablePolynomial4)).isZERO() || (genSolvablePolynomial2 = this.sred.rightNormalform(list, genSolvablePolynomial3)).isZERO()) continue;
                logger.info("isRightGB non zero h = " + genSolvablePolynomial2 + " :: " + genSolvablePolynomial2.ring);
                logger.info("p" + i + " = " + genSolvablePolynomial + ", p" + j + " = " + genSolvablePolynomial4);
                return false;
            }
        }
        return true;
    }

    public boolean isRightGBidem(List<GenSolvablePolynomial<C>> list) {
        return this.isRightGBidem(0, list);
    }

    public boolean isRightGBidem(int n, List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        PolynomialList polynomialList = new PolynomialList(genSolvablePolynomialRing, list);
        List<GenSolvablePolynomial<C>> list2 = this.rightGB(n, list);
        PolynomialList polynomialList2 = new PolynomialList(genSolvablePolynomialRing, list2);
        return polynomialList.compareTo(polynomialList2) == 0;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(List<GenSolvablePolynomial<C>> list) {
        return this.leftGB(0, list);
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(List<GenSolvablePolynomial<C>> list) {
        return this.extLeftGB(0, list);
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        throw new UnsupportedOperationException("extLeftGB not implemented in " + this.getClass().getSimpleName());
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        ListIterator<GenSolvablePolynomial<C>> listIterator = list.listIterator();
        for (AbelianGroupElem<GenPolynomial<C>> abelianGroupElem : list) {
            if (abelianGroupElem.length() == 0) continue;
            arrayList.add((GenSolvablePolynomial<C>)abelianGroupElem);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>();
        while (arrayList.size() > 0) {
            GenSolvablePolynomial<C> genSolvablePolynomial2;
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
            genSolvablePolynomial = arrayList.remove(0);
            ExpVector expVector = genSolvablePolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                abelianGroupElem = genSolvablePolynomial2.leadingExpVector();
                bl = expVector.multipleOf((ExpVector)abelianGroupElem);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                abelianGroupElem = genSolvablePolynomial2.leadingExpVector();
                bl = expVector.multipleOf((ExpVector)abelianGroupElem);
            }
            if (bl) continue;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        arrayList2 = new ArrayList();
        while (arrayList.size() > 0) {
            genSolvablePolynomial = arrayList.remove(0);
            genSolvablePolynomial = this.sred.leftNormalform(arrayList, genSolvablePolynomial);
            genSolvablePolynomial = this.sred.leftNormalform(arrayList2, genSolvablePolynomial);
            arrayList2.add(genSolvablePolynomial);
        }
        return arrayList2;
    }

    public List<GenSolvablePolynomial<C>> rightMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        ListIterator<GenSolvablePolynomial<C>> listIterator = list.listIterator();
        for (AbelianGroupElem<GenPolynomial<C>> abelianGroupElem : list) {
            if (abelianGroupElem.length() == 0) continue;
            arrayList.add((GenSolvablePolynomial<C>)abelianGroupElem);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>();
        while (arrayList.size() > 0) {
            GenSolvablePolynomial<C> genSolvablePolynomial2;
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
            genSolvablePolynomial = arrayList.remove(0);
            ExpVector expVector = genSolvablePolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                abelianGroupElem = genSolvablePolynomial2.leadingExpVector();
                bl = expVector.multipleOf((ExpVector)abelianGroupElem);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                abelianGroupElem = genSolvablePolynomial2.leadingExpVector();
                bl = expVector.multipleOf((ExpVector)abelianGroupElem);
            }
            if (bl) continue;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        arrayList2 = new ArrayList();
        while (arrayList.size() > 0) {
            genSolvablePolynomial = arrayList.remove(0);
            genSolvablePolynomial = this.sred.rightNormalform(arrayList, genSolvablePolynomial);
            genSolvablePolynomial = this.sred.rightNormalform(arrayList2, genSolvablePolynomial);
            arrayList2.add(genSolvablePolynomial);
        }
        return arrayList2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(List<GenSolvablePolynomial<C>> list) {
        return this.twosidedGB(0, list);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(List<GenSolvablePolynomial<C>> list) {
        return this.rightGB(0, list);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(int n, List<GenSolvablePolynomial<C>> list) {
        boolean bl;
        PolynomialList polynomialList;
        GenSolvablePolynomial genSolvablePolynomial;
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.reverse(true);
        ArrayList arrayList = new ArrayList(list.size());
        for (GenSolvablePolynomial<C> genSolvablePolynomial2 : list) {
            if (genSolvablePolynomial2 == null) continue;
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial2.reverse(genPolynomialRing2);
            arrayList.add(genSolvablePolynomial);
        }
        if (logger.isInfoEnabled()) {
            polynomialList = new PolynomialList(genPolynomialRing2, arrayList);
            logger.info("reversed problem = " + polynomialList.toScript());
        }
        polynomialList = this.leftGB(n, arrayList);
        if (this.debug) {
            long l = System.currentTimeMillis();
            bl = this.isLeftGB((List<GenSolvablePolynomial<C>>)((Object)polynomialList));
            l = System.currentTimeMillis() - l;
            logger.info("is left GB = " + bl + ", in " + l + " milliseconds");
        }
        genPolynomialRing = ((GenSolvablePolynomialRing)genPolynomialRing2).reverse(true);
        list2 = new ArrayList<GenSolvablePolynomial<C>>(polynomialList.size());
        Iterator iterator = polynomialList.iterator();
        while (iterator.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)iterator.next();
            if (genSolvablePolynomial3 == null) continue;
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial3.reverse(genPolynomialRing);
            list2.add(genSolvablePolynomial);
        }
        if (this.debug) {
            long l = System.currentTimeMillis();
            bl = this.isRightGB(list2);
            l = System.currentTimeMillis() - l;
            logger.info("is right GB = " + bl + ", in " + l + " milliseconds");
        }
        return list2;
    }

    @Override
    public boolean isLeftReductionMatrix(SolvableExtendedGB<C> solvableExtendedGB) {
        if (solvableExtendedGB == null) {
            return true;
        }
        return this.isLeftReductionMatrix(solvableExtendedGB.F, solvableExtendedGB.G, solvableExtendedGB.F2G, solvableExtendedGB.G2F);
    }

    @Override
    public boolean isLeftReductionMatrix(List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2, List<List<GenSolvablePolynomial<C>>> list3, List<List<GenSolvablePolynomial<C>>> list4) {
        boolean bl;
        int n = 0;
        for (List<GenSolvablePolynomial<C>> list5 : list4) {
            bl = this.sred.isLeftReductionNF(list5, list, list2.get(n), null);
            if (!bl) {
                System.out.println("row = " + list5);
                System.out.println("F   = " + list);
                System.out.println("Gk  = " + list2.get(n));
                logger.info("F isLeftReductionMatrix s, k = " + list.size() + ", " + n);
                return false;
            }
            ++n;
        }
        n = 0;
        for (List<GenSolvablePolynomial<C>> list5 : list3) {
            bl = this.sred.isLeftReductionNF(list5, list2, list.get(n), null);
            if (!bl) {
                logger.error("G isLeftReductionMatrix s, k = " + list2.size() + ", " + n);
                return false;
            }
            ++n;
        }
        return true;
    }

    public int commonZeroTest(List<GenSolvablePolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = PolynomialList.castToList(list);
        return this.cbb.commonZeroTest(list2);
    }

    public List<Long> univariateDegrees(List<GenSolvablePolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = PolynomialList.castToList(list);
        return this.cbb.univariateDegrees(list2);
    }

    public GenSolvablePolynomial<C> constructUnivariate(int n, List<GenSolvablePolynomial<C>> list) {
        List list2;
        GenPolynomial genPolynomial;
        Iterable iterable;
        Object object;
        GenPolynomial genPolynomial2;
        GenPolynomial genPolynomial3;
        Serializable serializable22;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        List<Long> list3 = this.univariateDegrees(list);
        if (list3.size() <= n) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional " + list3);
        }
        int n2 = 0;
        Long l = list3.get(n);
        if (l == null) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional");
        }
        n2 = (int)l.longValue();
        long l2 = 1L;
        for (Serializable serializable22 : list3) {
            if (serializable22 == null) continue;
            l2 *= serializable22.longValue();
        }
        logger.info("univariate construction, deg = " + n2 + ", vsdim = " + l2);
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        serializable22 = genSolvablePolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(serializable22, n2, new TermOrder(2));
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = new GenSolvablePolynomialRing(genPolynomialRing, genSolvablePolynomialRing);
        GenSolvablePolynomial genSolvablePolynomial = genSolvablePolynomialRing2.getZERO();
        for (int i = 0; i < n2; ++i) {
            genPolynomial3 = genSolvablePolynomialRing2.univariate(n, i);
            genPolynomial2 = genPolynomialRing.univariate(genPolynomialRing.nvar - 1 - i);
            genPolynomial3 = ((GenSolvablePolynomial)genPolynomial3).multiply((RingElem)genPolynomial2);
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial.sum(genPolynomial3);
        }
        if (this.debug) {
            logger.info("univariate construction, P = " + genSolvablePolynomial);
            logger.info("univariate construction, deg_*(G) = " + list3);
        }
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq();
        int n3 = -1;
        do {
            object = genSolvablePolynomialRing2.univariate(n, n2);
            iterable = genPolynomialRing.univariate(genPolynomialRing.nvar - 1 - n2);
            object = ((GenSolvablePolynomial)object).multiply((RingElem)((Object)iterable));
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial.sum(object);
            genPolynomial3 = genSolvablePolynomialRing.univariate(n, n2);
            genPolynomial2 = this.sred.leftNormalform(list, (GenSolvablePolynomial<C>)genPolynomial3);
            genPolynomial = PolyUtil.toRecursive(genSolvablePolynomialRing2, genPolynomial2);
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial.sum(genSolvablePolynomial);
            list2 = new ArrayList(genSolvablePolynomial2.getMap().values());
            n3 = groebnerBaseSeq.commonZeroTest(list2 = this.red.irreducibleSet(list2));
            if (n3 == 0) continue;
            if ((long)(++n2) > l2) {
                logger.info("univariate construction, P = " + genSolvablePolynomial);
                logger.info("univariate construction, nf(P) = " + genPolynomial2);
                logger.info("G = " + list);
                throw new ArithmeticException("univariate polynomial degree greater than vector space dimansion");
            }
            genPolynomialRing = genPolynomialRing.extend(1);
            genSolvablePolynomialRing2 = new GenSolvablePolynomialRing(genPolynomialRing, genSolvablePolynomialRing);
            genSolvablePolynomial = PolyUtil.extendCoefficients(genSolvablePolynomialRing2, genSolvablePolynomial, 0, 0L);
            genPolynomial = PolyUtil.extendCoefficients(genSolvablePolynomialRing2, genPolynomial, 0, 1L);
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial.sum(genPolynomial);
        } while (n3 != 0);
        object = genSolvablePolynomialRing.getVars()[genSolvablePolynomialRing.nvar - 1 - n];
        iterable = new GenSolvablePolynomialRing(serializable22, 1, new TermOrder(2), new String[]{object});
        genPolynomial = ((GenSolvablePolynomialRing)iterable).univariate(0, n2);
        for (GenPolynomial genPolynomial4 : list2) {
            int[] nArray;
            ExpVector expVector = genPolynomial4.leadingExpVector();
            if (expVector == null || (nArray = expVector.dependencyOnVariables()) == null || nArray.length == 0) continue;
            int n4 = nArray[0];
            Object object2 = genPolynomial4.trailingBaseCoefficient();
            object2 = (RingElem)object2.negate();
            GenPolynomial genPolynomial5 = ((GenSolvablePolynomialRing)iterable).univariate(0, n2 - 1 - n4);
            genPolynomial5 = ((GenSolvablePolynomial)genPolynomial5).multiply((RingElem)object2);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.sum(genPolynomial5);
        }
        if (logger.isInfoEnabled()) {
            logger.info("univariate construction, pol = " + genPolynomial);
        }
        return genPolynomial;
    }

    public List<GenSolvablePolynomial<C>> constructUnivariate(List<GenSolvablePolynomial<C>> list) {
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (int i = list.get((int)0).ring.nvar - 1; i >= 0; --i) {
            GenSolvablePolynomial<C> genSolvablePolynomial = this.constructUnivariate(i, list);
            arrayList.add(genSolvablePolynomial);
        }
        return arrayList;
    }

    public void terminate() {
        logger.info("terminate not implemented");
    }

    public int cancel() {
        logger.info("cancel not implemented");
        return 0;
    }
}

