/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.WordIdeal;
import edu.jas.application.WordResidue;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordGroebnerBaseSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.structure.ValueFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class WordResidueRing<C extends GcdRingElem<C>>
implements RingFactory<WordResidue<C>>,
QuotPairFactory<GenWordPolynomial<C>, WordResidue<C>>,
ValueFactory<GenWordPolynomial<C>, WordResidue<C>> {
    private static final Logger logger = Logger.getLogger(WordResidueRing.class);
    protected final WordGroebnerBaseAbstract<C> bb;
    public final WordIdeal<C> ideal;
    public final GenWordPolynomialRing<C> ring;
    protected int isField = -1;

    public WordResidueRing(WordIdeal<C> wordIdeal) {
        this(wordIdeal, false);
    }

    public WordResidueRing(WordIdeal<C> wordIdeal, boolean bl) {
        this.ideal = wordIdeal.GB();
        this.ring = this.ideal.getRing();
        this.bb = new WordGroebnerBaseSeq();
        if (bl) {
            this.isField = 1;
            return;
        }
        if (this.ideal.isONE()) {
            logger.warn("ideal is one, so all residues are 0");
        }
    }

    @Override
    public GenWordPolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public GenWordPolynomialRing<C> valueFactory() {
        return this.ring;
    }

    @Override
    public WordResidue<C> create(GenWordPolynomial<C> genWordPolynomial) {
        return new WordResidue<C>(this, genWordPolynomial);
    }

    @Override
    public WordResidue<C> create(GenWordPolynomial<C> genWordPolynomial, GenWordPolynomial<C> genWordPolynomial2) {
        if (genWordPolynomial2 != null && !genWordPolynomial2.isONE()) {
            throw new UnsupportedOperationException("d must be 1, but d = " + genWordPolynomial2);
        }
        return new WordResidue<C>(this, genWordPolynomial);
    }

    @Override
    public boolean isFinite() {
        return this.ideal.commonZeroTest() <= 0 && this.ring.coFac.isFinite();
    }

    @Override
    public WordResidue<C> copy(WordResidue<C> wordResidue) {
        if (wordResidue == null) {
            return this.getZERO();
        }
        WordResidue wordResidue2 = new WordResidue(this, wordResidue.val);
        return wordResidue2;
    }

    @Override
    public WordResidue<C> getZERO() {
        return new WordResidue(this, this.ring.getZERO());
    }

    @Override
    public WordResidue<C> getONE() {
        WordResidue wordResidue = new WordResidue(this, this.ring.getONE());
        if (wordResidue.isZERO()) {
            logger.warn("ideal is one, so all residues are 0");
        }
        return wordResidue;
    }

    @Override
    public List<WordResidue<C>> generators() {
        List<GenWordPolynomial<C>> list = this.ring.generators();
        ArrayList<WordResidue<C>> arrayList = new ArrayList<WordResidue<C>>(list.size());
        TreeSet<WordResidue<C>> treeSet = new TreeSet<WordResidue<C>>();
        ArrayList arrayList2 = new ArrayList(list.size());
        WordIdeal<C> wordIdeal = new WordIdeal<C>(this.ring, arrayList2);
        WordResidueRing<C> wordResidueRing = new WordResidueRing<C>(wordIdeal);
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            WordResidue<C> wordResidue;
            WordResidue<C> wordResidue2 = new WordResidue<C>(this, genWordPolynomial);
            if (wordResidue2.isZERO() || !wordResidue2.isONE() && wordResidue2.val.isConstant() || (wordResidue = new WordResidue<C>(wordResidueRing, wordResidue2.val)).isZERO() || !wordResidue.isONE() && wordResidue.val.isConstant() || (wordResidue2 = new WordResidue(this, wordResidue.val)).isZERO()) continue;
            if (!(wordResidue2 = wordResidue2.monic()).isONE() && !wordResidue2.val.isConstant()) {
                arrayList2.add(wordResidue2.val);
                wordIdeal = new WordIdeal<C>(this.ring, arrayList2);
                wordResidueRing = new WordResidueRing<C>(wordIdeal);
            }
            treeSet.add(wordResidue2);
        }
        arrayList.addAll(treeSet);
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
            return true;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public WordResidue<C> fromInteger(BigInteger bigInteger) {
        return new WordResidue(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public WordResidue<C> fromInteger(long l) {
        return new WordResidue(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "WordResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "WRC(" + this.ideal.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof WordResidueRing)) {
            return false;
        }
        WordResidueRing wordResidueRing = null;
        try {
            wordResidueRing = (WordResidueRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (wordResidueRing == null) {
            return false;
        }
        if (!this.ring.equals(wordResidueRing.ring)) {
            return false;
        }
        return this.ideal.equals(wordResidueRing.ideal);
    }

    public int hashCode() {
        int n = this.ideal.hashCode();
        return n;
    }

    @Override
    public WordResidue<C> random(int n) {
        GenWordPolynomial genWordPolynomial = ((GenWordPolynomial)this.ring.random(n)).monic();
        return new WordResidue(this, genWordPolynomial);
    }

    public WordResidue<C> random(int n, int n2, int n3) {
        GenWordPolynomial<C> genWordPolynomial = this.ring.random(n, n2, n3).monic();
        return new WordResidue<C>(this, genWordPolynomial);
    }

    @Override
    public WordResidue<C> random(int n, Random random) {
        GenWordPolynomial genWordPolynomial = ((GenWordPolynomial)this.ring.random(n, random)).monic();
        return new WordResidue(this, genWordPolynomial);
    }

    @Override
    public WordResidue<C> parse(String string) {
        Element element = this.ring.parse(string);
        return new WordResidue(this, element);
    }

    @Override
    public WordResidue<C> parse(Reader reader) {
        Element element = this.ring.parse(reader);
        return new WordResidue(this, element);
    }
}

