/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CPair;
import edu.jas.application.CReductionSeq;
import edu.jas.application.ColorPolynomial;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class OrderedCPairlist<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(OrderedCPairlist.class);
    protected final GenPolynomialRing<GenPolynomial<C>> ring;
    protected final List<ColorPolynomial<C>> P;
    protected final SortedMap<ExpVector, LinkedList<CPair<C>>> pairlist;
    protected final List<BitSet> red;
    protected final CReductionSeq<C> reduction;
    protected boolean oneInGB = false;
    protected boolean useCriterion4 = false;
    protected int putCount;
    protected int remCount;
    protected final int moduleVars;

    public OrderedCPairlist(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing) {
        this(0, genPolynomialRing);
    }

    public OrderedCPairlist(int n, GenPolynomialRing<GenPolynomial<C>> genPolynomialRing) {
        this.moduleVars = n;
        this.ring = genPolynomialRing;
        this.P = new ArrayList<ColorPolynomial<C>>();
        this.pairlist = new TreeMap<ExpVector, LinkedList<CPair<C>>>(this.ring.tord.getAscendComparator());
        this.red = new ArrayList<BitSet>();
        this.putCount = 0;
        this.remCount = 0;
        if (this.ring instanceof GenSolvablePolynomialRing) {
            this.useCriterion4 = false;
        }
        RingFactory ringFactory = this.ring.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        this.reduction = new CReductionSeq(genPolynomialRing2.coFac);
    }

    private OrderedCPairlist(int n, GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, List<ColorPolynomial<C>> list, SortedMap<ExpVector, LinkedList<CPair<C>>> sortedMap, List<BitSet> list2, CReductionSeq<C> cReductionSeq, int n2, int n3) {
        this.moduleVars = n;
        this.ring = genPolynomialRing;
        this.P = list;
        this.pairlist = sortedMap;
        this.red = list2;
        this.reduction = cReductionSeq;
        this.putCount = n2;
        this.remCount = n3;
    }

    public synchronized OrderedCPairlist<C> copy() {
        return new OrderedCPairlist<C>(this.moduleVars, this.ring, new ArrayList<ColorPolynomial<C>>(this.P), this.clonePairlist(), this.cloneBitSet(), this.reduction, this.putCount, this.remCount);
    }

    private SortedMap<ExpVector, LinkedList<CPair<C>>> clonePairlist() {
        TreeMap<ExpVector, LinkedList<CPair<C>>> treeMap = new TreeMap<ExpVector, LinkedList<CPair<C>>>(this.ring.tord.getAscendComparator());
        for (Map.Entry<ExpVector, LinkedList<CPair<C>>> entry : this.pairlist.entrySet()) {
            ExpVector expVector = entry.getKey();
            LinkedList<CPair<C>> linkedList = entry.getValue();
            linkedList = new LinkedList<CPair<C>>(linkedList);
            treeMap.put(expVector, linkedList);
        }
        return treeMap;
    }

    public int pairCount() {
        int n = 0;
        for (Map.Entry<ExpVector, LinkedList<CPair<C>>> entry : this.pairlist.entrySet()) {
            LinkedList<CPair<C>> linkedList = entry.getValue();
            n += linkedList.size();
        }
        return n;
    }

    private List<BitSet> cloneBitSet() {
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>(this.red.size());
        for (BitSet bitSet : this.red) {
            BitSet bitSet2 = (BitSet)bitSet.clone();
            arrayList.add(bitSet2);
        }
        return arrayList;
    }

    public int bitCount() {
        int n = 0;
        for (BitSet bitSet : this.red) {
            n += bitSet.cardinality();
        }
        return n;
    }

    public String toString() {
        int n;
        int n2 = this.pairCount();
        if (n2 != (n = this.bitCount())) {
            return "OrderedCPairlist( pairCount=" + n2 + ", bitCount=" + n + ", putCount=" + this.putCount + ", remCount=" + this.remCount + " )";
        }
        return "OrderedCPairlist( pairCount=" + n2 + ", putCount=" + this.putCount + ", remCount=" + this.remCount + " )";
    }

    public boolean equals(Object object) {
        OrderedCPairlist orderedCPairlist = null;
        try {
            orderedCPairlist = (OrderedCPairlist)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (orderedCPairlist == null) {
            return false;
        }
        boolean bl = this.getList().equals(orderedCPairlist.getList());
        if (!bl) {
            return bl;
        }
        boolean bl2 = bl = this.pairCount() == orderedCPairlist.pairCount();
        if (!bl) {
            return bl;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getList().hashCode();
        n <<= 7;
        return n += this.pairCount();
    }

    public synchronized int put(ColorPolynomial<C> colorPolynomial) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector expVector = colorPolynomial.leadingExpVector();
        int n = this.P.size();
        for (int i = 0; i < n; ++i) {
            ColorPolynomial<C> colorPolynomial2 = this.P.get(i);
            ExpVector expVector2 = colorPolynomial2.leadingExpVector();
            if (this.moduleVars > 0 && expVector.invLexCompareTo(expVector2, 0, this.moduleVars) != 0) continue;
            ExpVector expVector3 = expVector.lcm(expVector2);
            CPair<C> cPair = new CPair<C>(colorPolynomial2, colorPolynomial, i, n);
            LinkedList<CPair<C>> linkedList = (LinkedList<CPair<C>>)this.pairlist.get(expVector3);
            if (linkedList == null) {
                linkedList = new LinkedList<CPair<C>>();
            }
            linkedList.addFirst(cPair);
            this.pairlist.put(expVector3, linkedList);
        }
        this.P.add(colorPolynomial);
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        this.red.add(bitSet);
        return this.P.size() - 1;
    }

    public synchronized CPair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<ExpVector, LinkedList<CPair<C>>>> iterator = this.pairlist.entrySet().iterator();
        CPair<C> cPair = null;
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            Map.Entry<ExpVector, LinkedList<CPair<C>>> entry = iterator.next();
            ExpVector expVector = entry.getKey();
            LinkedList<CPair<C>> linkedList = entry.getValue();
            if (logger.isInfoEnabled()) {
                logger.info("g  = " + expVector);
            }
            cPair = null;
            while (!bl && linkedList.size() > 0) {
                cPair = linkedList.removeFirst();
                int n = cPair.i;
                int n2 = cPair.j;
                bl = true;
                this.red.get(n2).clear(n);
            }
            if (linkedList.size() != 0) continue;
            iterator.remove();
        }
        if (!bl) {
            cPair = null;
        } else {
            ++this.remCount;
        }
        return cPair;
    }

    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    public List<ColorPolynomial<C>> getList() {
        return this.P;
    }

    public synchronized int putCount() {
        return this.putCount;
    }

    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(ColorPolynomial<C> colorPolynomial) {
        ++this.putCount;
        if (colorPolynomial == null) {
            return this.P.size() - 1;
        }
        if (!colorPolynomial.isONE()) {
            return this.P.size() - 1;
        }
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add(colorPolynomial);
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int n, int n2, ExpVector expVector) {
        boolean bl = this.red.get(n2).get(n);
        if (!bl) {
            logger.warn("c3.s false for " + n2 + " " + n);
            return bl;
        }
        for (int i = 0; i < this.P.size(); ++i) {
            ColorPolynomial<C> colorPolynomial;
            ExpVector expVector2;
            boolean bl2;
            if (n == i || n2 == i || !(bl2 = expVector.multipleOf(expVector2 = (colorPolynomial = this.P.get(i)).leadingExpVector()))) continue;
            if (i < n) {
                bl = this.red.get(n).get(i) || this.red.get(n2).get(i);
            } else if (n < i && i < n2) {
                bl = this.red.get(i).get(n) || this.red.get(n2).get(i);
            } else if (n2 < i) {
                boolean bl3 = bl = this.red.get(i).get(n) || this.red.get(i).get(n2);
            }
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

