/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ExtensionFieldBuilder;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RootFactory;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.QuotientRing;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExtensionFieldBuilderTest
extends TestCase {
    ExtensionFieldBuilder builder;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExtensionFieldBuilderTest.suite());
    }

    public ExtensionFieldBuilderTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ExtensionFieldBuilderTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.builder = null;
    }

    protected void tearDown() {
        this.builder = null;
        ComputerThreads.terminate();
    }

    public void testConstructionF0() {
        BigRational bigRational = new BigRational(1L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, new String[]{"w2"});
        Element element = genPolynomialRing.parse("w2^2 - 2");
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(element);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, new String[]{"x"});
        QuotientRing quotientRing = new QuotientRing(genPolynomialRing2);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(quotientRing, new String[]{"wx"});
        Element element2 = genPolynomialRing3.parse("wx^2 - x");
        AlgebraicNumberRing algebraicNumberRing2 = new AlgebraicNumberRing(element2);
        List list = algebraicNumberRing2.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        AlgebraicNumber algebraicNumber = algebraicNumberRing2.random(2);
        if (algebraicNumber.isZERO() || algebraicNumber.isONE()) {
            algebraicNumber = list.get(n - 1).sum(list.get(n - 2));
            algebraicNumber = algebraicNumber.multiply((AlgebraicNumber<MonoidElem>)algebraicNumber);
        }
        MonoidElem monoidElem = algebraicNumber.inverse();
        AlgebraicNumber<MonoidElem> algebraicNumber2 = algebraicNumber.multiply((AlgebraicNumber<MonoidElem>)monoidElem);
        ExtensionFieldBuilderTest.assertTrue((String)("e / e == 1 " + algebraicNumber2), (boolean)algebraicNumber2.isONE());
    }

    public void testConstructionF1() {
        this.builder = ExtensionFieldBuilder.baseField(new BigRational(1L));
        RingFactory ringFactory = this.builder.build();
        this.builder = this.builder.algebraicExtension("w2", "w2^2 - 2");
        ringFactory = this.builder.build();
        this.builder = this.builder.transcendentExtension("x");
        ringFactory = this.builder.build();
        this.builder = this.builder.algebraicExtension("wx", "wx^2 - x");
        ringFactory = this.builder.build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        RingElem ringElem = (RingElem)ringFactory.random(2);
        if (ringElem.isZERO() || ringElem.isONE()) {
            ringElem = (RingElem)((RingElem)list.get(n - 1)).sum((AbelianGroupElem)list.get(n - 2));
            ringElem = ringElem.multiply(ringElem);
        }
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply(ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)("e / e == 1 " + ringElem3), (boolean)ringElem3.isONE());
    }

    public void testConstructionF2() {
        this.builder = ExtensionFieldBuilder.baseField(new BigRational(1L));
        RingFactory ringFactory = this.builder.build();
        this.builder = this.builder.transcendentExtension("x");
        ringFactory = this.builder.build();
        this.builder = this.builder.algebraicExtension("w2", "w2^2 - 2");
        ringFactory = this.builder.build();
        this.builder = this.builder.algebraicExtension("wx", "wx^2 - x");
        ringFactory = this.builder.build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        RingElem ringElem = (RingElem)ringFactory.random(1);
        if (ringElem.isZERO() || ringElem.isONE()) {
            ringElem = (RingElem)((RingElem)list.get(n - 1)).sum((AbelianGroupElem)list.get(n - 2));
            ringElem = ringElem.multiply(ringElem);
        }
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply(ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)("e / e == 1 " + ringElem3), (boolean)ringElem3.isONE());
    }

    public void testConstructionF3() {
        RingFactory ringFactory = ExtensionFieldBuilder.baseField(new ModLongRing(7L)).algebraicExtension("w2", "w2^2 - 3").transcendentExtension("x").algebraicExtension("wx", "wx^7 - x").build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        RingElem ringElem = (RingElem)ringFactory.random(2);
        if (ringElem.isZERO() || ringElem.isONE()) {
            ringElem = (RingElem)((RingElem)list.get(n - 1)).sum((AbelianGroupElem)list.get(n - 2));
            ringElem = ringElem.multiply(ringElem);
        }
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply(ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)("e / e == 1 " + ringElem3), (boolean)ringElem3.isONE());
    }

    public void testConstructionR1() {
        RingFactory ringFactory = ExtensionFieldBuilder.baseField(new BigRational(1L)).realAlgebraicExtension("q", "q^3 - 3", "[1,2]").realAlgebraicExtension("w", "w^2 - q", "[1,2]").realAlgebraicExtension("s", "s^5 - 2", "[1,2]").build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        RingElem ringElem = (RingElem)ringFactory.random(2);
        if (ringElem.isZERO() || ringElem.isONE()) {
            ringElem = (RingElem)((RingElem)list.get(n - 1)).sum((AbelianGroupElem)list.get(n - 2));
            ringElem = ringElem.multiply(ringElem);
        }
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply(ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)("e / e == 1 " + ringElem3), (boolean)ringElem3.isONE());
    }

    public void testConstructionC1() {
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(new BigRational(1L));
        RingFactory ringFactory = ExtensionFieldBuilder.baseField(complexRing).complexAlgebraicExtension("w2", "w2^2 + 2", "[-1i0,1i2]").build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 3 " + n), (n == 3 ? 1 : 0) != 0);
        RingElem ringElem = (RingElem)ringFactory.random(2);
        if (ringElem.isZERO() || ringElem.isONE()) {
            ringElem = (RingElem)((RingElem)list.get(n - 1)).sum((AbelianGroupElem)list.get(n - 2));
            ringElem = ringElem.multiply(ringElem);
        }
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply(ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)("e / e == 1 " + ringElem3), (boolean)ringElem3.isONE());
    }

    public void testConstructionR2factory() {
        RingFactory ringFactory = ExtensionFieldBuilder.baseField(new BigRational(1L)).realAlgebraicExtension("q", "q^3 - 3", "[1,2]").realAlgebraicExtension("w", "w^2 - q", "[1,2]").realAlgebraicExtension("s", "s^5 - 2", "[1,2]").build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(ringFactory, new String[]{"y"});
        Element element = genPolynomialRing.parse("y^2 - w s");
        List list2 = RootFactory.realAlgebraicNumbers(element);
        ExtensionFieldBuilderTest.assertTrue((String)("#roots == 2 " + list2), (list2.size() == 2 ? 1 : 0) != 0);
        for (RealAlgebraicNumber<MonoidElem> realAlgebraicNumber : list2) {
            MonoidElem monoidElem = realAlgebraicNumber.inverse();
            RealAlgebraicNumber<MonoidElem> realAlgebraicNumber2 = realAlgebraicNumber.multiply(monoidElem);
            ExtensionFieldBuilderTest.assertTrue((String)("y / y == 1 " + realAlgebraicNumber2), (boolean)realAlgebraicNumber2.isONE());
        }
    }

    public void testConstructionM1() {
        RingFactory ringFactory = ExtensionFieldBuilder.baseField(new BigRational(1L)).algebraicExtension("q,w,s", "( q^3 - 3, w^2 - q, s^5 - 2)").build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ExtensionFieldBuilder.baseField(ringFactory).polynomialExtension("y").build();
        GenPolynomial<AbelianGroupElem> genPolynomial = genPolynomialRing.parse("y^2 - w s");
        RingElem ringElem = genPolynomial.trailingBaseCoefficient();
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)"r*t == 1: ", (boolean)ringElem3.isONE());
        genPolynomial = genPolynomial.multiply(genPolynomial.negate());
        genPolynomial = Power.positivePower(genPolynomial, 3L);
        ExtensionFieldBuilderTest.assertFalse((String)("elem == 0 " + genPolynomial), (boolean)genPolynomial.isZERO());
    }

    public void testConstructionM2() {
        RingFactory ringFactory = ExtensionFieldBuilder.baseField(new BigRational(1L)).algebraicExtension("q,w,s", "").build();
        List list = ringFactory.generators();
        int n = list.size();
        ExtensionFieldBuilderTest.assertTrue((String)("#gens == 4 " + n), (n == 4 ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ExtensionFieldBuilder.baseField(ringFactory).polynomialExtension("y").build();
        GenPolynomial<AbelianGroupElem> genPolynomial = genPolynomialRing.parse("y^2 - w s");
        RingElem ringElem = genPolynomial.trailingBaseCoefficient();
        RingElem ringElem2 = (RingElem)ringElem.inverse();
        RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
        ExtensionFieldBuilderTest.assertTrue((String)"r*t == 1: ", (boolean)ringElem3.isONE());
        genPolynomial = genPolynomial.multiply(genPolynomial.negate());
        genPolynomial = Power.positivePower(genPolynomial, 3L);
        ExtensionFieldBuilderTest.assertFalse((String)("elem == 0 " + genPolynomial), (boolean)genPolynomial.isZERO());
    }
}

