/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabinDD;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.ArrayList;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismNotSupportedException;

public class AcceptanceStreettDD
extends ArrayList<StreettPairDD>
implements AcceptanceOmegaDD {
    public AcceptanceStreettDD() {
    }

    public AcceptanceStreettDD(AcceptanceStreett acceptanceStreett, JDDVars jDDVars) {
        for (AcceptanceStreett.StreettPair streettPair : acceptanceStreett) {
            JDDNode jDDNode = JDD.Constant(0.0);
            Object object = IterableBitSet.getSetBits(streettPair.getR()).iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                jDDNode = JDD.SetVectorElement(jDDNode, jDDVars, n, 1.0);
            }
            object = JDD.Constant(0.0);
            Object object2 = IterableBitSet.getSetBits(streettPair.getG()).iterator();
            while (object2.hasNext()) {
                int n = (Integer)object2.next();
                object = JDD.SetVectorElement((JDDNode)object, jDDVars, n, 1.0);
            }
            object2 = new StreettPairDD(jDDNode, (JDDNode)object);
            this.add(object2);
        }
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        for (StreettPairDD streettPairDD : this) {
            if (streettPairDD.isBSCCAccepting(jDDNode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AcceptanceStreettDD clone() {
        AcceptanceStreettDD acceptanceStreettDD = new AcceptanceStreettDD();
        for (StreettPairDD streettPairDD : this) {
            acceptanceStreettDD.add(streettPairDD.clone());
        }
        return acceptanceStreettDD;
    }

    @Override
    public void intersect(JDDNode jDDNode) {
        for (StreettPairDD streettPairDD : this) {
            streettPairDD.intersect(jDDNode);
        }
    }

    @Override
    public void clear() {
        for (StreettPairDD streettPairDD : this) {
            streettPairDD.clear();
        }
        super.clear();
    }

    public AcceptanceStreettDD and(AcceptanceStreettDD acceptanceStreettDD) {
        AcceptanceStreettDD acceptanceStreettDD2 = new AcceptanceStreettDD();
        for (StreettPairDD streettPairDD : this) {
            acceptanceStreettDD2.add(streettPairDD.clone());
        }
        for (StreettPairDD streettPairDD : acceptanceStreettDD) {
            acceptanceStreettDD2.add(streettPairDD.clone());
        }
        return acceptanceStreettDD2;
    }

    @Deprecated
    public AcceptanceRabinDD complement() {
        return this.complementToRabin();
    }

    @Override
    public String toString() {
        Object object = "";
        for (StreettPairDD streettPairDD : this) {
            object = (String)object + streettPairDD.toString();
        }
        return object;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Streett pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.STREETT;
    }

    @Override
    public AcceptanceOmegaDD complement(AcceptanceType ... acceptanceTypeArray) throws PrismNotSupportedException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN)) {
            return this.complementToRabin();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    public AcceptanceRabinDD complementToRabin() {
        AcceptanceRabinDD acceptanceRabinDD = new AcceptanceRabinDD();
        for (StreettPairDD streettPairDD : this) {
            JDDNode jDDNode = streettPairDD.getG();
            JDDNode jDDNode2 = streettPairDD.getR();
            AcceptanceRabinDD.RabinPairDD rabinPairDD = new AcceptanceRabinDD.RabinPairDD(jDDNode, jDDNode2);
            acceptanceRabinDD.add(rabinPairDD);
        }
        return acceptanceRabinDD;
    }

    @Override
    public AcceptanceGenericDD toAcceptanceGeneric() {
        if (this.size() == 0) {
            return new AcceptanceGenericDD(true);
        }
        AcceptanceGenericDD acceptanceGenericDD = null;
        for (StreettPairDD streettPairDD : this) {
            AcceptanceGenericDD acceptanceGenericDD2 = streettPairDD.toAcceptanceGeneric();
            if (acceptanceGenericDD == null) {
                acceptanceGenericDD = acceptanceGenericDD2;
                continue;
            }
            acceptanceGenericDD = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.AND, acceptanceGenericDD, acceptanceGenericDD2);
        }
        return acceptanceGenericDD;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    public static class StreettPairDD {
        private JDDNode R;
        private JDDNode G;

        public StreettPairDD(JDDNode jDDNode, JDDNode jDDNode2) {
            this.R = jDDNode;
            this.G = jDDNode2;
        }

        public void clear() {
            if (this.R != null) {
                JDD.Deref(this.R);
            }
            if (this.G != null) {
                JDD.Deref(this.G);
            }
        }

        public JDDNode getR() {
            return this.R.copy();
        }

        public JDDNode getG() {
            return this.G.copy();
        }

        public StreettPairDD clone() {
            return new StreettPairDD(this.getR(), this.getG());
        }

        public boolean isBSCCAccepting(JDDNode jDDNode) {
            if (JDD.AreIntersecting(this.R, jDDNode)) {
                return JDD.AreIntersecting(this.G, jDDNode);
            }
            return true;
        }

        public AcceptanceGenericDD toAcceptanceGeneric() {
            AcceptanceGenericDD acceptanceGenericDD = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.FIN, this.getR());
            AcceptanceGenericDD acceptanceGenericDD2 = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF, this.getG());
            return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.OR, acceptanceGenericDD, acceptanceGenericDD2);
        }

        public void intersect(JDDNode jDDNode) {
            this.R = JDD.And(this.R, jDDNode.copy());
            this.G = JDD.And(this.G, jDDNode.copy());
        }

        public String toString() {
            return "(" + this.R + "->" + this.G + ")";
        }
    }
}

