/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReachDD;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import java.io.PrintStream;
import java.util.BitSet;
import jdd.JDDVars;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class AcceptanceReach
implements AcceptanceOmega {
    private BitSet goalStates = new BitSet();

    public AcceptanceReach() {
    }

    public AcceptanceReach(BitSet bitSet) {
        this.goalStates = bitSet;
    }

    public BitSet getGoalStates() {
        return this.goalStates;
    }

    public void setGoalStates(BitSet bitSet) {
        this.goalStates = bitSet;
    }

    @Override
    public AcceptanceReach clone() {
        return new AcceptanceReach((BitSet)this.goalStates.clone());
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        return bitSet.intersects(this.goalStates);
    }

    public AcceptanceRabin complementToRabin(int n) {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        BitSet bitSet = new BitSet();
        bitSet.set(0, n);
        acceptanceRabin.add(new AcceptanceRabin.RabinPair((BitSet)this.goalStates.clone(), bitSet));
        return acceptanceRabin;
    }

    public AcceptanceStreett complementToStreett(int n) {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        acceptanceStreett.add(new AcceptanceStreett.StreettPair((BitSet)this.goalStates.clone(), new BitSet()));
        return acceptanceStreett;
    }

    public AcceptanceGeneric complementToGeneric() {
        return this.toAcceptanceGeneric().complementToGeneric();
    }

    @Override
    public AcceptanceOmega complement(int n, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN)) {
            return this.complementToRabin(n);
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT)) {
            return this.complementToStreett(n);
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        this.goalStates = liftBitSet.lift(this.goalStates);
    }

    @Override
    public AcceptanceReachDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceReachDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        return new AcceptanceGeneric(AcceptanceGeneric.ElementType.INF, (BitSet)this.goalStates.clone());
    }

    @Override
    public String getSignatureForState(int n) {
        return this.goalStates.get(n) ? "!" : " ";
    }

    @Override
    public String getSignatureForStateHOA(int n) {
        if (this.goalStates.get(n)) {
            return "{0}";
        }
        return "";
    }

    public String toString() {
        return this.goalStates.toString();
    }

    @Override
    public String getSizeStatistics() {
        return this.goalStates.cardinality() + " goal states";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.REACH;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void outputHOAHeader(PrintStream printStream) {
        printStream.println("acc-name: Buchi");
        printStream.println("Acceptance: 1 Inf(0)");
    }
}

