/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreettDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import java.util.ArrayList;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismNotSupportedException;

public class AcceptanceRabinDD
extends ArrayList<RabinPairDD>
implements AcceptanceOmegaDD {
    public AcceptanceRabinDD() {
    }

    public AcceptanceRabinDD(AcceptanceRabin acceptanceRabin, JDDVars jDDVars) {
        for (AcceptanceRabin.RabinPair rabinPair : acceptanceRabin) {
            JDDNode jDDNode = JDD.Constant(0.0);
            Object object = IterableBitSet.getSetBits(rabinPair.getL()).iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                jDDNode = JDD.SetVectorElement(jDDNode, jDDVars, n, 1.0);
            }
            object = JDD.Constant(0.0);
            Object object2 = IterableBitSet.getSetBits(rabinPair.getK()).iterator();
            while (object2.hasNext()) {
                int n = (Integer)object2.next();
                object = JDD.SetVectorElement((JDDNode)object, jDDVars, n, 1.0);
            }
            object2 = new RabinPairDD(jDDNode, (JDDNode)object);
            this.add(object2);
        }
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        for (RabinPairDD rabinPairDD : this) {
            if (!rabinPairDD.isBSCCAccepting(jDDNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AcceptanceRabinDD clone() {
        AcceptanceRabinDD acceptanceRabinDD = new AcceptanceRabinDD();
        for (RabinPairDD rabinPairDD : this) {
            acceptanceRabinDD.add(rabinPairDD.clone());
        }
        return acceptanceRabinDD;
    }

    @Override
    public void intersect(JDDNode jDDNode) {
        for (RabinPairDD rabinPairDD : this) {
            rabinPairDD.intersect(jDDNode);
        }
    }

    @Deprecated
    public AcceptanceStreettDD complement() {
        return this.complementToStreett();
    }

    public AcceptanceRabinDD or(AcceptanceRabinDD acceptanceRabinDD) {
        AcceptanceRabinDD acceptanceRabinDD2 = new AcceptanceRabinDD();
        for (RabinPairDD rabinPairDD : this) {
            acceptanceRabinDD2.add(rabinPairDD.clone());
        }
        for (RabinPairDD rabinPairDD : acceptanceRabinDD) {
            acceptanceRabinDD2.add(rabinPairDD.clone());
        }
        return acceptanceRabinDD2;
    }

    @Override
    public void clear() {
        for (RabinPairDD rabinPairDD : this) {
            rabinPairDD.clear();
        }
        super.clear();
    }

    @Override
    public String toString() {
        Object object = "";
        for (RabinPairDD rabinPairDD : this) {
            object = (String)object + rabinPairDD.toString();
        }
        return object;
    }

    @Override
    public String getSizeStatistics() {
        return this.size() + " Rabin pairs";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.RABIN;
    }

    @Override
    public AcceptanceOmegaDD complement(AcceptanceType ... acceptanceTypeArray) throws PrismNotSupportedException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT)) {
            return this.complementToStreett();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    public AcceptanceStreettDD complementToStreett() {
        AcceptanceStreettDD acceptanceStreettDD = new AcceptanceStreettDD();
        for (RabinPairDD rabinPairDD : this) {
            JDDNode jDDNode = rabinPairDD.getK();
            JDDNode jDDNode2 = rabinPairDD.getL();
            AcceptanceStreettDD.StreettPairDD streettPairDD = new AcceptanceStreettDD.StreettPairDD(jDDNode, jDDNode2);
            acceptanceStreettDD.add(streettPairDD);
        }
        return acceptanceStreettDD;
    }

    @Override
    public AcceptanceGenericDD toAcceptanceGeneric() {
        if (this.size() == 0) {
            return new AcceptanceGenericDD(false);
        }
        AcceptanceGenericDD acceptanceGenericDD = null;
        for (RabinPairDD rabinPairDD : this) {
            AcceptanceGenericDD acceptanceGenericDD2 = rabinPairDD.toAcceptanceGeneric();
            if (acceptanceGenericDD == null) {
                acceptanceGenericDD = acceptanceGenericDD2;
                continue;
            }
            acceptanceGenericDD = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.OR, acceptanceGenericDD, acceptanceGenericDD2);
        }
        return acceptanceGenericDD;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    public static class RabinPairDD {
        private JDDNode L;
        private JDDNode K;

        public RabinPairDD(JDDNode jDDNode, JDDNode jDDNode2) {
            this.L = jDDNode;
            this.K = jDDNode2;
        }

        public void clear() {
            if (this.L != null) {
                JDD.Deref(this.L);
            }
            if (this.K != null) {
                JDD.Deref(this.K);
            }
        }

        public JDDNode getL() {
            return this.L.copy();
        }

        public JDDNode getK() {
            return this.K.copy();
        }

        public RabinPairDD clone() {
            return new RabinPairDD(this.getL(), this.getK());
        }

        public boolean isBSCCAccepting(JDDNode jDDNode) {
            if (JDD.AreIntersecting(this.L, jDDNode)) {
                return false;
            }
            return JDD.AreIntersecting(this.K, jDDNode);
        }

        public AcceptanceGenericDD toAcceptanceGeneric() {
            AcceptanceGenericDD acceptanceGenericDD = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.FIN, this.getL());
            AcceptanceGenericDD acceptanceGenericDD2 = new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF, this.getK());
            return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.AND, acceptanceGenericDD, acceptanceGenericDD2);
        }

        public void intersect(JDDNode jDDNode) {
            this.L = JDD.And(this.L, jDDNode.copy());
            this.K = JDD.And(this.K, jDDNode.copy());
        }

        public String toString() {
            return "(" + this.L + "," + this.K + ")";
        }
    }
}

