/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator.networking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import prism.PrismException;
import settings.FileSelector;
import settings.SettingTable;
import simulator.networking.FileSystem;
import simulator.networking.SSHHost;
import simulator.networking.SimulatorNetworkHandler;
import userinterface.GUIPrism;

public class GUINetworkEditor
extends JDialog
implements TreeSelectionListener,
MouseListener,
Observer,
FileSelector {
    public static final int CONTINUE = 0;
    public static final int CANCEL = 1;
    private SettingTable settingTable;
    private DefaultTreeModel treeModel;
    private SimulatorNetworkHandler networkHandler;
    private FileSystem selectedFileSystem = null;
    private SSHHost selectedHost = null;
    private JPopupMenu networkPopup;
    private JPopupMenu fileSystemPopup;
    private JPopupMenu hostPopup;
    private JMenu fileMenu;
    private JMenu editMenu;
    private Action newNetwork;
    private Action open;
    private Action save;
    private Action saveAs;
    private Action close;
    private Action cut;
    private Action copy;
    private Action paste;
    private Action delete;
    private ArrayList clipboardHosts;
    private ArrayList clipboardFSs;
    private boolean modified = false;
    private File activeFile = null;
    private FileNameExtensionFilter netFilter;
    private JPanel bottomPanel;
    private JButton jButton1;
    private JPanel jPanel1;
    private JTree networkTree;
    private JMenuBar theMenu;

    public GUINetworkEditor(Frame frame, SimulatorNetworkHandler simulatorNetworkHandler) {
        super(frame, true);
        this.setActiveFile(null);
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.initPopups();
        this.theMenu.add(this.fileMenu);
        this.theMenu.add(this.editMenu);
        this.networkHandler = simulatorNetworkHandler;
        simulatorNetworkHandler.addObserver(this);
        this.settingTable = new SettingTable(frame);
        this.bottomPanel.add((Component)this.settingTable, "Center");
        this.treeModel = new DefaultTreeModel(simulatorNetworkHandler);
        this.networkTree.setModel(this.treeModel);
        this.networkTree.setCellRenderer(new NetworkNodeRenderer());
        this.networkTree.addTreeSelectionListener(this);
        this.networkTree.addMouseListener(this);
        this.netFilter = new FileNameExtensionFilter("PRISM networks (*.xml)", "xml");
    }

    public int doModificationCheck() {
        if (!this.modified) {
            return 0;
        }
        if (!this.hasActiveFile()) {
            String[] stringArray = new String[]{"Yes", "No", "Cancel"};
            int n = -1;
            n = this.optionPane("Network profile has been modified.\nDo you wish to save it?", "Question", 2, 3, stringArray, stringArray[0]);
            switch (n) {
                case 0: {
                    return this.a_saveAs();
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return 1;
        }
        String[] stringArray = new String[]{"Yes", "No", "Save As...", "Cancel"};
        int n = -1;
        n = this.optionPane("Network profile has been modified.\nDo you wish to save it?", "Question", 2, 3, stringArray, stringArray[0]);
        switch (n) {
            case 0: {
                return this.a_save();
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.a_saveAs();
            }
            case 3: {
                return 1;
            }
        }
        return 1;
    }

    public void setActiveFile(File file) {
        this.activeFile = file;
        if (file == null) {
            this.setTitle("Network Profile <Untitled>");
        } else {
            this.setTitle("Network Profile " + file.getName());
        }
    }

    public boolean hasActiveFile() {
        return this.activeFile != null;
    }

    public void a_new() {
        int n = this.doModificationCheck();
        if (n == 0) {
            this.networkHandler.newNetwork("New Profile");
            this.treeModel.nodeStructureChanged(this.networkHandler);
            this.settingTable.setOwners(new ArrayList());
            this.modified = false;
        }
    }

    public void a_open() {
        int n = this.doModificationCheck();
        if (n == 0 && this.showOpenFileDialog(this.netFilter) == 0) {
            File file = GUIPrism.getGUI().getChooser().getSelectedFile();
            if (file == null) {
                this.errorDialog("Error: No file selected");
                return;
            }
            try {
                SimulatorNetworkHandler simulatorNetworkHandler = new SimulatorNetworkHandler();
                simulatorNetworkHandler.loadNetworkFromXML(file);
                this.modified = false;
                this.setActiveFile(file);
                this.networkHandler.deleteObservers();
                this.networkHandler = simulatorNetworkHandler;
                this.networkHandler.addObserver(this);
                this.treeModel.setRoot(this.networkHandler);
                this.treeModel.nodeStructureChanged(this.networkHandler);
                this.networkTree.revalidate();
            }
            catch (PrismException prismException) {
                this.errorDialog(prismException.getMessage());
            }
        }
    }

    public int a_save() {
        if (!this.hasActiveFile()) {
            return this.a_saveAs();
        }
        try {
            this.networkHandler.saveNetworkToXML(this.activeFile);
            this.modified = false;
            return 0;
        }
        catch (PrismException prismException) {
            this.errorDialog(prismException.getMessage());
            return 1;
        }
    }

    public int a_saveAs() {
        if (this.showSaveFileDialog(this.netFilter) != 0) {
            return 1;
        }
        try {
            File file = GUIPrism.getGUI().getChooser().getSelectedFile();
            this.networkHandler.saveNetworkToXML(file);
            this.setActiveFile(file);
            this.modified = false;
            return 0;
        }
        catch (PrismException prismException) {
            this.errorDialog(prismException.getMessage());
            return 1;
        }
    }

    public void a_close() {
        int n = this.doModificationCheck();
        if (n == 0) {
            this.hide();
        }
    }

    public void a_addNetworkCluster() {
        this.networkHandler.addFileSystem("New FileSystem", "~", "~");
        this.treeModel.nodesWereInserted(this.networkHandler, new int[]{this.networkHandler.getChildCount() - 1});
        this.modified = true;
    }

    public void a_cut() {
    }

    public void a_copy() {
        this.clipboardHosts = new ArrayList();
        this.clipboardFSs = new ArrayList();
        TreePath[] treePathArray = this.networkTree.getSelectionModel().getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreeNode treeNode;
            if (treePathArray[i].getLastPathComponent() instanceof SSHHost) {
                treeNode = (SSHHost)treePathArray[i].getLastPathComponent();
                this.clipboardHosts.add(treeNode);
                continue;
            }
            if (!(treePathArray[i].getLastPathComponent() instanceof FileSystem)) continue;
            treeNode = (FileSystem)treePathArray[i].getLastPathComponent();
            this.clipboardFSs.add(treeNode);
        }
        this.networkTree.setSelectionInterval(-1, -1);
    }

    public void a_paste() {
        if (this.selectedFileSystem != null) {
            if (this.clipboardHosts != null) {
                for (int i = 0; i < this.clipboardHosts.size(); ++i) {
                    SSHHost sSHHost = (SSHHost)this.clipboardHosts.get(i);
                    this.selectedFileSystem.addHost(sSHHost.getHostName(), sSHHost.getUserName());
                }
                this.treeModel.nodeStructureChanged(this.selectedFileSystem);
            }
        } else if (this.selectedHost == null && this.clipboardFSs != null) {
            int[] nArray = new int[this.clipboardFSs.size()];
            for (int i = 0; i < this.clipboardFSs.size(); ++i) {
                int n;
                FileSystem fileSystem = (FileSystem)this.clipboardFSs.get(i);
                nArray[i] = n = this.networkHandler.addFileSystem(fileSystem.getName(), fileSystem.getInputDir(), fileSystem.getOutputDir());
                FileSystem fileSystem2 = this.networkHandler.getFileSystem(n);
                for (int j = 0; j < fileSystem.getNumHosts(); ++j) {
                    SSHHost sSHHost = fileSystem.getHost(j);
                    fileSystem2.addHost(sSHHost.getHostName(), sSHHost.getUserName());
                    System.out.println("adding new hosts to new filesystem");
                }
            }
            this.treeModel.nodesWereInserted(this.networkHandler, nArray);
        }
        this.modified = true;
    }

    public void a_delete() {
        int n;
        TreePath[] treePathArray = this.networkTree.getSelectionModel().getSelectionPaths();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (n = 0; n < treePathArray.length; ++n) {
            if (!(treePathArray[n].getLastPathComponent() instanceof SSHHost)) continue;
            SSHHost sSHHost = (SSHHost)treePathArray[n].getLastPathComponent();
            ((FileSystem)sSHHost.getParent()).deleteHost(sSHHost);
            arrayList.add(sSHHost.getParent());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.treeModel.nodeStructureChanged((FileSystem)arrayList.get(n));
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!(treePathArray[i].getLastPathComponent() instanceof FileSystem)) continue;
            arrayList2.add(new Integer(this.networkHandler.getIndex((FileSystem)treePathArray[i].getLastPathComponent())));
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
        }
        Object[] objectArray = new Object[arrayList2.size()];
        int n2 = 0;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!(treePathArray[i].getLastPathComponent() instanceof FileSystem)) continue;
            FileSystem fileSystem = (FileSystem)treePathArray[i].getLastPathComponent();
            objectArray[n2++] = fileSystem;
            ((SimulatorNetworkHandler)fileSystem.getParent()).deleteFileSystem(fileSystem);
        }
        if (nArray.length > 0) {
            this.treeModel.nodesWereRemoved(this.networkHandler, nArray, objectArray);
        }
        this.settingTable.setOwners(new ArrayList());
        this.modified = true;
    }

    public void a_addHost() {
        if (this.selectedFileSystem != null) {
            this.selectedFileSystem.addHost("new_host", "user_name");
            this.treeModel.nodesWereInserted(this.selectedFileSystem, new int[]{this.selectedFileSystem.getChildCount() - 1});
            this.modified = true;
        }
    }

    public void a_testHosts() {
        TreePath[] treePathArray = this.networkTree.getSelectionModel().getSelectionPaths();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!(treePathArray[i].getLastPathComponent() instanceof SSHHost)) continue;
            SSHHost sSHHost = (SSHHost)treePathArray[i].getLastPathComponent();
            sSHHost.testHost();
        }
    }

    public void a_testAllHosts() {
        TreePath[] treePathArray = this.networkTree.getSelectionModel().getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!(treePathArray[i].getLastPathComponent() instanceof FileSystem)) continue;
            FileSystem fileSystem = (FileSystem)treePathArray[i].getLastPathComponent();
            for (int j = 0; j < fileSystem.getNumHosts(); ++j) {
                fileSystem.getHost(j).testHost();
            }
        }
    }

    public void a_testAll() {
        for (int i = 0; i < this.networkHandler.getNumFileSystems(); ++i) {
            FileSystem fileSystem = this.networkHandler.getFileSystem(i);
            for (int j = 0; j < fileSystem.getNumHosts(); ++j) {
                fileSystem.getHost(j).testHost();
            }
        }
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane();
        JScrollPane jScrollPane = new JScrollPane();
        this.networkTree = new JTree();
        this.bottomPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.theMenu = new JMenuBar();
        this.setDefaultCloseOperation(2);
        jSplitPane.setOrientation(0);
        this.networkTree.setPreferredSize(new Dimension(500, 300));
        jScrollPane.setViewportView(this.networkTree);
        jSplitPane.setLeftComponent(jScrollPane);
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.setPreferredSize(new Dimension(500, 300));
        jSplitPane.setRightComponent(this.bottomPanel);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.setJMenuBar(this.theMenu);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.a_close();
    }

    public void initPopups() {
        this.networkPopup = new JPopupMenu();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_addNetworkCluster();
            }
        };
        abstractAction.putValue("LongDescription", "Adds a new network cluster to the network profile.");
        abstractAction.putValue("MnemonicKey", new Integer(67));
        abstractAction.putValue("Name", "Add Network Cluster");
        abstractAction.putValue("SmallIcon", GUIPrism.getIconFromImage("smallAdd.png"));
        this.networkPopup.add(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_testAll();
            }
        };
        abstractAction2.putValue("LongDescription", "Test All");
        abstractAction2.putValue("Name", "Test");
        this.networkPopup.addSeparator();
        this.networkPopup.add(abstractAction2);
        this.networkPopup.addSeparator();
        this.fileSystemPopup = new JPopupMenu();
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_addHost();
            }
        };
        abstractAction3.putValue("LongDescription", "Adds a new host to the network cluster.");
        abstractAction3.putValue("MnemonicKey", new Integer(72));
        abstractAction3.putValue("Name", "Add Host");
        abstractAction3.putValue("SmallIcon", GUIPrism.getIconFromImage("smallAdd.png"));
        this.cut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_cut();
            }
        };
        this.cut.putValue("LongDescription", "Cut");
        this.cut.putValue("Name", "Cut");
        this.cut.putValue("MnemonicKey", new Integer(84));
        this.cut.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCut.png"));
        this.cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.copy = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_copy();
            }
        };
        this.copy.putValue("LongDescription", "Copy");
        this.copy.putValue("Name", "Copy");
        this.copy.putValue("MnemonicKey", new Integer(67));
        this.copy.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCopy.png"));
        this.copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.paste = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_paste();
            }
        };
        this.paste.putValue("LongDescription", "Paste");
        this.paste.putValue("Name", "Paste");
        this.paste.putValue("MnemonicKey", new Integer(80));
        this.paste.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPaste.png"));
        this.paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.delete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_delete();
            }
        };
        this.delete.putValue("LongDescription", "Delete");
        this.delete.putValue("Name", "Delete");
        this.delete.putValue("MnemonicKey", new Integer(68));
        this.delete.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.delete.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_testAllHosts();
            }
        };
        abstractAction4.putValue("LongDescription", "Test Hosts");
        abstractAction4.putValue("Name", "Test Hosts");
        this.fileSystemPopup.add(abstractAction3);
        this.fileSystemPopup.addSeparator();
        this.fileSystemPopup.add(abstractAction4);
        this.fileSystemPopup.addSeparator();
        this.fileSystemPopup.add(this.copy);
        this.fileSystemPopup.add(this.paste);
        this.fileSystemPopup.add(this.delete);
        AbstractAction abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_testHosts();
            }
        };
        abstractAction5.putValue("LongDescription", "Test");
        abstractAction5.putValue("Name", "Test");
        this.hostPopup = new JPopupMenu();
        this.hostPopup.add(abstractAction5);
        this.hostPopup.addSeparator();
        this.hostPopup.add(this.copy);
        this.hostPopup.add(this.delete);
        this.networkPopup.add(this.paste);
        this.editMenu = new JMenu("Edit");
        this.editMenu.add(this.copy);
        this.editMenu.add(this.paste);
        this.editMenu.add(this.delete);
        this.newNetwork = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_new();
            }
        };
        this.newNetwork.putValue("LongDescription", "New Profile");
        this.newNetwork.putValue("Name", "New Profile");
        this.newNetwork.putValue("MnemonicKey", new Integer(78));
        this.newNetwork.putValue("SmallIcon", GUIPrism.getIconFromImage("smallNew.png"));
        this.open = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_open();
            }
        };
        this.open.putValue("LongDescription", "Open Profile");
        this.open.putValue("Name", "Open Profile");
        this.open.putValue("MnemonicKey", new Integer(79));
        this.open.putValue("SmallIcon", GUIPrism.getIconFromImage("smallOpen.png"));
        this.save = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_save();
            }
        };
        this.save.putValue("LongDescription", "Save Profile");
        this.save.putValue("Name", "Save Profile");
        this.save.putValue("MnemonicKey", new Integer(83));
        this.save.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSave.png"));
        this.save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.saveAs = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_saveAs();
            }
        };
        this.saveAs.putValue("LongDescription", "Save Profile As...");
        this.saveAs.putValue("Name", "Save Profile As...");
        this.saveAs.putValue("MnemonicKey", new Integer(83));
        this.saveAs.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSaveAs.png"));
        this.saveAs.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.close = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUINetworkEditor.this.a_close();
            }
        };
        this.close.putValue("LongDescription", "Close");
        this.close.putValue("Name", "Close");
        this.close.putValue("MnemonicKey", new Integer(76));
        this.fileMenu = new JMenu("File");
        this.fileMenu.add(this.newNetwork);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.open);
        this.fileMenu.add(this.save);
        this.fileMenu.add(this.saveAs);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.close);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreePath[] treePathArray = this.networkTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            arrayList.add(treePathArray[i].getLastPathComponent());
        }
        this.settingTable.setOwners(arrayList);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.networkTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof SimulatorNetworkHandler) {
            this.selectedFileSystem = null;
            this.selectedHost = null;
        } else if (object instanceof FileSystem) {
            this.selectedFileSystem = (FileSystem)object;
            this.selectedHost = null;
        } else if (object instanceof SSHHost) {
            this.selectedHost = (SSHHost)object;
            this.selectedFileSystem = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePopupTrigger(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePopupTrigger(mouseEvent);
        }
    }

    public void mousePopupTrigger(MouseEvent mouseEvent) {
        TreePath treePath = this.networkTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return;
        }
        if (object instanceof SimulatorNetworkHandler) {
            this.selectedFileSystem = null;
            this.selectedHost = null;
            if (!this.isPathSelected(treePath)) {
                this.networkTree.setSelectionPath(treePath);
            }
            this.networkPopup.show(this.networkTree, mouseEvent.getX(), mouseEvent.getY());
        } else if (object instanceof FileSystem) {
            this.selectedFileSystem = (FileSystem)object;
            this.selectedHost = null;
            if (!this.isPathSelected(treePath)) {
                this.networkTree.setSelectionPath(treePath);
            }
            this.fileSystemPopup.show(this.networkTree, mouseEvent.getX(), mouseEvent.getY());
        } else if (object instanceof SSHHost) {
            this.selectedHost = (SSHHost)object;
            this.selectedFileSystem = null;
            if (!this.isPathSelected(treePath)) {
                this.networkTree.setSelectionPath(treePath);
            }
            this.hostPopup.show(this.networkTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.networkTree.getSelectionModel().isPathSelected(treePath);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof SSHHost) {
            this.treeModel.nodeChanged((SSHHost)object);
        } else if (object instanceof FileSystem) {
            this.treeModel.nodeChanged((FileSystem)object);
        } else if (object instanceof SimulatorNetworkHandler) {
            this.treeModel.nodeChanged((SimulatorNetworkHandler)object);
        }
        this.settingTable.refreshGroupNames();
        this.modified = true;
    }

    public int optionPane(String string, String string2, int n, int n2, String[] stringArray, String string3) {
        return JOptionPane.showOptionDialog(this, string, string2, n, n2, null, stringArray, string3);
    }

    public void errorDialog(String string) {
        this.errorDialog("Error", string);
    }

    public void errorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(this, string2, string, 0);
    }

    public int showOpenFileDialog(FileFilter fileFilter) {
        JFileChooser jFileChooser = GUIPrism.getGUI().getChooser();
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setSelectedFile(new File(""));
        return jFileChooser.showOpenDialog(this);
    }

    public int showSaveFileDialog(FileFilter fileFilter) {
        JFileChooser jFileChooser = GUIPrism.getGUI().getChooser();
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setSelectedFile(new File(""));
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return n;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            GUIPrism.getGUI().errorDialog("Error: No file selected");
            return 1;
        }
        if (file.exists()) {
            int n2 = 2;
            n2 = this.optionPane("File exists. Overwrite?", "Confirm Overwrite", 2, 3, null, null);
            if (n2 != 0) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public File getFile(Frame frame, File file) {
        this.modified = false;
        this.a_new();
        SimulatorNetworkHandler simulatorNetworkHandler = new SimulatorNetworkHandler();
        try {
            simulatorNetworkHandler.loadNetworkFromXML(file);
            this.modified = false;
            this.setActiveFile(file);
            this.networkHandler.deleteObservers();
            this.networkHandler = simulatorNetworkHandler;
            this.treeModel.setRoot(this.networkHandler);
            this.treeModel.nodeStructureChanged(this.networkHandler);
            this.networkHandler.addObserver(this);
        }
        catch (PrismException prismException) {
            this.setActiveFile(null);
            this.modified = true;
        }
        this.show();
        return this.activeFile;
    }

    class NetworkNodeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon NET = GUIPrism.getIconFromImage("smallNetwork.png");
        ImageIcon SERV = GUIPrism.getIconFromImage("smallServer.png");
        ImageIcon QUESTION_HOST = GUIPrism.getIconFromImage("smallQuestion.png");
        ImageIcon GOOD_HOST = GUIPrism.getIconFromImage("smallHost.png");
        ImageIcon ERROR_HOST = GUIPrism.getIconFromImage("smallError.png");
        ImageIcon RUNNING_HOST = GUIPrism.getIconFromImage("smallClockAnim1.png");

        NetworkNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TreeNode treeNode = (TreeNode)object;
            if (treeNode instanceof SimulatorNetworkHandler) {
                this.setIcon(this.NET);
            } else if (treeNode instanceof FileSystem) {
                this.setIcon(this.SERV);
            } else if (treeNode instanceof SSHHost) {
                SSHHost sSHHost = (SSHHost)treeNode;
                switch (sSHHost.getHostState()) {
                    case 0: {
                        this.setIcon(this.QUESTION_HOST);
                        break;
                    }
                    case 1: {
                        this.setIcon(this.GOOD_HOST);
                        break;
                    }
                    case 7: {
                        this.setIcon(this.ERROR_HOST);
                        this.setText(this.getText() + " (" + sSHHost.getErrorMessage() + ")");
                        break;
                    }
                    default: {
                        this.setIcon(this.RUNNING_HOST);
                    }
                }
            }
            return this;
        }
    }
}

