/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import prism.PrismException;
import userinterface.GUIPrism;
import userinterface.simulator.GUISimulatorPathTableModel;
import userinterface.simulator.SimulationView;

public class GUIViewDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private boolean askOption;
    private GUIPrism gui;
    private SimulationView view;
    private VariableListModel visibleVariableListModel;
    private VariableListModel hiddenVariableListModel;
    private RewardListModel visibleRewardListModel;
    private RewardListModel hiddenRewardListModel;
    private JPanel allPanel;
    private JPanel bottomPanel;
    private JPanel boxPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel centerRewardColumn;
    private JPanel centerRewardPanel;
    private JPanel centerVariableColumn;
    private JPanel centerVariablePanel;
    private JRadioButton changeRenderingButton;
    private JLabel hiddenLabel;
    private JList hiddenRewardList;
    private JScrollPane hiddenRewardScrollList;
    private JList hiddenVariableList;
    private JScrollPane hiddenVariableScrollList;
    private JPanel innerPathStylePanel;
    private JPanel innerTimePanel;
    private JPanel leftRewardColumn;
    private JPanel leftRewardPanel;
    private JPanel leftVariableColumn;
    private JPanel leftVariablePanel;
    private JButton makeRewardHiddenButton;
    private JButton makeRewardVisibleButton;
    private JButton makeVariableHiddenButton;
    private JButton makeVariableVisibleButton;
    private JButton okayButton;
    private JCheckBox optionCheckBox;
    private JPanel otherTabPanel;
    private ButtonGroup pathStyle;
    private JPanel pathStylePanel;
    private JRadioButton renderAllButton;
    private JPanel rewardPanel;
    private JPanel rewardTabPanel;
    private JPanel rightRewardColumn;
    private JPanel rightRewardPanel;
    private JPanel rightVariableColumn;
    private JPanel rightVariablePanel;
    private JButton selectAllHiddenRewardsButton;
    private JButton selectAllHiddenVariablesButton;
    private JButton selectAllVisibleRewardsButton;
    private JButton selectAllVisibleVariablesButton;
    private JCheckBox showCumulativeTimeCheckBox;
    private JCheckBox showTimeCheckBox;
    private JPanel topInnerTimePanel;
    private JPanel variablePanel;
    private JTabbedPane variableTabPane;
    private JPanel variableTabPanel;
    private JLabel visibleLabel;
    private JList visibleRewardList;
    private JScrollPane visibleRewardScrollList;
    private JList visibleVariableList;
    private JScrollPane visibleVariableScrollList;

    public GUIViewDialog(GUIPrism gUIPrism, SimulationView simulationView, GUISimulatorPathTableModel gUISimulatorPathTableModel) {
        super(gUIPrism, "Configure View for Simulation", true);
        this.gui = gUIPrism;
        this.view = simulationView;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        super.setBounds(new Rectangle(550, 300));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        this.askOption = this.gui.getPrism().getSettings().getBoolean("simulator.newPathAskView");
        this.optionCheckBox.setSelected(this.askOption);
        this.showTimeCheckBox.setSelected(simulationView.showTime());
        this.showCumulativeTimeCheckBox.setSelected(simulationView.showCumulativeTime());
        this.visibleVariableListModel = new VariableListModel(simulationView.getVisibleVariables());
        this.hiddenVariableListModel = new VariableListModel(simulationView.getHiddenVariables());
        this.visibleVariableList.setModel(this.visibleVariableListModel);
        this.hiddenVariableList.setModel(this.hiddenVariableListModel);
        ArrayList<RewardListItem> arrayList = new ArrayList<RewardListItem>();
        ArrayList<RewardListItem> arrayList2 = new ArrayList<RewardListItem>();
        for (SimulationView.RewardStructure object : simulationView.getRewards()) {
            arrayList2.add(new RewardListItem(object, false));
            arrayList2.add(new RewardListItem(object, true));
        }
        block1: for (SimulationView.RewardStructureColumn rewardStructureColumn : simulationView.getVisibleRewardColumns()) {
            for (RewardListItem rewardListItem : arrayList2) {
                if (!rewardStructureColumn.getRewardStructure().equals(rewardListItem.getRewardStructure()) || rewardStructureColumn.isCumulativeReward() != rewardListItem.isCumulative()) continue;
                arrayList.add(rewardListItem);
                arrayList2.remove(rewardListItem);
                continue block1;
            }
        }
        this.visibleRewardListModel = new RewardListModel(arrayList);
        this.hiddenRewardListModel = new RewardListModel(arrayList2);
        this.visibleRewardList.setModel(this.visibleRewardListModel);
        this.hiddenRewardList.setModel(this.hiddenRewardListModel);
        this.showCumulativeTimeCheckBox.setEnabled(gUISimulatorPathTableModel.canShowTime());
        this.showTimeCheckBox.setEnabled(gUISimulatorPathTableModel.canShowTime());
        this.pathStyle.add(this.renderAllButton);
        this.pathStyle.add(this.changeRenderingButton);
        this.renderAllButton.setSelected(!simulationView.isChangeRenderer());
        this.changeRenderingButton.setSelected(simulationView.isChangeRenderer());
        this.makeVariableHiddenButton.setIcon(GUIPrism.getIconFromImage("smallArrowRight.png"));
        this.makeRewardHiddenButton.setIcon(GUIPrism.getIconFromImage("smallArrowRight.png"));
        this.makeVariableVisibleButton.setIcon(GUIPrism.getIconFromImage("smallArrowLeft.png"));
        this.makeRewardVisibleButton.setIcon(GUIPrism.getIconFromImage("smallArrowLeft.png"));
        this.setVisible(true);
    }

    private void initComponents() {
        this.visibleLabel = new JLabel();
        this.hiddenLabel = new JLabel();
        this.pathStyle = new ButtonGroup();
        this.allPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.optionCheckBox = new JCheckBox();
        this.variableTabPane = new JTabbedPane();
        this.variableTabPanel = new JPanel();
        this.variablePanel = new JPanel();
        this.leftVariableColumn = new JPanel();
        this.leftVariablePanel = new JPanel();
        this.visibleVariableScrollList = new JScrollPane();
        this.visibleVariableList = new JList();
        this.selectAllVisibleVariablesButton = new JButton();
        this.centerVariableColumn = new JPanel();
        this.centerVariablePanel = new JPanel();
        this.makeVariableVisibleButton = new JButton();
        this.makeVariableHiddenButton = new JButton();
        this.rightVariableColumn = new JPanel();
        this.rightVariablePanel = new JPanel();
        this.hiddenVariableScrollList = new JScrollPane();
        this.hiddenVariableList = new JList();
        this.selectAllHiddenVariablesButton = new JButton();
        this.rewardTabPanel = new JPanel();
        this.rewardPanel = new JPanel();
        this.leftRewardColumn = new JPanel();
        this.leftRewardPanel = new JPanel();
        this.visibleRewardScrollList = new JScrollPane();
        this.visibleRewardList = new JList();
        this.selectAllVisibleRewardsButton = new JButton();
        this.centerRewardColumn = new JPanel();
        this.centerRewardPanel = new JPanel();
        this.makeRewardVisibleButton = new JButton();
        this.makeRewardHiddenButton = new JButton();
        this.rightRewardColumn = new JPanel();
        this.rightRewardPanel = new JPanel();
        this.hiddenRewardScrollList = new JScrollPane();
        this.hiddenRewardList = new JList();
        this.selectAllHiddenRewardsButton = new JButton();
        this.otherTabPanel = new JPanel();
        this.boxPanel = new JPanel();
        this.innerTimePanel = new JPanel();
        this.topInnerTimePanel = new JPanel();
        this.showTimeCheckBox = new JCheckBox();
        this.showCumulativeTimeCheckBox = new JCheckBox();
        this.pathStylePanel = new JPanel();
        this.innerPathStylePanel = new JPanel();
        this.changeRenderingButton = new JRadioButton();
        this.renderAllButton = new JRadioButton();
        this.visibleLabel.setHorizontalAlignment(0);
        this.visibleLabel.setText("Visible Variables");
        this.hiddenLabel.setHorizontalAlignment(0);
        this.hiddenLabel.setText("Hidden Variables");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIViewDialog.this.closeDialog(windowEvent);
            }
        });
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bottomPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.optionCheckBox.setText("Always prompt for view configuration on path creation");
        this.bottomPanel.add((Component)this.optionCheckBox, "West");
        this.optionCheckBox.getAccessibleContext().setAccessibleName("optionCheckBox");
        this.allPanel.add((Component)this.bottomPanel, "South");
        this.getContentPane().add((Component)this.allPanel, "South");
        this.variableTabPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.variableTabPanel.setLayout(new BorderLayout());
        this.variablePanel.setLayout(new GridBagLayout());
        this.variablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.leftVariableColumn.setLayout(new BorderLayout());
        this.leftVariableColumn.setBorder(BorderFactory.createTitledBorder("Visible variables"));
        this.leftVariablePanel.setLayout(new BorderLayout(0, 5));
        this.leftVariablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.visibleVariableScrollList.setHorizontalScrollBarPolicy(31);
        this.visibleVariableScrollList.setViewportView(this.visibleVariableList);
        this.leftVariablePanel.add((Component)this.visibleVariableScrollList, "Center");
        this.selectAllVisibleVariablesButton.setText("Select All");
        this.selectAllVisibleVariablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.selectAllVisibleVariablesButtonActionPerformed(actionEvent);
            }
        });
        this.leftVariablePanel.add((Component)this.selectAllVisibleVariablesButton, "South");
        this.leftVariableColumn.add((Component)this.leftVariablePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.variablePanel.add((Component)this.leftVariableColumn, gridBagConstraints);
        this.centerVariableColumn.setLayout(new BorderLayout());
        this.centerVariablePanel.setLayout(new GridBagLayout());
        this.makeVariableVisibleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.makeVariableVisibleButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.centerVariablePanel.add((Component)this.makeVariableVisibleButton, gridBagConstraints);
        this.makeVariableHiddenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.makeVariableHiddenButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.centerVariablePanel.add((Component)this.makeVariableHiddenButton, gridBagConstraints);
        this.centerVariableColumn.add((Component)this.centerVariablePanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.variablePanel.add((Component)this.centerVariableColumn, gridBagConstraints);
        this.rightVariableColumn.setLayout(new BorderLayout());
        this.rightVariableColumn.setBorder(BorderFactory.createTitledBorder("Hidden variables"));
        this.rightVariablePanel.setLayout(new BorderLayout(0, 5));
        this.rightVariablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.hiddenVariableScrollList.setHorizontalScrollBarPolicy(31);
        this.hiddenVariableScrollList.setViewportView(this.hiddenVariableList);
        this.rightVariablePanel.add((Component)this.hiddenVariableScrollList, "Center");
        this.selectAllHiddenVariablesButton.setText("Select All");
        this.selectAllHiddenVariablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.selectAllHiddenVariablesButtonActionPerformed(actionEvent);
            }
        });
        this.rightVariablePanel.add((Component)this.selectAllHiddenVariablesButton, "South");
        this.rightVariableColumn.add((Component)this.rightVariablePanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.variablePanel.add((Component)this.rightVariableColumn, gridBagConstraints);
        this.variableTabPanel.add((Component)this.variablePanel, "Center");
        this.variableTabPane.addTab("Variable visibility", this.variableTabPanel);
        this.rewardTabPanel.setLayout(new BorderLayout());
        this.rewardPanel.setLayout(new GridBagLayout());
        this.rewardPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.leftRewardColumn.setLayout(new BorderLayout());
        this.leftRewardColumn.setBorder(BorderFactory.createTitledBorder("Visible reward structures"));
        this.leftRewardPanel.setLayout(new BorderLayout(0, 5));
        this.leftRewardPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.visibleRewardScrollList.setHorizontalScrollBarPolicy(31);
        this.visibleRewardScrollList.setViewportView(this.visibleRewardList);
        this.leftRewardPanel.add((Component)this.visibleRewardScrollList, "Center");
        this.selectAllVisibleRewardsButton.setText("Select All");
        this.selectAllVisibleRewardsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.selectAllVisibleRewardsButtonActionPerformed(actionEvent);
            }
        });
        this.leftRewardPanel.add((Component)this.selectAllVisibleRewardsButton, "South");
        this.leftRewardColumn.add((Component)this.leftRewardPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.rewardPanel.add((Component)this.leftRewardColumn, gridBagConstraints);
        this.centerRewardColumn.setLayout(new BorderLayout());
        this.centerRewardPanel.setLayout(new GridBagLayout());
        this.makeRewardVisibleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.makeRewardVisibleButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.centerRewardPanel.add((Component)this.makeRewardVisibleButton, gridBagConstraints);
        this.makeRewardHiddenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.makeRewardHiddenButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.centerRewardPanel.add((Component)this.makeRewardHiddenButton, gridBagConstraints);
        this.centerRewardColumn.add((Component)this.centerRewardPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.rewardPanel.add((Component)this.centerRewardColumn, gridBagConstraints);
        this.rightRewardColumn.setLayout(new BorderLayout());
        this.rightRewardColumn.setBorder(BorderFactory.createTitledBorder("Hidden reward structures"));
        this.rightRewardPanel.setLayout(new BorderLayout(0, 5));
        this.rightRewardPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.hiddenRewardScrollList.setHorizontalScrollBarPolicy(31);
        this.hiddenRewardScrollList.setViewportView(this.hiddenRewardList);
        this.rightRewardPanel.add((Component)this.hiddenRewardScrollList, "Center");
        this.selectAllHiddenRewardsButton.setText("Select All");
        this.selectAllHiddenRewardsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIViewDialog.this.selectAllHiddenRewardsButtonActionPerformed(actionEvent);
            }
        });
        this.rightRewardPanel.add((Component)this.selectAllHiddenRewardsButton, "South");
        this.rightRewardColumn.add((Component)this.rightRewardPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.rewardPanel.add((Component)this.rightRewardColumn, gridBagConstraints);
        this.rewardTabPanel.add((Component)this.rewardPanel, "Center");
        this.variableTabPane.addTab("Reward visibility", this.rewardTabPanel);
        this.otherTabPanel.setLayout(new BorderLayout());
        this.boxPanel.setLayout(new BoxLayout(this.boxPanel, 1));
        this.boxPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerTimePanel.setLayout(new BorderLayout());
        this.innerTimePanel.setBorder(BorderFactory.createTitledBorder("Time properties"));
        this.topInnerTimePanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.topInnerTimePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.showTimeCheckBox.setText("Show the time spent in states");
        this.showTimeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showTimeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.topInnerTimePanel.add(this.showTimeCheckBox);
        this.showTimeCheckBox.getAccessibleContext().setAccessibleName("");
        this.showCumulativeTimeCheckBox.setText("Show the cumulative time");
        this.showCumulativeTimeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showCumulativeTimeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.topInnerTimePanel.add(this.showCumulativeTimeCheckBox);
        this.innerTimePanel.add((Component)this.topInnerTimePanel, "North");
        this.boxPanel.add(this.innerTimePanel);
        this.pathStylePanel.setLayout(new BorderLayout());
        this.pathStylePanel.setBorder(BorderFactory.createTitledBorder("Path style"));
        this.innerPathStylePanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.innerPathStylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.changeRenderingButton.setText("Render changes");
        this.changeRenderingButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.changeRenderingButton.setMargin(new Insets(0, 0, 0, 0));
        this.innerPathStylePanel.add(this.changeRenderingButton);
        this.renderAllButton.setText("Render all values");
        this.renderAllButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.renderAllButton.setMargin(new Insets(0, 0, 0, 0));
        this.innerPathStylePanel.add(this.renderAllButton);
        this.pathStylePanel.add((Component)this.innerPathStylePanel, "North");
        this.boxPanel.add(this.pathStylePanel);
        this.otherTabPanel.add((Component)this.boxPanel, "North");
        this.variableTabPane.addTab("Other", this.otherTabPanel);
        this.getContentPane().add((Component)this.variableTabPane, "Center");
    }

    private void selectAllHiddenRewardsButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[this.hiddenRewardListModel.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.hiddenRewardList.setSelectedIndices(nArray);
    }

    private void makeRewardHiddenButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.visibleRewardList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            RewardListItem rewardListItem = (RewardListItem)this.visibleRewardListModel.get(nArray[i]);
            this.visibleRewardListModel.removeReward(rewardListItem);
            this.hiddenRewardListModel.addReward(rewardListItem);
        }
    }

    private void makeRewardVisibleButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.hiddenRewardList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            RewardListItem rewardListItem = (RewardListItem)this.hiddenRewardListModel.get(nArray[i]);
            this.hiddenRewardListModel.removeReward(rewardListItem);
            this.visibleRewardListModel.addReward(rewardListItem);
        }
    }

    private void selectAllVisibleRewardsButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[this.visibleRewardListModel.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.visibleRewardList.setSelectedIndices(nArray);
    }

    private void selectAllVisibleVariablesButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[this.visibleVariableListModel.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.visibleVariableList.setSelectedIndices(nArray);
    }

    private void selectAllHiddenVariablesButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = new int[this.hiddenVariableListModel.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.hiddenVariableList.setSelectedIndices(nArray);
    }

    private void makeVariableVisibleButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.hiddenVariableList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            SimulationView.Variable variable = (SimulationView.Variable)this.hiddenVariableListModel.get(nArray[i]);
            this.hiddenVariableListModel.removeVariable(variable);
            this.visibleVariableListModel.addVariable(variable);
        }
    }

    private void makeVariableHiddenButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.visibleVariableList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            SimulationView.Variable variable = (SimulationView.Variable)this.visibleVariableListModel.get(nArray[i]);
            this.visibleVariableListModel.removeVariable(variable);
            this.hiddenVariableListModel.addVariable(variable);
        }
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        if (this.optionCheckBox.isSelected() != this.askOption) {
            this.askOption = !this.askOption;
            try {
                this.gui.getPrism().getSettings().set("simulator.newPathAskView", this.askOption);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        this.view.showTime(this.showTimeCheckBox.isSelected());
        this.view.showCumulativeTime(this.showCumulativeTimeCheckBox.isSelected());
        this.view.setVariableVisibility(this.visibleVariableListModel.getVariables(), this.hiddenVariableListModel.getVariables());
        this.view.setRenderer(this.changeRenderingButton.isSelected());
        this.view.setVisibleRewardListItems(this.visibleRewardListModel.getRewards());
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class RewardListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 1L;

        public RewardListModel(ArrayList<RewardListItem> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                super.add(i, arrayList.get(i));
            }
        }

        public void removeReward(RewardListItem rewardListItem) {
            for (int i = 0; i < super.getSize(); ++i) {
                RewardListItem rewardListItem2 = (RewardListItem)super.getElementAt(i);
                if (!rewardListItem2.equals(rewardListItem)) continue;
                super.remove(i);
            }
        }

        public void addReward(RewardListItem rewardListItem) {
            int n;
            for (n = 0; n < super.getSize() && ((RewardListItem)super.getElementAt(n)).getRewardStructure().getIndex() < rewardListItem.getRewardStructure().getIndex(); ++n) {
            }
            if (n < super.getSize() && ((RewardListItem)super.getElementAt(n)).getRewardStructure().getIndex() == rewardListItem.getRewardStructure().getIndex() && rewardListItem.isCumulative()) {
                ++n;
            }
            super.add(n, rewardListItem);
        }

        public ArrayList<RewardListItem> getRewards() {
            ArrayList<RewardListItem> arrayList = new ArrayList<RewardListItem>();
            for (int i = 0; i < super.getSize(); ++i) {
                arrayList.add((RewardListItem)super.getElementAt(i));
            }
            return arrayList;
        }
    }

    class RewardListItem {
        private SimulationView.RewardStructure rewardStructure;
        private boolean isCumulative;

        public RewardListItem(SimulationView.RewardStructure rewardStructure, boolean bl) {
            this.rewardStructure = rewardStructure;
            this.isCumulative = bl;
        }

        public String toString() {
            String string = this.rewardStructure.toString();
            if (this.isCumulative) {
                return string + " (cumulative)";
            }
            if (!this.rewardStructure.isStateEmpty() && !this.rewardStructure.isTransitionEmpty()) {
                return string + " (state and transition)";
            }
            if (!this.rewardStructure.isStateEmpty()) {
                return string + " (state)";
            }
            if (!this.rewardStructure.isTransitionEmpty()) {
                return string + " (transition)";
            }
            return string + " (empty)";
        }

        public boolean isCumulative() {
            return this.isCumulative;
        }

        public void setCumulative(boolean bl) {
            this.isCumulative = bl;
        }

        public SimulationView.RewardStructure getRewardStructure() {
            return this.rewardStructure;
        }

        public void setRewardStructure(SimulationView.RewardStructure rewardStructure) {
            this.rewardStructure = rewardStructure;
        }

        public boolean equals(Object object) {
            if (object instanceof RewardListItem) {
                RewardListItem rewardListItem = (RewardListItem)object;
                return rewardListItem.getRewardStructure().equals(this.rewardStructure) && rewardListItem.isCumulative() == this.isCumulative;
            }
            return false;
        }
    }

    class VariableListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 1L;

        public VariableListModel(ArrayList<SimulationView.Variable> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                super.add(i, arrayList.get(i));
            }
        }

        public void removeVariable(SimulationView.Variable variable) {
            for (int i = 0; i < super.getSize(); ++i) {
                SimulationView.Variable variable2 = (SimulationView.Variable)super.getElementAt(i);
                if (!variable2.equals(variable)) continue;
                super.remove(i);
            }
        }

        public void addVariable(SimulationView.Variable variable) {
            int n;
            for (n = 0; n < super.getSize() && ((SimulationView.Variable)super.getElementAt(n)).getIndex() < variable.getIndex(); ++n) {
            }
            super.add(n, variable);
        }

        public ArrayList<SimulationView.Variable> getVariables() {
            ArrayList<SimulationView.Variable> arrayList = new ArrayList<SimulationView.Variable>();
            for (int i = 0; i < super.getSize(); ++i) {
                arrayList.add((SimulationView.Variable)super.getElementAt(i));
            }
            return arrayList;
        }
    }
}

