/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import org.jfree.data.xy.XYDataItem;
import param.BigRational;
import parser.Values;
import prism.Interval;
import prism.PrismException;
import prism.ResultListener;
import prism.ResultsCollection;
import userinterface.graph.Graph;

public class GraphResultListener
implements ResultListener {
    private Graph graph;
    private Graph.SeriesKey seriesKey;
    private String rangeConstant;
    private Values otherValues;

    public GraphResultListener(Graph graph, Graph.SeriesKey seriesKey, String string, Values values) {
        this.graph = graph;
        this.seriesKey = seriesKey;
        this.rangeConstant = string;
        this.otherValues = values;
    }

    @Override
    public void notifyResult(ResultsCollection resultsCollection, Values values, Object object) {
        Object object2 = this.isInSeries(values);
        if (object2 != null) {
            double d;
            if (object2 instanceof Integer) {
                d = ((Integer)object2).intValue();
            } else if (object2 instanceof Double) {
                d = (Double)object2;
            } else if (object2 instanceof BigRational) {
                d = ((BigRational)object2).doubleValue();
            } else {
                return;
            }
            if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Double.isNaN(d)) {
                return;
            }
            if (object instanceof Double) {
                double d2 = (Double)object;
                this.graph.addPointToSeries(this.seriesKey, new XYDataItem(d, d2));
            } else if (object instanceof Integer) {
                double d3 = ((Integer)object).intValue();
                this.graph.addPointToSeries(this.seriesKey, new XYDataItem(d, d3));
            } else if (object instanceof BigRational) {
                double d4 = ((BigRational)object).doubleValue();
                this.graph.addPointToSeries(this.seriesKey, new XYDataItem(d, d4));
            } else if (object instanceof Interval) {
                Interval interval = (Interval)object;
                if (interval.lower instanceof Double) {
                    double d5 = (Double)interval.lower;
                    this.graph.addPointToSeries(this.seriesKey, new XYDataItem(d, d5));
                    d5 = (Double)interval.upper;
                    this.graph.addPointToSeries(this.seriesKey.next, new XYDataItem(d, d5));
                } else if (object instanceof Integer) {
                    double d6 = ((Integer)interval.lower).intValue();
                    this.graph.addPointToSeries(this.seriesKey, new XYDataItem(d, d6));
                    d6 = ((Integer)interval.upper).intValue();
                    this.graph.addPointToSeries(this.seriesKey.next, new XYDataItem(d, d6));
                }
            }
        }
    }

    private Object isInSeries(Values values) {
        for (int i = 0; i < this.otherValues.getNumValues(); ++i) {
            String string = this.otherValues.getName(i);
            Object object = this.otherValues.getValue(i);
            if (string.equals(this.rangeConstant)) continue;
            try {
                Object object2 = values.getValueOf(string);
                if (object2.equals(object)) continue;
                throw new PrismException("value not same");
            }
            catch (PrismException prismException) {
                return null;
            }
        }
        try {
            Object object = values.getValueOf(this.rangeConstant);
            return object;
        }
        catch (PrismException prismException) {
            return null;
        }
    }
}

