/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import parser.State;
import prism.ModelGenerator;
import prism.ModelInfo;
import prism.RewardGenerator;
import simulator.LoopDetector;
import simulator.Path;

public class PathOnTheFly
extends Path {
    protected ModelInfo modelInfo;
    protected boolean continuousTime;
    protected int numRewardStructs;
    protected long size;
    protected State previousState;
    protected State currentState;
    protected Object previousAction;
    protected String previousActionString;
    protected double previousProbability;
    protected double totalTime;
    double timeInPreviousState;
    protected double[] totalRewards;
    protected double[] previousStateRewards;
    protected double[] previousTransitionRewards;
    protected double[] currentStateRewards;
    protected LoopDetector loopDet;

    public PathOnTheFly(ModelInfo modelInfo, RewardGenerator rewardGenerator) {
        this.modelInfo = modelInfo;
        this.continuousTime = modelInfo.getModelType().continuousTime();
        this.numRewardStructs = rewardGenerator.getNumRewardStructs();
        this.previousState = new State(modelInfo.getNumVars());
        this.currentState = new State(modelInfo.getNumVars());
        this.totalRewards = new double[this.numRewardStructs];
        this.previousStateRewards = new double[this.numRewardStructs];
        this.previousTransitionRewards = new double[this.numRewardStructs];
        this.currentStateRewards = new double[this.numRewardStructs];
        this.clear();
        this.loopDet = new LoopDetector();
    }

    protected void clear() {
        this.size = 0L;
        this.previousState.clear();
        this.currentState.clear();
        this.totalTime = 0.0;
        this.timeInPreviousState = 0.0;
        for (int i = 0; i < this.numRewardStructs; ++i) {
            this.totalRewards[i] = 0.0;
            this.previousStateRewards[i] = 0.0;
            this.previousTransitionRewards[i] = 0.0;
            this.currentStateRewards[i] = 0.0;
        }
    }

    @Override
    public void initialise(State state, double[] dArray) {
        this.clear();
        this.currentState.copy(state);
        for (int i = 0; i < this.numRewardStructs; ++i) {
            this.currentStateRewards[i] = dArray[i];
        }
        this.loopDet.initialise();
    }

    @Override
    public void addStep(int n, Object object, String string, double d, double[] dArray, State state, double[] dArray2, ModelGenerator modelGenerator) {
        this.addStep(1.0, n, object, string, d, dArray, state, dArray2, modelGenerator);
    }

    @Override
    public void addStep(double d, int n, Object object, String string, double d2, double[] dArray, State state, double[] dArray2, ModelGenerator modelGenerator) {
        ++this.size;
        this.previousState.copy(this.currentState);
        this.currentState.copy(state);
        this.previousAction = object;
        this.previousActionString = string;
        this.previousProbability = d2;
        this.totalTime += d;
        this.timeInPreviousState = d;
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (this.continuousTime) {
                int n2 = i;
                this.totalRewards[n2] = this.totalRewards[n2] + (this.currentStateRewards[i] * d + dArray[i]);
            } else {
                int n3 = i;
                this.totalRewards[n3] = this.totalRewards[n3] + (this.currentStateRewards[i] + dArray[i]);
            }
            this.previousStateRewards[i] = this.currentStateRewards[i];
            this.previousTransitionRewards[i] = dArray[i];
            this.currentStateRewards[i] = dArray2[i];
        }
        this.loopDet.addStep(this, modelGenerator);
    }

    @Override
    public boolean continuousTime() {
        return this.continuousTime;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public State getPreviousState() {
        return this.previousState;
    }

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public Object getPreviousAction() {
        return this.previousAction;
    }

    @Override
    public String getPreviousActionString() {
        return this.previousActionString;
    }

    @Override
    public double getPreviousProbability() {
        return this.previousProbability;
    }

    @Override
    public double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public double getTimeInPreviousState() {
        return this.timeInPreviousState;
    }

    @Override
    public double getTotalCumulativeReward(int n) {
        return this.totalRewards[n];
    }

    @Override
    public double getPreviousStateReward(int n) {
        return this.previousStateRewards[n];
    }

    @Override
    public double[] getPreviousStateRewards() {
        return this.previousStateRewards;
    }

    @Override
    public double getPreviousTransitionReward(int n) {
        return this.previousTransitionRewards[n];
    }

    @Override
    public double[] getPreviousTransitionRewards() {
        return this.previousTransitionRewards;
    }

    @Override
    public double getCurrentStateReward(int n) {
        return this.currentStateRewards[n];
    }

    @Override
    public double[] getCurrentStateRewards() {
        return this.currentStateRewards;
    }

    @Override
    public boolean isLooping() {
        return this.loopDet.isLooping();
    }

    @Override
    public long loopStart() {
        return this.loopDet.loopStart();
    }

    @Override
    public long loopEnd() {
        return this.loopDet.loopEnd();
    }
}

