/*
 * Decompiled with CFR 0.152.
 */
package settings;

import settings.IntegerEditor;
import settings.IntegerRenderer;
import settings.NumericConstraint;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public class IntegerSetting
extends Setting {
    private static IntegerRenderer renderer;
    private static IntegerEditor editor;

    public IntegerSetting(String string, Integer n, String string2, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)n, string2, settingOwner, bl);
    }

    public IntegerSetting(String string, Integer n, String string2, SettingOwner settingOwner, boolean bl, NumericConstraint numericConstraint) {
        super(string, n, string2, settingOwner, bl, numericConstraint);
    }

    @Override
    public SettingEditor getSettingEditor() {
        if (editor == null) {
            editor = new IntegerEditor();
        }
        return editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        if (renderer == null) {
            renderer = new IntegerRenderer();
        }
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return Integer.class;
    }

    public int getIntegerValue() {
        return (Integer)this.getValue();
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingException("Error when parsing: " + string + " as an Integer value.");
        }
    }

    @Override
    public String toString() {
        return "" + this.getIntegerValue();
    }
}

