/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.Collections;
import java.util.List;
import parser.State;
import prism.ModelInfo;
import prism.PrismException;

public interface ModelGenerator
extends ModelInfo {
    default public boolean hasSingleInitialState() throws PrismException {
        return true;
    }

    default public List<State> getInitialStates() throws PrismException {
        return Collections.singletonList(this.getInitialState());
    }

    public State getInitialState() throws PrismException;

    public void exploreState(State var1) throws PrismException;

    public int getNumChoices() throws PrismException;

    default public int getNumTransitions() throws PrismException {
        int n = 0;
        int n2 = this.getNumChoices();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumTransitions(i);
        }
        return n;
    }

    public int getNumTransitions(int var1) throws PrismException;

    default public int getChoiceIndexOfTransition(int n) throws PrismException {
        int n2 = 0;
        int n3 = this.getNumChoices();
        for (int i = 0; i < n3; ++i) {
            if (n >= (n2 += this.getNumTransitions(i))) continue;
            return i;
        }
        return -1;
    }

    default public int getChoiceOffsetOfTransition(int n) throws PrismException {
        int n2 = 0;
        int n3 = this.getNumChoices();
        for (int i = 0; i < n3; ++i) {
            if (n >= (n2 += this.getNumTransitions(i))) continue;
            return n - (n2 - this.getNumTransitions(i));
        }
        return -1;
    }

    default public int getTotalIndexOfTransition(int n, int n2) throws PrismException {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += this.getNumTransitions(i);
        }
        return n3 + n2;
    }

    default public boolean isDeadlock() throws PrismException {
        return this.getNumChoices() == 0;
    }

    public Object getTransitionAction(int var1, int var2) throws PrismException;

    default public String getTransitionActionString(int n, int n2) throws PrismException {
        Object object = this.getTransitionAction(n, n2);
        return object == null ? "" : object.toString();
    }

    default public Object getChoiceAction(int n) throws PrismException {
        return this.getTransitionAction(n, 0);
    }

    default public String getChoiceActionString(int n) throws PrismException {
        Object object = this.getChoiceAction(n);
        return object == null ? "" : object.toString();
    }

    public double getTransitionProbability(int var1, int var2) throws PrismException;

    default public double getChoiceProbabilitySum(int n) throws PrismException {
        int n2 = this.getNumTransitions(n);
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += this.getTransitionProbability(n, i);
        }
        return d;
    }

    default public double getProbabilitySum() throws PrismException {
        int n = this.getNumChoices();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.getChoiceProbabilitySum(i);
        }
        return d;
    }

    default public boolean isDeterministic() throws PrismException {
        return this.getNumChoices() == 1 && this.getNumTransitions(0) == 1 && this.getTransitionProbability(0, 0) == 1.0;
    }

    default public String getTransitionUpdateString(int n, int n2) throws PrismException {
        State state = this.computeTransitionTarget(n, n2);
        Object object = "";
        int n3 = this.getNumVars();
        for (int i = 0; i < n3; ++i) {
            object = (String)object + (i > 0 ? ", " : "") + this.getVarName(i) + "'=" + state.varValues[i];
        }
        return object;
    }

    default public String getTransitionUpdateStringFull(int n, int n2) throws PrismException {
        return this.getTransitionUpdateString(n, n2);
    }

    public State computeTransitionTarget(int var1, int var2) throws PrismException;

    default public boolean isLabelTrue(String string) throws PrismException {
        int n = this.getLabelIndex(string);
        if (n == -1) {
            throw new PrismException("Label \"" + string + "\" not defined");
        }
        return this.isLabelTrue(n);
    }

    default public boolean isLabelTrue(int n) throws PrismException {
        throw new PrismException("Label number \"" + n + "\" not defined");
    }
}

