/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Update;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class Updates
extends ASTElement {
    private ArrayList<Expression> probs = new ArrayList();
    private ArrayList<Update> updates = new ArrayList();
    private Command parent = null;

    public void addUpdate(Expression expression, Update update) {
        this.probs.add(expression);
        this.updates.add(update);
        update.setParent(this);
    }

    public void setUpdate(int n, Update update) {
        this.updates.set(n, update);
        update.setParent(this);
    }

    public void setProbability(int n, Expression expression) {
        this.probs.set(n, expression);
    }

    public void setParent(Command command) {
        this.parent = command;
    }

    public int getNumUpdates() {
        return this.updates.size();
    }

    public Update getUpdate(int n) {
        return this.updates.get(n);
    }

    public List<Update> getUpdates() {
        return this.updates;
    }

    public Expression getProbability(int n) {
        return this.probs.get(n);
    }

    public double getProbabilityInState(int n, State state) throws PrismLangException {
        Expression expression = this.probs.get(n);
        return expression == null ? 1.0 : expression.evaluateDouble(state);
    }

    public Command getParent() {
        return this.parent;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.getNumUpdates();
        for (int i = 0; i < n - 1; ++i) {
            if (this.getProbability(i) != null) {
                object = (String)object + this.getProbability(i) + " : ";
            }
            object = (String)object + this.getUpdate(i) + " + ";
        }
        if (this.getProbability(n - 1) != null) {
            object = (String)object + this.getProbability(n - 1) + " : ";
        }
        object = (String)object + this.getUpdate(n - 1);
        return object;
    }

    @Override
    public ASTElement deepCopy() {
        Updates updates = new Updates();
        int n = this.getNumUpdates();
        for (int i = 0; i < n; ++i) {
            Expression expression = this.getProbability(i);
            if (expression != null) {
                expression = expression.deepCopy();
            }
            updates.addUpdate(expression, (Update)this.getUpdate(i).deepCopy());
        }
        updates.setPosition(this);
        return updates;
    }
}

