/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import prism.PrismLangException;

public class ExpressionVar
extends Expression {
    private String name;
    private int index;

    public ExpressionVar(String string, Type type) {
        this.setType(type);
        this.name = string;
        this.index = -1;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = evaluateContext.getVarValue(this.name, this.index);
        if (object == null) {
            throw new PrismLangException("Could not evaluate variable", this);
        }
        return object;
    }

    @Override
    public BigRational evaluateExact(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = evaluateContext.getVarValue(this.name, this.index);
        if (object == null) {
            throw new PrismLangException("Could not evaluate variable", this);
        }
        return BigRational.from(object);
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Expression deepCopy() {
        ExpressionVar expressionVar = new ExpressionVar(this.name, this.type);
        expressionVar.setIndex(this.index);
        expressionVar.setPosition(this);
        return expressionVar;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.index;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionVar expressionVar = (ExpressionVar)object;
        if (this.index != expressionVar.index) {
            return false;
        }
        return !(this.name == null ? expressionVar.name != null : !this.name.equals(expressionVar.name));
    }
}

