/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import parser.State;
import parser.Values;
import parser.ast.Declaration;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.PrismLangException;
import prism.PrismUtils;

public class VarList {
    private List<Var> vars = new ArrayList<Var>();
    private Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private int totalNumBits = 0;

    public VarList() {
    }

    public VarList(ModulesFile modulesFile) throws PrismLangException {
        this();
        Declaration declaration;
        int n;
        int n2 = modulesFile.getNumGlobals();
        for (n = 0; n < n2; ++n) {
            declaration = modulesFile.getGlobal(n);
            this.addVar(declaration, -1, modulesFile.getConstantValues());
        }
        n2 = modulesFile.getNumModules();
        for (n = 0; n < n2; ++n) {
            Module module = modulesFile.getModule(n);
            int n3 = module.getNumDeclarations();
            for (int i = 0; i < n3; ++i) {
                declaration = module.getDeclaration(i);
                this.addVar(declaration, n, modulesFile.getConstantValues());
            }
        }
    }

    public void addVar(Declaration declaration, int n, Values values) throws PrismLangException {
        Var var = this.createVar(declaration, n, values);
        this.vars.add(var);
        this.totalNumBits += this.getRangeLogTwo(this.vars.size() - 1);
        this.nameMap.put(declaration.getName(), this.vars.size() - 1);
    }

    public void addVar(int n, Declaration declaration, int n2, Values values) throws PrismLangException {
        Var var = this.createVar(declaration, n2, values);
        this.vars.add(n, var);
        this.totalNumBits += this.getRangeLogTwo(n);
        int n3 = this.getNumVars();
        this.nameMap = new HashMap<String, Integer>(n3);
        for (int i = 0; i < n3; ++i) {
            this.nameMap.put(this.getName(i), i);
        }
    }

    private Var createVar(Declaration declaration, int n, Values values) throws PrismLangException {
        int n2;
        int n3;
        int n4;
        Var var = new Var();
        var.decl = declaration;
        var.module = n;
        DeclarationType declarationType = declaration.getDeclType();
        if (declarationType instanceof DeclarationInt) {
            DeclarationInt declarationInt = (DeclarationInt)declarationType;
            n4 = declarationInt.getLow().evaluateInt(values);
            n3 = declarationInt.getHigh().evaluateInt(values);
            n2 = declaration.getStartOrDefault().evaluateInt(values);
            if (n3 - n4 <= 0) {
                String string = "Invalid range (" + n4 + "-" + n3 + ") for variable \"" + declaration.getName() + "\"";
                throw new PrismLangException(string, declaration);
            }
            if ((long)n3 - (long)n4 >= Integer.MAX_VALUE) {
                String string = "Range for variable \"" + declaration.getName() + "\" (" + n4 + "-" + n3 + ") is too big";
                throw new PrismLangException(string, declaration);
            }
            if (n2 < n4 || n2 > n3) {
                String string = "Invalid initial value (" + n2 + ") for variable \"" + declaration.getName() + "\"";
                throw new PrismLangException(string, declaration);
            }
        } else if (declarationType instanceof DeclarationBool) {
            n4 = 0;
            n3 = 1;
            n2 = declaration.getStartOrDefault().evaluateBoolean(values) ? 1 : 0;
        } else if (declarationType instanceof DeclarationClock) {
            n4 = 0;
            n3 = 1;
            n2 = 0;
        } else if (declarationType instanceof DeclarationIntUnbounded) {
            n4 = 0;
            n3 = 1;
            n2 = declaration.getStartOrDefault().evaluateInt(values);
        } else {
            throw new PrismLangException("Unknown variable type \"" + declarationType + "\" in declaration", declaration);
        }
        var.low = n4;
        var.high = n3;
        var.start = n2;
        return var;
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public int getIndex(String string) {
        Integer n = this.nameMap.get(string);
        return n == null ? -1 : n;
    }

    public boolean exists(String string) {
        return this.getIndex(string) != -1;
    }

    public Declaration getDeclaration(int n) {
        return this.vars.get((int)n).decl;
    }

    public int getIndexFromDeclaration(Declaration declaration) {
        for (int i = 0; i < this.vars.size(); ++i) {
            if (this.vars.get((int)i).decl != declaration) continue;
            return i;
        }
        return -1;
    }

    public String getName(int n) {
        return this.vars.get((int)n).decl.getName();
    }

    public Type getType(int n) {
        return this.vars.get((int)n).decl.getDeclType().getType();
    }

    public int getModule(int n) {
        return this.vars.get((int)n).module;
    }

    public int getLow(int n) {
        return this.vars.get((int)n).low;
    }

    public int getHigh(int n) {
        return this.vars.get((int)n).high;
    }

    public int getRange(int n) {
        return this.vars.get((int)n).high - this.vars.get((int)n).low + 1;
    }

    public int getRangeLogTwo(int n) {
        return (int)Math.ceil(PrismUtils.log2(this.getRange(n)));
    }

    public int getTotalNumBits() {
        return this.totalNumBits;
    }

    public int getStart(int n) {
        return this.vars.get((int)n).start;
    }

    public Object decodeFromInt(int n, int n2) {
        Type type = this.getType(n);
        if (type instanceof TypeInt) {
            return new Integer(n2 + this.getLow(n));
        }
        if (type instanceof TypeBool) {
            return new Boolean(n2 != 0);
        }
        return null;
    }

    public int encodeToInt(int n, Object object) throws PrismLangException {
        Type type = this.getType(n);
        try {
            if (type instanceof TypeInt) {
                return (Integer)object - this.getLow(n);
            }
            if (type instanceof TypeBool) {
                return (Boolean)object != false ? 1 : 0;
            }
            throw new PrismLangException("Unknown type " + type + " for variable " + this.getName(n));
        }
        catch (ClassCastException classCastException) {
            throw new PrismLangException("Value " + object + " is wrong type for variable " + this.getName(n));
        }
    }

    public int encodeToIntFromString(int n, String string) throws PrismLangException {
        Type type = this.getType(n);
        if (type instanceof TypeInt) {
            try {
                int n2 = Integer.parseInt(string);
                return n2 - this.getLow(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismLangException("\"" + string + "\" is not a valid integer value");
            }
        }
        if (type instanceof TypeBool) {
            if (string.equals("true")) {
                return 1;
            }
            if (string.equals("false")) {
                return 0;
            }
            throw new PrismLangException("\"" + string + "\" is not a valid Boolean value");
        }
        throw new PrismLangException("Unknown type " + type + " for variable " + this.getName(n));
    }

    public List<Values> getAllValues(List<String> list) throws PrismLangException {
        Vector<Values> vector = new Vector<Values>();
        vector.add(new Values());
        for (String string : list) {
            Values values;
            Values values2;
            int n;
            int n2;
            int n3 = this.getIndex(string);
            if (this.getType(n3) instanceof TypeBool) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    values2 = vector.get(n);
                    values = new Values(values2);
                    values.setValue(string, true);
                    vector.add(values);
                    values2.addValue(string, false);
                }
                continue;
            }
            if (this.getType(n3) instanceof TypeInt) {
                int n4 = this.getLow(n3);
                int n5 = this.getHigh(n3);
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    values2 = vector.get(n);
                    for (int i = n4 + 1; i < n5 + 1; ++i) {
                        values = new Values(values2);
                        values.setValue(string, i);
                        vector.add(values);
                    }
                    values2.addValue(string, n4);
                }
                continue;
            }
            throw new PrismLangException("Cannot determine all values for a variable of type " + this.getType(n3));
        }
        return vector;
    }

    public List<State> getAllStates() throws PrismLangException {
        int n = this.getNumVars();
        ArrayList<State> arrayList = new ArrayList<State>();
        arrayList.add(new State(n));
        for (int i = 0; i < n; ++i) {
            State state;
            State state2;
            int n2;
            int n3;
            if (this.getType(i) instanceof TypeBool) {
                n3 = arrayList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    state2 = (State)arrayList.get(n2);
                    state = new State(state2);
                    state.setValue(i, true);
                    state2.setValue(i, false);
                    arrayList.add(state);
                }
                continue;
            }
            if (this.getType(i) instanceof TypeInt) {
                n3 = this.getLow(i);
                n2 = this.getHigh(i);
                int n4 = arrayList.size();
                for (int j = 0; j < n4; ++j) {
                    state2 = (State)arrayList.get(j);
                    for (int k = n3 + 1; k < n2 + 1; ++k) {
                        state = new State(state2);
                        state.setValue(i, k);
                        arrayList.add(state);
                    }
                    state2.setValue(i, n3);
                }
                continue;
            }
            throw new PrismLangException("Cannot determine all values for a variable of type " + this.getType(i));
        }
        return arrayList;
    }

    public State convertBitSetToState(BitSet bitSet) {
        State state = new State(this.getNumVars());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.totalNumBits;
        for (int i = 0; i < n4; ++i) {
            if (bitSet.get(i)) {
                n2 += 1 << this.getRangeLogTwo(n3) - n - 1;
            }
            if (n >= this.getRangeLogTwo(n3) - 1) {
                state.setValue(n3, this.decodeFromInt(n3, n2));
                ++n3;
                n2 = 0;
                n = 0;
                continue;
            }
            ++n;
        }
        return state;
    }

    public Object clone() {
        int n = this.getNumVars();
        VarList varList = new VarList();
        varList.vars = new ArrayList<Var>(n);
        varList.nameMap = new HashMap<String, Integer>(n);
        for (int i = 0; i < n; ++i) {
            varList.vars.add(new Var(this.vars.get(i)));
            varList.nameMap.put(this.getName(i), i);
        }
        return varList;
    }

    class Var {
        public Declaration decl;
        public int module;
        public int low;
        public int high;
        public int start;

        public Var() {
        }

        public Var(Var var) {
            this.decl = (Declaration)var.decl.deepCopy();
            this.module = var.module;
            this.low = var.low;
            this.high = var.high;
            this.start = var.start;
        }
    }
}

