/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreett;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2dstar.DA;
import jltl2dstar.DAUnionAlgorithm;
import jltl2dstar.DA_State;
import jltl2dstar.RabinAcceptance;
import prism.PrismException;

public class DRA
extends DA {
    private boolean _isStreett = false;

    public DRA(APSet aPSet) {
        super(aPSet);
    }

    public static DRA newInstance(APSet aPSet) {
        return new DRA(aPSet);
    }

    private String typeID() {
        if (this.isStreett()) {
            return "DSA";
        }
        return "DRA";
    }

    public boolean isStreett() {
        return this._isStreett;
    }

    public void considerAsStreett(boolean bl) {
        this._isStreett = bl;
    }

    public void print(PrintStream printStream) throws PrismException {
        if (!this.isCompact()) {
            this.makeCompact();
        }
        this.print(this.typeID(), printStream);
    }

    public void printDot(PrintStream printStream) throws PrismException {
        if (!this.isCompact()) {
            this.makeCompact();
        }
        this.printDot(this.typeID(), printStream);
    }

    public void optimizeAcceptanceCondition() throws PrismException {
        for (Integer n : this.acceptance()) {
            if (this.acceptance().getAcceptance_L(n) == null) continue;
            if (this.acceptance().getAcceptance_L(n).intersects(this.acceptance().getAcceptance_U(n))) {
                this.acceptance().getAcceptance_L(n).andNot(this.acceptance().getAcceptance_U(n));
            }
            if (!this.acceptance().getAcceptance_L(n).isEmpty()) continue;
            this.acceptance().removeAcceptancePair(n);
        }
    }

    public DRA calculateUnion(DRA dRA, boolean bl, boolean bl2) throws PrismException {
        if (this.isStreett() || dRA.isStreett()) {
            throw new PrismException("Can not calculate union for Streett automata");
        }
        return DAUnionAlgorithm.calculateUnion(this, dRA, bl, bl2);
    }

    public automata.DA<BitSet, ? extends AcceptanceOmega> createPrismDA() throws PrismException {
        int n = this.size();
        if (!this.isStreett()) {
            automata.DA dA = new automata.DA(n);
            this.createPrismDA(dA);
            AcceptanceRabin acceptanceRabin = this.createRabinAcceptance();
            dA.setAcceptance(acceptanceRabin);
            return dA;
        }
        automata.DA dA = new automata.DA(n);
        this.createPrismDA(dA);
        AcceptanceStreett acceptanceStreett = this.createStreettAcceptance();
        dA.setAcceptance(acceptanceStreett);
        return dA;
    }

    private void createPrismDA(automata.DA<BitSet, ?> dA) throws PrismException {
        int n;
        int n2 = this.getAPSize();
        int n3 = this.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(this.getAPSet().getAP(n));
        }
        dA.setAPList(arrayList);
        dA.setStartState(this.getStartState().getName());
        for (n = 0; n < n3; ++n) {
            DA_State dA_State = this.get(n);
            int n4 = dA_State.getName();
            for (Map.Entry<APElement, DA_State> entry : dA_State.edges().entrySet()) {
                int n5 = entry.getValue().getName();
                BitSet bitSet = new BitSet();
                for (int i = 0; i < n2; ++i) {
                    bitSet.set(i, entry.getKey().get(i));
                }
                dA.addEdge(n4, bitSet, n5);
            }
        }
    }

    private AcceptanceRabin createRabinAcceptance() throws PrismException {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        RabinAcceptance rabinAcceptance = this.acceptance();
        for (int i = 0; i < rabinAcceptance.size(); ++i) {
            BitSet bitSet = (BitSet)rabinAcceptance.getAcceptance_U(i).clone();
            BitSet bitSet2 = (BitSet)rabinAcceptance.getAcceptance_L(i).clone();
            AcceptanceRabin.RabinPair rabinPair = new AcceptanceRabin.RabinPair(bitSet, bitSet2);
            acceptanceRabin.add(rabinPair);
        }
        return acceptanceRabin;
    }

    private AcceptanceStreett createStreettAcceptance() throws PrismException {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        RabinAcceptance rabinAcceptance = this.acceptance();
        for (int i = 0; i < rabinAcceptance.size(); ++i) {
            BitSet bitSet = (BitSet)rabinAcceptance.getAcceptance_L(i).clone();
            BitSet bitSet2 = (BitSet)rabinAcceptance.getAcceptance_U(i).clone();
            AcceptanceStreett.StreettPair streettPair = new AcceptanceStreett.StreettPair(bitSet, bitSet2);
            acceptanceStreett.add(streettPair);
        }
        return acceptanceStreett;
    }
}

