/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.DTMC;
import explicit.MDP;
import explicit.Model;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.MDPRewardsSimple;
import explicit.rewards.Rewards;
import explicit.rewards.StateRewardsArray;
import explicit.rewards.StateRewardsConstant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.RewardStruct;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.RewardGenerator;

public class ConstructRewards
extends PrismComponent {
    protected boolean allowNegative = false;

    public ConstructRewards(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public void allowNegativeRewards() {
        this.allowNegative = true;
    }

    public Rewards buildRewardStructure(Model model, RewardGenerator rewardGenerator, int n) throws PrismException {
        switch (model.getModelType()) {
            case DTMC: 
            case CTMC: {
                return this.buildMCRewardStructure((DTMC)model, rewardGenerator, n);
            }
            case MDP: {
                return this.buildMDPRewardStructure((MDP)model, rewardGenerator, n);
            }
        }
        throw new PrismNotSupportedException("Cannot build rewards for " + model.getModelType() + "s");
    }

    public MCRewards buildMCRewardStructure(DTMC dTMC, RewardGenerator rewardGenerator, int n) throws PrismException {
        if (rewardGenerator == null) {
            throw new PrismException("No reward generator to build reward structure");
        }
        if (rewardGenerator.rewardStructHasTransitionRewards(n)) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        int n2 = dTMC.getNumStates();
        List<State> list = dTMC.getStatesList();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n2);
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            Comparable<State> comparable = null;
            if (!rewardGenerator.rewardStructHasStateRewards(n)) continue;
            if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
                State state;
                comparable = state = list.get(i);
                d = rewardGenerator.getStateReward(n, state);
            } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
                comparable = i;
                d = rewardGenerator.getStateReward(n, i);
            } else {
                throw new PrismException("Unknown state lookup mechanism for reward generator");
            }
            if (Double.isNaN(d)) {
                throw new PrismException("State reward evaluates to NaN at state " + comparable);
            }
            if (!this.allowNegative && d < 0.0) {
                throw new PrismException("State reward is negative (" + d + ") at state " + comparable);
            }
            stateRewardsArray.addToStateReward(i, d);
        }
        return stateRewardsArray;
    }

    public MDPRewards buildMDPRewardStructure(MDP mDP, RewardGenerator rewardGenerator, int n) throws PrismException {
        int n2 = mDP.getNumStates();
        List<State> list = mDP.getStatesList();
        MDPRewardsSimple mDPRewardsSimple = new MDPRewardsSimple(n2);
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            Comparable<State> comparable = null;
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
                    State state;
                    comparable = state = list.get(i);
                    d = rewardGenerator.getStateReward(n, state);
                } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
                    comparable = i;
                    d = rewardGenerator.getStateReward(n, i);
                } else {
                    throw new PrismException("Unknown state lookup mechanism for reward generator");
                }
                if (Double.isNaN(d)) {
                    throw new PrismException("State reward evaluates to NaN at state " + comparable);
                }
                if (!this.allowNegative && d < 0.0) {
                    throw new PrismException("State reward is negative (" + d + ") at state " + comparable);
                }
                mDPRewardsSimple.addToStateReward(i, d);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || mDP.isDeadlockState(i)) continue;
            int n3 = mDP.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
                    State state;
                    comparable = state = list.get(i);
                    d = rewardGenerator.getStateActionReward(n, state, mDP.getAction(i, j));
                } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
                    comparable = i;
                    d = rewardGenerator.getStateActionReward(n, i, mDP.getAction(i, j));
                } else {
                    throw new PrismException("Unknown state lookup mechanism for reward generator");
                }
                if (Double.isNaN(d)) {
                    throw new PrismException("Transition reward evaluates to NaN at state " + comparable);
                }
                if (!this.allowNegative && d < 0.0) {
                    throw new PrismException("Transition reward is negative (" + d + ") at state " + comparable);
                }
                mDPRewardsSimple.addToTransitionReward(i, j, d);
            }
        }
        return mDPRewardsSimple;
    }

    public Rewards buildRewardStructure(Model model, RewardStruct rewardStruct, Values values) throws PrismException {
        switch (model.getModelType()) {
            case DTMC: 
            case CTMC: {
                return this.buildMCRewardStructure((DTMC)model, rewardStruct, values);
            }
            case MDP: {
                return this.buildMDPRewardStructure((MDP)model, rewardStruct, values);
            }
        }
        throw new PrismNotSupportedException("Cannot build rewards for " + model.getModelType() + "s");
    }

    public MCRewards buildMCRewardStructure(DTMC dTMC, RewardStruct rewardStruct, Values values) throws PrismException {
        if (rewardStruct.getNumTransItems() > 0) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            if (Double.isNaN(d)) {
                throw new PrismLangException("Reward structure evaluates to NaN (at any state)", rewardStruct.getReward(0));
            }
            if (!this.allowNegative && d < 0.0) {
                throw new PrismLangException("Reward structure evaluates to " + d + " (at any state), negative rewards not allowed", rewardStruct.getReward(0));
            }
            return new StateRewardsConstant(d);
        }
        int n = dTMC.getNumStates();
        List<State> list = dTMC.getStatesList();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            for (int j = 0; j < n; ++j) {
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                double d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                if (Double.isNaN(d)) {
                    throw new PrismLangException("Reward structure evaluates to NaN at state " + list.get(j), rewardStruct.getReward(i));
                }
                if (!this.allowNegative && d < 0.0) {
                    throw new PrismLangException("Reward structure evaluates to " + d + " at state " + list.get(j) + ", negative rewards not allowed", rewardStruct.getReward(i));
                }
                stateRewardsArray.addToStateReward(j, d);
            }
        }
        return stateRewardsArray;
    }

    public MDPRewards buildMDPRewardStructure(MDP mDP, RewardStruct rewardStruct, Values values) throws PrismException {
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            if (Double.isNaN(d)) {
                throw new PrismLangException("Reward structure evaluates to NaN (at any state)", rewardStruct.getReward(0));
            }
            if (!this.allowNegative && d < 0.0) {
                throw new PrismLangException("Reward structure evaluates to " + d + " (at any state), negative rewards not allowed", rewardStruct.getReward(0));
            }
            return new StateRewardsConstant(d);
        }
        int n = mDP.getNumStates();
        List<State> list = mDP.getStatesList();
        MDPRewardsSimple mDPRewardsSimple = new MDPRewardsSimple(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            for (int j = 0; j < n; ++j) {
                double d;
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    if (mDP.isDeadlockState(j)) continue;
                    int n3 = mDP.getNumChoices(j);
                    for (int k = 0; k < n3; ++k) {
                        Object object = mDP.getAction(j, k);
                        if (!(object == null ? string.isEmpty() : object.equals(string))) continue;
                        d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                        if (Double.isNaN(d)) {
                            throw new PrismLangException("Reward structure evaluates to NaN at state " + list.get(j), rewardStruct.getReward(i));
                        }
                        if (!this.allowNegative && d < 0.0) {
                            throw new PrismLangException("Reward structure evaluates to " + d + " at state " + list.get(j) + ", negative rewards not allowed", rewardStruct.getReward(i));
                        }
                        mDPRewardsSimple.addToTransitionReward(j, k, d);
                    }
                    continue;
                }
                d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                if (Double.isNaN(d)) {
                    throw new PrismLangException("Reward structure evaluates to NaN at state " + list.get(j), rewardStruct.getReward(i));
                }
                if (!this.allowNegative && d < 0.0) {
                    throw new PrismLangException("Reward structure evaluates to " + d + " at state " + list.get(j) + ", negative rewards not allowed", rewardStruct.getReward(i));
                }
                mDPRewardsSimple.addToStateReward(j, d);
            }
        }
        return mDPRewardsSimple;
    }

    public MCRewards buildMCRewardsFromPrismExplicit(DTMC dTMC, File file, File file2) throws PrismException {
        int n = 0;
        StateRewardsArray stateRewardsArray = new StateRewardsArray(dTMC.getNumStates());
        if (file != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string = bufferedReader.readLine();
                n = 1;
                if (string == null) {
                    throw new PrismException("Missing first line of state rewards file");
                }
                string = bufferedReader.readLine();
                ++n;
                while (string != null) {
                    if ((string = string.trim()).length() > 0) {
                        String[] stringArray = string.split(" ");
                        int n2 = Integer.parseInt(stringArray[0]);
                        double d = Double.parseDouble(stringArray[1]);
                        if (!this.allowNegative && d < 0.0) {
                            throw new PrismLangException("Found state reward " + d + " at state " + n2 + ", negative rewards not allowed");
                        }
                        stateRewardsArray.setStateReward(n2, d);
                    }
                    string = bufferedReader.readLine();
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read state rewards from file \"" + file + "\"" + iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in state rewards file (line " + n + ") for MDP");
            }
        }
        if (file2 != null) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        return stateRewardsArray;
    }

    public MDPRewards buildMDPRewardsFromPrismExplicit(MDP mDP, File file, File file2) throws PrismException {
        double d;
        int n;
        String[] stringArray;
        String string;
        BufferedReader bufferedReader;
        int n2 = 0;
        MDPRewardsSimple mDPRewardsSimple = new MDPRewardsSimple(mDP.getNumStates());
        if (file != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    string = bufferedReader.readLine();
                    n2 = 1;
                    if (string == null) {
                        throw new PrismException("Missing first line of state rewards file");
                    }
                    string = bufferedReader.readLine();
                    ++n2;
                    while (string != null) {
                        if ((string = string.trim()).length() > 0) {
                            stringArray = string.split(" ");
                            n = Integer.parseInt(stringArray[0]);
                            d = Double.parseDouble(stringArray[1]);
                            if (!this.allowNegative && d < 0.0) {
                                throw new PrismLangException("Found state reward " + d + " at state " + n + ", negative rewards not allowed");
                            }
                            mDPRewardsSimple.setStateReward(n, d);
                        }
                        string = bufferedReader.readLine();
                        ++n2;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read state rewards from file \"" + file + "\"" + iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in state rewards file (line " + n2 + ") for MDP");
            }
        }
        if (file2 != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                try {
                    string = bufferedReader.readLine();
                    n2 = 1;
                    if (string == null) {
                        throw new PrismException("Missing first line of transition rewards file");
                    }
                    string = bufferedReader.readLine();
                    ++n2;
                    while (string != null) {
                        if ((string = string.trim()).length() > 0) {
                            stringArray = string.split(" ");
                            n = Integer.parseInt(stringArray[0]);
                            int n3 = Integer.parseInt(stringArray[1]);
                            d = Double.parseDouble(stringArray[3]);
                            if (!this.allowNegative && d < 0.0) {
                                throw new PrismLangException("Found transition reward " + d + " at state " + n + ", action " + n3 + ", negative rewards not allowed");
                            }
                            mDPRewardsSimple.setTransitionReward(n, n3, d);
                        }
                        string = bufferedReader.readLine();
                        ++n2;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read transition rewards from file \"" + file2 + "\"" + iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in transition rewards file (line " + n2 + ") for MDP");
            }
        }
        return mDPRewardsSimple;
    }
}

