/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.SCCComputer;
import explicit.SCCConsumer;
import explicit.SuccessorsIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.IntPredicate;
import prism.PrismComponent;
import prism.PrismException;

public class SCCComputerTarjan
extends SCCComputer {
    private Model model;
    private int numNodes;
    private int index = 0;
    private List<Integer> stack = new LinkedList<Integer>();
    private ArrayList<Node> nodeList;
    private BitSet onStack;
    private boolean filterTrivialSCCs;
    private IntPredicate restrict;

    public SCCComputerTarjan(PrismComponent prismComponent, Model model, SCCConsumer sCCConsumer) throws PrismException {
        super(prismComponent, sCCConsumer);
        this.model = model;
        this.numNodes = model.getNumStates();
        this.nodeList = new ArrayList(this.numNodes);
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodeList.add(new Node(i));
        }
        this.onStack = new BitSet();
    }

    @Override
    public void computeSCCs(boolean bl, IntPredicate intPredicate) throws PrismException {
        this.filterTrivialSCCs = bl;
        this.consumer.notifyStart(this.model);
        this.restrict = intPredicate;
        this.tarjan();
        this.consumer.notifyDone();
    }

    public void tarjan() throws PrismException {
        for (int i = 0; i < this.numNodes; ++i) {
            if (this.restrict != null && !this.restrict.test(i) || this.nodeList.get((int)i).lowlink != -1) continue;
            this.tarjan(i);
        }
    }

    private void tarjan(int n) throws PrismException {
        int n2;
        Node node = this.nodeList.get(n);
        node.index = this.index;
        node.lowlink = this.index++;
        this.stack.add(0, n);
        this.onStack.set(n);
        boolean bl = false;
        SuccessorsIterator successorsIterator = this.model.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            n2 = successorsIterator.nextInt();
            if (n2 == n) {
                bl = true;
                continue;
            }
            if (this.restrict != null && !this.restrict.test(n2)) continue;
            Node node2 = this.nodeList.get(n2);
            if (node2.index == -1) {
                this.tarjan(n2);
                node.lowlink = Math.min(node.lowlink, node2.lowlink);
                continue;
            }
            if (!this.onStack.get(n2)) continue;
            node.lowlink = Math.min(node.lowlink, node2.index);
        }
        if (node.lowlink == node.index) {
            int n3;
            int n4 = n2 = this.stack.get(0) == n ? 1 : 0;
            if (n2 != 0 && this.filterTrivialSCCs && !bl) {
                this.stack.remove(0);
                this.onStack.set(n, false);
                return;
            }
            this.consumer.notifyStartSCC();
            do {
                n3 = this.stack.remove(0);
                this.onStack.set(n3, false);
                this.consumer.notifyStateInSCC(n3);
            } while (n3 != n);
            this.consumer.notifyEndSCC();
        }
    }

    protected static class Node {
        public int lowlink = -1;
        public int index = -1;
        public int id;

        public Node(int n) {
            this.id = n;
        }
    }
}

