/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.SCCComputerTarjan;
import explicit.SCCConsumer;
import explicit.SCCConsumerBitSet;
import explicit.SCCInfo;
import java.util.BitSet;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import prism.PrismComponent;
import prism.PrismException;

public abstract class SCCComputer
extends PrismComponent {
    protected SCCConsumer consumer;

    public static SCCComputer createSCCComputer(PrismComponent prismComponent, Model model, SCCConsumer sCCConsumer) throws PrismException {
        return new SCCComputerTarjan(prismComponent, model, sCCConsumer);
    }

    public static SCCInfo computeTopologicalOrdering(PrismComponent prismComponent, Model model, boolean bl) throws PrismException {
        return SCCComputer.computeTopologicalOrdering(prismComponent, model, bl, null);
    }

    public static SCCInfo computeTopologicalOrdering(PrismComponent prismComponent, Model model, boolean bl, IntPredicate intPredicate) throws PrismException {
        SCCInfo sCCInfo = new SCCInfo(model.getNumStates());
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(prismComponent, model, sCCInfo);
        sCCComputer.computeSCCs(!bl, intPredicate);
        return sCCInfo;
    }

    public static void forEachSCC(PrismComponent prismComponent, Model model, final Consumer<BitSet> consumer) throws PrismException {
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(prismComponent, model, new SCCConsumerBitSet(true){

            @Override
            public void notifyNextSCC(BitSet bitSet) throws PrismException {
                consumer.accept(bitSet);
            }
        });
        sCCComputer.computeSCCs();
    }

    public SCCComputer(PrismComponent prismComponent, SCCConsumer sCCConsumer) throws PrismException {
        super(prismComponent);
        this.consumer = sCCConsumer;
    }

    public void computeSCCs() throws PrismException {
        this.computeSCCs(true);
    }

    public void computeSCCs(boolean bl) throws PrismException {
        this.computeSCCs(bl, null);
    }

    public abstract void computeSCCs(boolean var1, IntPredicate var2) throws PrismException;

    protected boolean isTrivialSCC(Model model, int n) {
        return !model.someSuccessorsMatch(n, n2 -> n2 == n);
    }

    public static enum SCCMethod {
        TARJAN;


        public String fullName() {
            switch (this) {
                case TARJAN: {
                    return "Tarjan";
                }
            }
            return this.toString();
        }
    }
}

