/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import explicit.MDPGeneric;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import prism.PrismUtils;

public interface MDP
extends MDPGeneric<Double> {
    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int var1, int var2);

    default public void forEachTransition(int n, int n2, TransitionConsumer transitionConsumer) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n, n2);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Double> entry = iterator.next();
            transitionConsumer.accept(n, entry.getKey(), entry.getValue());
        }
    }

    default public double sumOverTransitions(int n, int n2, final TransitionToDoubleFunction transitionToDoubleFunction) {
        class Sum {
            double sum = 0.0;

            Sum() {
            }

            void accept(int n, int n2, double d) {
                this.sum += transitionToDoubleFunction.apply(n, n2, d);
            }
        }
        Sum sum = new Sum();
        this.forEachTransition(n, n2, sum::accept);
        return sum.sum;
    }

    default public void mvMultMinMax(double[] dArray, boolean bl, double[] dArray2, BitSet bitSet, boolean bl2, int[] nArray) {
        this.mvMultMinMax(dArray, bl, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator(), nArray);
    }

    default public void mvMultMinMax(double[] dArray, boolean bl, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl, nArray);
        }
    }

    default public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultSingle(n, i, dArray);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            double d2 = this.mvMultSingle(n, i, dArray);
            if (!PrismUtils.doublesAreClose(d, d2, 1.0E-12, false)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    default public double mvMultSingle(int n3, int n4, double[] dArray) {
        return this.sumOverTransitions(n3, n4, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultGSMinMax(double[] dArray, boolean bl, BitSet bitSet, boolean bl2, boolean bl3, int[] nArray) {
        return this.mvMultGSMinMax(dArray, bl, new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator(), bl3, nArray);
    }

    default public double mvMultGSMinMax(double[] dArray, boolean bl, PrimitiveIterator.OfInt ofInt, boolean bl2, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            double d3 = bl2 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultGSMinMaxIntervalIter(double[] dArray, boolean bl, PrimitiveIterator.OfInt ofInt, int[] nArray, boolean bl2, boolean bl3) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
                dArray[n] = d;
                continue;
            }
            dArray[n] = d;
        }
    }

    default public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultJacSingle(n, i, dArray);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultJacSingle(int n, int n2, final double[] dArray) {
        class Jacobi {
            double diag = 1.0;
            double d = 0.0;

            Jacobi() {
            }

            void accept(int n, int n2, double d) {
                if (n2 != n) {
                    this.d += d * dArray[n2];
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachTransition(n, n2, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public void mvMultRewMinMax(double[] dArray, MDPRewards mDPRewards, boolean bl, double[] dArray2, BitSet bitSet, boolean bl2, int[] nArray) {
        PrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
        }
    }

    default public void mvMultRewMinMax(double[] dArray, MDPRewards mDPRewards, boolean bl, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
        }
    }

    default public double mvMultRewMinMaxSingle(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultRewSingle(n, i, dArray, mDPRewards);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultRewSingle(int n3, int n4, double[] dArray, MDPRewards mDPRewards) {
        double d2 = mDPRewards.getStateReward(n3);
        d2 += mDPRewards.getTransitionReward(n3, n4);
        return d2 += this.sumOverTransitions(n3, n4, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultRewSingle(int n3, int n4, double[] dArray, MCRewards mCRewards) {
        double d2 = mCRewards.getStateReward(n3);
        return d2 += this.sumOverTransitions(n3, n4, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultRewGSMinMax(double[] dArray, MDPRewards mDPRewards, boolean bl, BitSet bitSet, boolean bl2, boolean bl3, int[] nArray) {
        return this.mvMultRewGSMinMax(dArray, mDPRewards, bl, new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator(), bl3, nArray);
    }

    default public double mvMultRewGSMinMax(double[] dArray, MDPRewards mDPRewards, boolean bl, PrimitiveIterator.OfInt ofInt, boolean bl2, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            double d3 = bl2 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultRewGSMinMaxIntervalIter(double[] dArray, MDPRewards mDPRewards, boolean bl, PrimitiveIterator.OfInt ofInt, int[] nArray, boolean bl2, boolean bl3) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
                dArray[n] = d;
                continue;
            }
            dArray[n] = d;
        }
    }

    default public double mvMultRewJacMinMaxSingle(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultRewJacSingle(n, i, dArray, mDPRewards);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultRewJacSingle(final int n, final int n2, final double[] dArray, final MDPRewards mDPRewards) {
        class Jacobi {
            double diag = 1.0;
            double d = mDPRewards.getStateReward(n) + mDPRewards.getTransitionReward(n, n2);
            boolean onlySelfLoops = true;

            Jacobi() {
            }

            void accept(int n3, int n22, double d) {
                if (n22 != n3) {
                    this.d += d * dArray[n22];
                    this.onlySelfLoops = false;
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachTransition(n, n2, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (jacobi.onlySelfLoops) {
            d = d != 0.0 ? (d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : 0.0;
        } else if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, MDPRewards mDPRewards, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            double d2 = this.mvMultRewSingle(n, i, dArray, mDPRewards);
            if (!PrismUtils.doublesAreClose(d, d2, 1.0E-12, false)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    default public void mvMultRight(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        for (int n3 : nArray) {
            this.forEachTransition(n3, nArray2[n3], (n, n2, d) -> {
                int n3 = n2;
                dArray[n3] = dArray2[n3] + d * dArray[n];
            });
        }
    }

    @FunctionalInterface
    public static interface TransitionToDoubleFunction {
        public double apply(int var1, int var2, double var3);
    }

    @FunctionalInterface
    public static interface TransitionConsumer {
        public void accept(int var1, int var2, double var3);
    }
}

