/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.LTS;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decorator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;

public class LTSExplicit
extends ModelExplicit
implements LTS {
    protected ArrayList<ArrayList<Integer>> successors = new ArrayList();
    protected int numTransitions = 0;
    protected int maxNumChoices = 0;

    public LTSExplicit() {
        this.initialise(0);
    }

    public int addState() {
        this.successors.add(new ArrayList());
        return this.numStates++;
    }

    public void addEdge(int n, int n2) {
        this.successors.get(n).add(n2);
        ++this.numTransitions;
        this.maxNumChoices = Math.max(this.getNumChoices(n), this.maxNumChoices);
    }

    @Override
    public int getNumChoices(int n) {
        return this.successors.get(n).size();
    }

    @Override
    public int getMaxNumChoices() {
        return this.maxNumChoices;
    }

    @Override
    public int getNumChoices() {
        return this.numTransitions;
    }

    @Override
    public Object getAction(int n, int n2) {
        return null;
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        return false;
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        if (n2 < this.getNumChoices(n)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public int getNumTransitions(int n) {
        return this.getNumChoices(n);
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return bitSet.get(this.successors.get(n).get(n2));
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return bitSet.get(this.successors.get(n).get(n2));
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        return SuccessorsIterator.fromSingleton(this.successors.get(n).get(n2));
    }

    @Override
    public Model constructInducedModel(MDStrategy mDStrategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        return SuccessorsIterator.from(this.successors.get(n).iterator(), false);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModelType getModelType() {
        return ModelType.LTS;
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        Iterator<Integer> iterator = this.getSuccessorsIterator(n);
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            prismLog.println(n + " -> " + n2 + ";");
        }
    }

    @Override
    public void exportToPrismLanguage(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }
}

