/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.DTMC;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.SuccessorsIterator;
import explicit.rewards.MCRewards;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.State;
import parser.Values;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class DTMCEmbeddedSimple
extends DTMCExplicit {
    protected CTMCSimple ctmc;
    protected double[] exitRates;
    protected int numExtraTransitions;

    public DTMCEmbeddedSimple(CTMCSimple cTMCSimple) {
        this.ctmc = cTMCSimple;
        this.numStates = cTMCSimple.getNumStates();
        this.exitRates = new double[this.numStates];
        this.numExtraTransitions = 0;
        for (int i = 0; i < this.numStates; ++i) {
            this.exitRates[i] = cTMCSimple.getTransitions(i).sum();
            if (this.exitRates[i] != 0.0) continue;
            ++this.numExtraTransitions;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new PrismNotSupportedException("Not supported");
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public int getNumStates() {
        return this.ctmc.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.ctmc.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.ctmc.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.ctmc.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.ctmc.isInitialState(n);
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.ctmc.isDeadlockState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.ctmc.getStatesList();
    }

    @Override
    public Values getConstantValues() {
        return this.ctmc.getConstantValues();
    }

    @Override
    public int getNumTransitions() {
        return this.ctmc.getNumTransitions() + this.numExtraTransitions;
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        if (this.exitRates[n] == 0.0) {
            return SuccessorsIterator.fromSingleton(n);
        }
        return this.ctmc.getSuccessors(n);
    }

    public int getNumChoices(int n) {
        return 1;
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.ctmc.getLabelStates(string);
    }

    @Override
    public boolean hasLabel(String string) {
        return this.ctmc.hasLabel(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.ctmc.getLabels();
    }

    @Override
    public void addLabel(String string, BitSet bitSet) {
        throw new RuntimeException("Can not add label to DTMCEmbeddedSimple");
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
    }

    @Override
    public String infoString() {
        Object object = "";
        object = (String)object + this.numStates + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions (incl. " + this.numExtraTransitions + " self-loops)";
        return object;
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.numStates + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        return object;
    }

    @Override
    public int getNumTransitions(int n) {
        if (this.exitRates[n] == 0.0) {
            return 1;
        }
        return this.ctmc.getNumTransitions(n);
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int n) {
        if (this.exitRates[n] == 0.0) {
            return Collections.singletonMap(n, 1.0).entrySet().iterator();
        }
        final Iterator<Map.Entry<Integer, Double>> iterator = this.ctmc.getTransitionsIterator(n);
        final double d = this.exitRates[n];
        return new Iterator<Map.Entry<Integer, Double>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<Integer, Double> next() {
                final Map.Entry entry = (Map.Entry)iterator.next();
                return new Map.Entry<Integer, Double>(){

                    @Override
                    public Integer getKey() {
                        return (Integer)entry.getKey();
                    }

                    @Override
                    public Double getValue() {
                        return (Double)entry.getValue() / d;
                    }

                    @Override
                    public Double setValue(Double d) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public void forEachTransition(int n3, DTMC.TransitionConsumer transitionConsumer) {
        double d = this.exitRates[n3];
        if (d == 0.0) {
            transitionConsumer.accept(n3, n3, 1.0);
        } else {
            this.ctmc.forEachTransition(n3, (n, n2, d2) -> transitionConsumer.accept(n, n2, d2 / d));
        }
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = this.exitRates[n];
        if (d2 == 0.0) {
            d += dArray[n];
        } else {
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n2 = entry.getKey();
                double d3 = entry.getValue();
                d += d3 * dArray[n2];
            }
            d /= d2;
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.exitRates[n];
        if (d3 == 0.0) {
            return 0.0;
        }
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d4 = entry.getValue();
            if (n2 != n) {
                d += d4 * dArray[n2];
                continue;
            }
            d2 = d4;
        }
        return d /= d3 - d2;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards mCRewards) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = this.exitRates[n];
        double d2 = 0.0;
        if (d == 0.0) {
            d2 += dArray[n];
        } else {
            for (Map.Entry<Integer, Double> entry : distribution) {
                int n2 = entry.getKey();
                double d3 = entry.getValue();
                d2 += d3 * dArray[n2];
            }
            d2 /= d;
        }
        return d2 += mCRewards.getStateReward(n);
    }

    @Override
    public double mvMultRewJacSingle(int n, double[] dArray, MCRewards mCRewards) {
        Distribution distribution = this.ctmc.getTransitions(n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.exitRates[n];
        if (d3 == 0.0) {
            return mCRewards.getStateReward(n);
        }
        d = d3 * mCRewards.getStateReward(n);
        for (Map.Entry<Integer, Double> entry : distribution) {
            int n2 = entry.getKey();
            double d4 = entry.getValue();
            if (n2 != n) {
                d += d4 * dArray[n2];
                continue;
            }
            d2 = d4;
        }
        return d /= d3 - d2;
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        Arrays.fill(dArray2, 0.0);
        for (int i = 0; i < this.numStates; ++i) {
            double d = this.exitRates[i];
            if (d == 0.0) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[i];
                continue;
            }
            Iterator<Map.Entry<Integer, Double>> iterator = this.ctmc.getTransitionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Double> entry = iterator.next();
                int n = entry.getKey();
                double d2 = entry.getValue() / d;
                int n2 = n;
                dArray2[n2] = dArray2[n2] + d2 * dArray[i];
            }
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + "ctmc: " + this.ctmc;
        boolean bl = true;
        object = ", exitRates: [ ";
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": " + this.exitRates[i];
        }
        object = (String)object + " ]";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCEmbeddedSimple)) {
            return false;
        }
        DTMCEmbeddedSimple dTMCEmbeddedSimple = (DTMCEmbeddedSimple)object;
        if (!this.ctmc.equals(dTMCEmbeddedSimple.ctmc)) {
            return false;
        }
        if (!this.exitRates.equals(dTMCEmbeddedSimple.exitRates)) {
            return false;
        }
        return this.numExtraTransitions == dTMCEmbeddedSimple.numExtraTransitions;
    }
}

