/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.IterableInt;
import explicit.Model;
import explicit.SuccessorsIterator;
import explicit.rewards.MCRewards;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import prism.Pair;
import prism.PrismException;

public interface DTMC
extends Model {
    public int getNumTransitions(int var1);

    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(int var1);

    public Iterator<Map.Entry<Integer, Pair<Double, Object>>> getTransitionsAndActionsIterator(int var1);

    default public void forEachTransition(int n, TransitionConsumer transitionConsumer) {
        Iterator<Map.Entry<Integer, Double>> iterator = this.getTransitionsIterator(n);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Double> entry = iterator.next();
            transitionConsumer.accept(n, entry.getKey(), entry.getValue());
        }
    }

    default public double sumOverTransitions(int n, final TransitionToDoubleFunction transitionToDoubleFunction) {
        class Sum {
            double sum = 0.0;

            Sum() {
            }

            void accept(int n, int n2, double d) {
                this.sum += transitionToDoubleFunction.apply(n, n2, d);
            }
        }
        Sum sum = new Sum();
        this.forEachTransition(n, sum::accept);
        return sum.sum;
    }

    default public long getNumTransitions(PrimitiveIterator.OfInt ofInt) {
        long l = 0L;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            l += (long)this.getNumTransitions(n);
        }
        return l;
    }

    default public boolean prob0step(int n, BitSet bitSet) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!bitSet.get(n2)) continue;
            return true;
        }
        return false;
    }

    default public void prob0step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        PrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            bitSet3.set(n, this.prob0step(n, bitSet2));
        }
    }

    default public boolean prob1step(int n, BitSet bitSet, BitSet bitSet2) {
        boolean bl = true;
        boolean bl2 = false;
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!bitSet.get(n2)) {
                bl = false;
                break;
            }
            bl2 = bl2 || bitSet2.get(n2);
        }
        return bl && bl2;
    }

    default public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        PrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            bitSet4.set(n, this.prob1step(n, bitSet2, bitSet3));
        }
    }

    default public void mvMult(double[] dArray, double[] dArray2, BitSet bitSet, boolean bl) {
        this.mvMult(dArray, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator());
    }

    default public void mvMult(double[] dArray, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultSingle(n, dArray);
        }
    }

    default public double mvMultSingle(int n3, double[] dArray) {
        return this.sumOverTransitions(n3, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultGS(double[] dArray, BitSet bitSet, boolean bl, boolean bl2) {
        return this.mvMultGS(dArray, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator(), bl2);
    }

    default public double mvMultGS(double[] dArray, PrimitiveIterator.OfInt ofInt, boolean bl) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultJacSingle(n, dArray);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultGSIntervalIter(double[] dArray, PrimitiveIterator.OfInt ofInt, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultJacSingle(n, dArray);
            if (bl) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
            }
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        throw new PrismException("Monotonicity violated (from below): old value " + dArray[n] + " > new value " + d);
                    }
                } else if (dArray[n] < d) {
                    throw new PrismException("Monotonicity violated (from above): old value " + dArray[n] + " < new value " + d);
                }
            }
            dArray[n] = d;
        }
    }

    default public void mvMultJac(double[] dArray, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultJacSingle(n, dArray);
        }
    }

    default public double mvMultJacSingle(int n, final double[] dArray) {
        class Jacobi {
            double diag = 1.0;
            double d = 0.0;

            Jacobi() {
            }

            void accept(int n, int n2, double d) {
                if (n2 != n) {
                    this.d += d * dArray[n2];
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachTransition(n, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public void mvMultRew(double[] dArray, MCRewards mCRewards, double[] dArray2, BitSet bitSet, boolean bl) {
        this.mvMultRew(dArray, mCRewards, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator());
    }

    default public void mvMultRew(double[] dArray, MCRewards mCRewards, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewSingle(n, dArray, mCRewards);
        }
    }

    default public void mvMultRewJac(double[] dArray, MCRewards mCRewards, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewJacSingle(n, dArray, mCRewards);
        }
    }

    default public double mvMultRewGS(double[] dArray, MCRewards mCRewards, PrimitiveIterator.OfInt ofInt, boolean bl) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewJacSingle(n, dArray, mCRewards);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultRewGSIntervalIter(double[] dArray, MCRewards mCRewards, PrimitiveIterator.OfInt ofInt, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultRewJacSingle(n, dArray, mCRewards);
            if (bl) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
            }
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        throw new PrismException("Monotonicity violated (from below): old value " + dArray[n] + " > new value " + d);
                    }
                } else if (dArray[n] < d) {
                    throw new PrismException("Monotonicity violated (from above): old value " + dArray[n] + " < new value " + d);
                }
            }
            dArray[n] = d;
        }
    }

    default public double mvMultRewSingle(int n3, double[] dArray, MCRewards mCRewards) {
        double d2 = mCRewards.getStateReward(n3);
        return d2 += this.sumOverTransitions(n3, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultRewJacSingle(final int n, final double[] dArray, final MCRewards mCRewards) {
        class Jacobi {
            double diag = 1.0;
            double d = mCRewards.getStateReward(n);
            boolean onlySelfLoops = true;

            Jacobi() {
            }

            void accept(int n3, int n2, double d) {
                if (n2 != n3) {
                    this.d += d * dArray[n2];
                    this.onlySelfLoops = false;
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachTransition(n, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (jacobi.onlySelfLoops) {
            d = d != 0.0 ? (d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : 0.0;
        } else if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public void vmMult(double[] dArray, double[] dArray2) {
        Arrays.fill(dArray2, 0.0);
        int n3 = this.getNumStates();
        for (int i = 0; i < n3; ++i) {
            this.forEachTransition(i, (n, n2, d) -> {
                int n3 = n2;
                dArray[n3] = dArray2[n3] + d * dArray[n];
            });
        }
    }

    default public void vmMultPowerSteadyState(double[] dArray, double[] dArray2, double[] dArray3, double d, IterableInt iterableInt) {
        int n3;
        PrimitiveIterator.OfInt ofInt = iterableInt.iterator();
        while (ofInt.hasNext()) {
            n3 = ofInt.nextInt();
            dArray2[n3] = dArray[n3] * (d * dArray3[n3] + 1.0);
        }
        ofInt = iterableInt.iterator();
        while (ofInt.hasNext()) {
            n3 = ofInt.nextInt();
            this.forEachTransition(n3, (n, n2, d2) -> {
                if (n != n2) {
                    int n3 = n2;
                    dArray[n3] = dArray2[n3] + d * d2 * dArray[n];
                }
            });
        }
    }

    @FunctionalInterface
    public static interface TransitionToDoubleFunction {
        public double apply(int var1, int var2, double var3);
    }

    @FunctionalInterface
    public static interface TransitionConsumer {
        public void accept(int var1, int var2, double var3);
    }
}

