/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableBitSet;
import explicit.Model;
import explicit.ModelTransformation;
import explicit.StateValues;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.function.IntFunction;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.PrismException;

public class BasicModelTransformation<OM extends Model, TM extends Model>
implements ModelTransformation<OM, TM> {
    public static final IntFunction<Integer> IDENTITY = Integer::valueOf;
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final double DEFAULT_DOUBLE = Double.NaN;
    public static final int DEFAULT_INTEGER = -1;
    protected final OM originalModel;
    protected final TM transformedModel;
    protected final IntFunction<Integer> mapToTransformedModel;
    protected final int numberOfStates;

    public BasicModelTransformation(OM OM, TM TM) {
        this(OM, TM, IDENTITY);
    }

    public BasicModelTransformation(OM OM, TM TM, IntFunction<Integer> intFunction) {
        this.originalModel = OM;
        this.transformedModel = TM;
        this.numberOfStates = OM.getNumStates();
        this.mapToTransformedModel = intFunction;
    }

    @Override
    public OM getOriginalModel() {
        return this.originalModel;
    }

    @Override
    public TM getTransformedModel() {
        return this.transformedModel;
    }

    @Override
    public StateValues projectToOriginalModel(StateValues stateValues) throws PrismException {
        if (stateValues.getType() instanceof TypeBool) {
            assert (stateValues.getBitSet() != null) : "State values are undefined.";
            BitSet bitSet = this.projectToOriginalModel(stateValues.getBitSet());
            return StateValues.createFromBitSet(bitSet, this.originalModel);
        }
        if (stateValues.getType() instanceof TypeDouble) {
            assert (stateValues.getDoubleArray() != null) : "State values are undefined.";
            double[] dArray = this.projectToOriginalModel(stateValues.getDoubleArray());
            return StateValues.createFromDoubleArray(dArray, this.originalModel);
        }
        if (stateValues.getType() instanceof TypeInt) {
            assert (stateValues.getIntArray() != null) : "State values are undefined.";
            int[] nArray = this.projectToOriginalModel(stateValues.getIntArray());
            return StateValues.createFromIntegerArray(nArray, this.originalModel);
        }
        throw new PrismException("Unsupported type of state values");
    }

    public BitSet projectToOriginalModel(BitSet bitSet) {
        BitSet bitSet2 = new BitSet(this.numberOfStates);
        for (int i = 0; i < this.numberOfStates; ++i) {
            Integer n = this.mapToTransformedModel(i);
            boolean bl = n == null ? false : bitSet.get(n);
            bitSet2.set(i, bl);
        }
        return bitSet2;
    }

    public double[] projectToOriginalModel(double[] dArray) {
        double[] dArray2 = new double[this.numberOfStates];
        for (int i = 0; i < this.numberOfStates; ++i) {
            double d;
            Integer n = this.mapToTransformedModel(i);
            dArray2[i] = d = n == null ? Double.NaN : dArray[n];
        }
        return dArray2;
    }

    public int[] projectToOriginalModel(int[] nArray) {
        int[] nArray2 = new int[this.numberOfStates];
        for (int i = 0; i < this.numberOfStates; ++i) {
            int n;
            Integer n2 = this.mapToTransformedModel(i);
            nArray2[i] = n = n2 == null ? -1 : nArray[n2];
        }
        return nArray2;
    }

    public Integer mapToTransformedModel(int n) {
        if (n >= this.numberOfStates) {
            throw new IndexOutOfBoundsException("State index does not belong to original model.");
        }
        return this.mapToTransformedModel.apply(n);
    }

    public BitSet mapToTransformedModel(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        PrimitiveIterator.OfInt ofInt = new IterableBitSet(bitSet).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            Integer n2 = this.mapToTransformedModel(n);
            if (n2 == null) continue;
            bitSet2.set(n2);
        }
        return bitSet2;
    }
}

