/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.Broadcaster;
import edu.jas.util.ChannelFactory;
import edu.jas.util.Counter;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistributedListServer
extends Thread {
    private static final Logger logger = Logger.getLogger(DistributedListServer.class);
    public static final int DEFAULT_PORT = 4810;
    protected final ChannelFactory cf;
    protected List<Broadcaster> servers;
    private boolean goon = true;
    private Thread mythread = null;
    private Counter listElem = new Counter(0);
    protected final SortedMap<Counter, Object> theList;

    public DistributedListServer() {
        this(4810);
    }

    public DistributedListServer(int n) {
        this(new ChannelFactory(n));
    }

    public DistributedListServer(ChannelFactory channelFactory) {
        this.cf = channelFactory;
        channelFactory.init();
        this.servers = new ArrayList<Broadcaster>();
        this.theList = new TreeMap<Counter, Object>();
    }

    public static void main(String[] stringArray) throws InterruptedException {
        int n = 4810;
        if (stringArray.length < 1) {
            System.out.println("Usage: DistributedListServer <port>");
        } else {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DistributedListServer distributedListServer = new DistributedListServer(n);
        distributedListServer.init();
        distributedListServer.join();
    }

    public void init() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel socketChannel = null;
        Broadcaster broadcaster = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            try {
                socketChannel = this.cf.getChannel();
                logger.debug("dls channel = " + socketChannel);
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    continue;
                }
                broadcaster = new Broadcaster(socketChannel, this.servers, this.listElem, this.theList);
                int n = 0;
                Object object = this.servers;
                synchronized (object) {
                    this.servers.add(broadcaster);
                    n = this.theList.size();
                    broadcaster.start();
                }
                if (n <= 0) continue;
                logger.info("sending " + n + " list elements");
                object = this.theList;
                synchronized (object) {
                    Iterator<Map.Entry<Counter, Object>> iterator = this.theList.entrySet().iterator();
                    for (int i = 0; i < n; ++i) {
                        Map.Entry<Counter, Object> entry = iterator.next();
                        Counter counter = entry.getKey();
                        Object object2 = entry.getValue();
                        try {
                            broadcaster.sendChannel(counter, object2);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.goon = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    public void terminate() {
        this.goon = false;
        logger.debug("terminating ListServer");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.servers != null) {
            for (Broadcaster broadcaster : this.servers) {
                broadcaster.closeChannel();
                try {
                    while (broadcaster.isAlive()) {
                        broadcaster.interrupt();
                        broadcaster.join(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.servers = null;
        }
        logger.debug("Broadcasters terminated");
        if (this.mythread == null) {
            return;
        }
        try {
            while (this.mythread.isAlive()) {
                this.mythread.interrupt();
                this.mythread.join(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.mythread = null;
        logger.debug("ListServer terminated");
    }

    public int size() {
        if (this.servers == null) {
            return -1;
        }
        return this.servers.size();
    }
}

