/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeFieldCharP;
import java.math.BigInteger;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SquarefreeFiniteFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<C> {
    private static final Logger logger = Logger.getLogger(SquarefreeFiniteFieldCharP.class);

    public SquarefreeFiniteFieldCharP(RingFactory<C> ringFactory) {
        super(ringFactory);
        if (!ringFactory.isFinite()) {
            throw new IllegalArgumentException("fac must be finite");
        }
    }

    public SortedMap<C, Long> rootCharacteristic(C c) {
        if (c == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " p == null");
        }
        TreeMap<C, Long> treeMap = new TreeMap<C, Long>();
        if (c.isZERO()) {
            return treeMap;
        }
        treeMap.put(c, 1L);
        return treeMap;
    }

    public C coeffRootCharacteristic(C c) {
        if (c == null || c.isZERO()) {
            return c;
        }
        Object object = c;
        if (this.aCoFac == null && this.qCoFac == null) {
            return object;
        }
        if (this.aCoFac != null) {
            long l = this.aCoFac.totalExtensionDegree();
            if (l <= 1L) {
                return object;
            }
            edu.jas.arith.BigInteger bigInteger = new edu.jas.arith.BigInteger(this.aCoFac.characteristic());
            edu.jas.arith.BigInteger bigInteger2 = Power.positivePower(bigInteger, l - 1L);
            object = (GcdRingElem)Power.positivePower(object, bigInteger2.getVal());
            return object;
        }
        if (this.qCoFac != null) {
            throw new UnsupportedOperationException("case QuotientRing not yet implemented");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<GenPolynomial<C>, Long> rootCharacteristic(GenPolynomial<C> genPolynomial) {
        void var7_9;
        Number number;
        Comparable<BigInteger> comparable;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger bigInteger = genPolynomial.ring.characteristic();
        if (bigInteger.signum() == 0) {
            return null;
        }
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.squarefreeFactors(genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info("sf = " + sortedMap);
        }
        Long object2 = null;
        for (Map.Entry<GenPolynomial<C>, Long> object3 : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial2 = object3.getKey();
            if (genPolynomial2.isConstant()) continue;
            Long l = object3.getValue();
            comparable = new BigInteger(l.toString());
            number = ((BigInteger)comparable).remainder(bigInteger);
            if (!((BigInteger)number).equals(BigInteger.ZERO)) {
                return null;
            }
            if (object2 == null) {
                object2 = l;
                continue;
            }
            if (object2.compareTo(l) < 0) continue;
            object2 = l;
        }
        Long l = bigInteger.longValue();
        MonoidElem monoidElem = genPolynomial.ring.getONE();
        for (Map.Entry entry : sortedMap.entrySet()) {
            comparable = (GenPolynomial)entry.getKey();
            number = (Long)entry.getValue();
            if (((GenPolynomial)comparable).isConstant()) {
                GcdRingElem gcdRingElem = (GcdRingElem)((GenPolynomial)comparable).leadingBaseCoefficient();
                if ((Long)number > 1L) {
                    gcdRingElem = Power.positivePower(gcdRingElem, (Long)number);
                }
                GcdRingElem gcdRingElem2 = this.coeffRootCharacteristic(gcdRingElem);
                comparable = ((GenPolynomial)genPolynomial.ring.getONE()).multiply(gcdRingElem2);
                treeMap.put((GenPolynomial<C>)comparable, 1L);
                continue;
            }
            if ((Long)number > object2) {
                long l2 = (Long)number / l;
                comparable = (GenPolynomial)Power.positivePower(comparable, l2);
            }
            GenPolynomial<Comparable<BigInteger>> genPolynomial3 = var7_9.multiply(comparable);
        }
        if (object2 != null) {
            object2 = object2 / l;
            treeMap.put((GenPolynomial<C>)var7_9, object2);
        }
        return treeMap;
    }

    @Override
    public GenPolynomial<C> baseRootCharacteristic(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for char p > 0 " + ringFactory);
        }
        long l = ringFactory.characteristic().longValue();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<C> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2 /= l);
            GcdRingElem gcdRingElem = this.coeffRootCharacteristic((GcdRingElem)monomial.c);
            ((GenPolynomial)element).doPutToMap(expVector2, gcdRingElem);
        }
        return element;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for char p > 0 " + ringFactory);
        }
        long l = ringFactory.characteristic().longValue();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<GenPolynomial<C>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            SortedMap<GenPolynomial<C>, Long> sortedMap = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (sortedMap == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("sm,rec = " + sortedMap);
            }
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)ringFactory.getONE();
            for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
                GenPolynomial<C> genPolynomial3 = entry.getKey();
                long l3 = entry.getValue();
                if (l3 > 1L) {
                    genPolynomial3 = Power.positivePower(genPolynomial3, l3);
                }
                genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, genPolynomial2);
        }
        return element;
    }
}

