/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoMiReducerRec;
import edu.jas.gbufd.PseudoReducerRec;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoRecParallel<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoRecParallel.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected final transient ThreadPool pool;
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> redRec;
    protected final PseudoReduction<GenPolynomial<C>> red;
    protected final RingFactory<GenPolynomial<C>> cofac;
    protected final RingFactory<C> baseCofac;

    public GroebnerBasePseudoRecParallel(int n, RingFactory<GenPolynomial<C>> ringFactory) {
        this(n, ringFactory, new PseudoReductionPar<GenPolynomial<C>>(), new ThreadPool(n), new OrderedPairlist<GenPolynomial<C>>(new GenPolynomialRing<GenPolynomial<C>>(ringFactory, 1)));
    }

    public GroebnerBasePseudoRecParallel(int n, RingFactory<GenPolynomial<C>> ringFactory, PseudoReduction<GenPolynomial<C>> pseudoReduction) {
        this(n, ringFactory, pseudoReduction, new ThreadPool(n));
    }

    public GroebnerBasePseudoRecParallel(int n, RingFactory<GenPolynomial<C>> ringFactory, PseudoReduction<GenPolynomial<C>> pseudoReduction, ThreadPool threadPool) {
        this(n, ringFactory, pseudoReduction, threadPool, new OrderedPairlist<GenPolynomial<C>>(new GenPolynomialRing<GenPolynomial<C>>(ringFactory, 1)));
    }

    public GroebnerBasePseudoRecParallel(int n, RingFactory<GenPolynomial<C>> ringFactory, PairList<GenPolynomial<C>> pairList) {
        this(n, ringFactory, new PseudoReductionPar<GenPolynomial<C>>(), new ThreadPool(n), pairList);
    }

    public GroebnerBasePseudoRecParallel(int n, RingFactory<GenPolynomial<C>> ringFactory, PseudoReduction<GenPolynomial<C>> pseudoReduction, ThreadPool threadPool, PairList<GenPolynomial<C>> pairList) {
        super(pseudoReduction, pairList);
        if (!(pseudoReduction instanceof PseudoReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        this.red = pseudoReduction;
        this.redRec = pseudoReduction;
        this.cofac = ringFactory;
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)this.cofac;
        this.baseCofac = genPolynomialRing.coFac;
        this.engine = GCDFactory.getProxy(this.baseCofac);
        this.pool = threadPool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.cancel();
        return n;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> GB(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        List list2 = this.normalizeZerosOnes(list);
        if ((list2 = this.engine.recursivePrimitivePart(list2)).size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        logger.info("start " + pairList);
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            PseudoReducerRec pseudoReducerRec = new PseudoReducerRec(terminator, list2, pairList, this.engine);
            this.pool.addJob(pseudoReducerRec);
        }
        terminator.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug("#parallel list = " + list2.size());
        list2 = this.minimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> minimalGB(List<GenPolynomial<GenPolynomial<C>>> list) {
        Object object;
        GenPolynomial<GenPolynomial<C>> genPolynomial;
        List list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList(list2.size());
        while (list2.size() > 0) {
            genPolynomial = list2.remove(0);
            if (this.red.isTopReducible(list2, genPolynomial) || this.red.isTopReducible(arrayList, genPolynomial)) {
                if (!this.debug) continue;
                System.out.println("dropped " + genPolynomial);
                object = new ArrayList(list2);
                object.addAll(arrayList);
                if ((genPolynomial = this.redRec.normalformRecursive((List<GenPolynomial<GenPolynomial<C>>>)object, genPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genPolynomial);
                continue;
            }
            arrayList.add(genPolynomial);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        object = new PseudoMiReducerRec[list2.size()];
        int n = 0;
        arrayList = new ArrayList(list2.size());
        while (list2.size() > 0) {
            genPolynomial = list2.remove(0);
            ArrayList arrayList2 = new ArrayList(list2.size() + arrayList.size());
            arrayList2.addAll(list2);
            arrayList2.addAll(arrayList);
            object[n] = new PseudoMiReducerRec(arrayList2, genPolynomial, this.engine);
            this.pool.addJob((Runnable)object[n]);
            ++n;
            arrayList.add(genPolynomial);
        }
        list2 = arrayList;
        arrayList = new ArrayList(list2.size());
        for (n = 0; n < ((Object)object).length; ++n) {
            genPolynomial = ((PseudoMiReducerRec)object[n]).getNF();
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isGBsimple(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<GenPolynomial<C>> genPolynomial = list.get(i);
            ExpVector expVector = genPolynomial.leadingExpVector();
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<GenPolynomial<C>> genPolynomial2;
                GenPolynomial<GenPolynomial<C>> genPolynomial3;
                ExpVector expVector2;
                GenPolynomial<GenPolynomial<C>> genPolynomial4 = list.get(j);
                ExpVector expVector3 = genPolynomial4.leadingExpVector();
                if (!this.red.moduleCriterion(n, expVector, expVector3) || !this.red.criterion4(expVector, expVector3, expVector2 = expVector.lcm(expVector3)) || (genPolynomial3 = this.red.SPolynomial(genPolynomial, genPolynomial4)).isZERO() || (genPolynomial2 = this.redRec.normalformRecursive(list, genPolynomial3)).isZERO()) continue;
                logger.info("no GB: pi = " + genPolynomial + ", pj = " + genPolynomial4);
                logger.info("s  = " + genPolynomial3 + ", h = " + genPolynomial2);
                return false;
            }
        }
        return true;
    }
}

