/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.gbmod.SolvableSyzygySeq;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class SolvableQuotientRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableQuotient<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableQuotient<C>> {
    private static final Logger logger = Logger.getLogger(SolvableQuotientRing.class);
    public final GenSolvablePolynomialRing<C> ring;
    public final SolvableSyzygyAbstract<C> engine;

    public SolvableQuotientRing(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        this.ring = genSolvablePolynomialRing;
        this.engine = new SolvableSyzygySeq(this.ring.coFac);
        logger.debug("quotient ring constructed");
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public SolvableQuotient<C> create(GenPolynomial<C> genPolynomial) {
        return new SolvableQuotient(this, (GenSolvablePolynomial)genPolynomial);
    }

    @Override
    public SolvableQuotient<C> create(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return new SolvableQuotient(this, (GenSolvablePolynomial)genPolynomial, (GenSolvablePolynomial)genPolynomial2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public SolvableQuotient<C> copy(SolvableQuotient<C> solvableQuotient) {
        return new SolvableQuotient(solvableQuotient.ring, solvableQuotient.num, solvableQuotient.den, true);
    }

    @Override
    public SolvableQuotient<C> getZERO() {
        return new SolvableQuotient(this, this.ring.getZERO());
    }

    @Override
    public SolvableQuotient<C> getONE() {
        return new SolvableQuotient(this, this.ring.getONE());
    }

    @Override
    public List<SolvableQuotient<C>> generators() {
        List list = PolynomialList.castToSolvableList(this.ring.generators());
        ArrayList<SolvableQuotient<C>> arrayList = new ArrayList<SolvableQuotient<C>>(list.size() * 2 - 1);
        GenPolynomial genPolynomial = this.ring.getONE();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            SolvableQuotient solvableQuotient = new SolvableQuotient(this, genSolvablePolynomial);
            arrayList.add(solvableQuotient);
            if (genSolvablePolynomial.isONE()) continue;
            solvableQuotient = new SolvableQuotient(this, genPolynomial, genSolvablePolynomial);
            arrayList.add(solvableQuotient);
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        if (!this.ring.isAssociative()) {
            return false;
        }
        List<SolvableQuotient<C>> list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SolvableQuotient<C> solvableQuotient = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                SolvableQuotient<SolvableQuotient<C>> solvableQuotient2 = list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    SolvableQuotient<SolvableQuotient<SolvableQuotient<C>>> solvableQuotient3;
                    SolvableQuotient<SolvableQuotient<SolvableQuotient<C>>> solvableQuotient4 = list.get(k);
                    SolvableQuotient<SolvableQuotient<C>> solvableQuotient5 = solvableQuotient4.multiply(solvableQuotient2).multiply((SolvableQuotient<SolvableQuotient<C>>)solvableQuotient);
                    if (solvableQuotient5.equals(solvableQuotient3 = solvableQuotient4.multiply(solvableQuotient2.multiply(solvableQuotient)))) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info("Xk = " + solvableQuotient4 + ", Xj = " + solvableQuotient2 + ", Xi = " + solvableQuotient);
                        logger.info("p = ( Xk * Xj ) * Xi = " + solvableQuotient5);
                        logger.info("q = Xk * ( Xj * Xi ) = " + solvableQuotient3);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableQuotient<C> fromInteger(BigInteger bigInteger) {
        return new SolvableQuotient(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public SolvableQuotient<C> fromInteger(long l) {
        return new SolvableQuotient(this, this.ring.fromInteger(l));
    }

    public String toString() {
        String string = null;
        string = this.ring.coFac.characteristic().signum() == 0 ? "RatFunc" : "ModFunc";
        return string + "( " + this.ring.toString() + " )";
    }

    @Override
    public String toScript() {
        return "SRF(" + this.ring.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SolvableQuotientRing)) {
            return false;
        }
        SolvableQuotientRing solvableQuotientRing = (SolvableQuotientRing)object;
        return this.ring.equals(solvableQuotientRing.ring);
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        return n;
    }

    @Override
    public SolvableQuotient<C> random(int n) {
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        while ((genPolynomial = ((GenSolvablePolynomial)this.ring.random(n)).monic()).isZERO()) {
        }
        return new SolvableQuotient(this, genPolynomial2, genPolynomial, false);
    }

    public SolvableQuotient<C> random(int n, int n2, int n3, float f) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        while ((genPolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic()).isZERO()) {
        }
        return new SolvableQuotient(this, genPolynomial, genPolynomial2, false);
    }

    @Override
    public SolvableQuotient<C> random(int n, Random random) {
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.random(n, random)).monic();
        GenPolynomial genPolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, random)).monic();
        while ((genPolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, random)).monic()).isZERO()) {
        }
        return new SolvableQuotient(this, genPolynomial, genPolynomial2, false);
    }

    @Override
    public SolvableQuotient<C> parse(String string) {
        int n = string.indexOf("{");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf("}")) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("|")) < 0) {
            GenPolynomial genPolynomial = this.ring.parse(string);
            return new SolvableQuotient(this, genPolynomial);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        GenPolynomial genPolynomial = this.ring.parse(string2);
        GenPolynomial genPolynomial2 = this.ring.parse(string3);
        return new SolvableQuotient(this, genPolynomial, genPolynomial2);
    }

    @Override
    public SolvableQuotient<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '{', '}');
        return this.parse(string);
    }
}

