/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPair;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.Pair;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class ReducerClientEC<C extends RingElem<C>>
implements Runnable {
    private final SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private static final Logger logger = Logger.getLogger(ReducerClientEC.class);

    ReducerClientEC(SocketChannel socketChannel, DistHashTable<Integer, GenPolynomial<C>> distHashTable) {
        this.pairChannel = socketChannel;
        this.theList = distHashTable;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        logger.debug("pairChannel = " + this.pairChannel + " reducer client running");
        Pair pair = null;
        GenPolynomial<C> genPolynomial = null;
        boolean bl = true;
        int n = 0;
        while (bl) {
            GBTransportMessReq gBTransportMessReq = new GBTransportMessReq();
            logger.debug("send request = " + gBTransportMessReq);
            genPolynomial = null;
            try {
                this.pairChannel.send(gBTransportMessReq);
            }
            catch (IOException iOException) {
                bl = false;
                iOException.printStackTrace();
                break;
            }
            logger.debug("receive pair, goon = " + bl);
            Object object = null;
            try {
                object = this.pairChannel.receive();
            }
            catch (IOException iOException) {
                bl = false;
                if (!logger.isDebugEnabled()) break;
                iOException.printStackTrace();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("received pair = " + object);
            }
            if (object == null) continue;
            if (object instanceof GBTransportMessEnd) {
                bl = false;
                continue;
            }
            if (object instanceof GBTransportMessPair || object instanceof GBTransportMessPairIndex) {
                GBTransportMess gBTransportMess;
                GenPolynomial<C> genPolynomial2 = null;
                GenPolynomial<C> genPolynomial3 = null;
                GenPolynomial<C> genPolynomial4 = null;
                if (object instanceof GBTransportMessPair) {
                    gBTransportMess = (GBTransportMessPair)object;
                    pair = gBTransportMess.pair;
                    if (pair != null) {
                        genPolynomial4 = pair.pi;
                        genPolynomial3 = pair.pj;
                    }
                }
                if (object instanceof GBTransportMessPairIndex) {
                    gBTransportMess = (GBTransportMessPairIndex)object;
                    Integer n2 = ((GBTransportMessPairIndex)gBTransportMess).i;
                    Integer n3 = ((GBTransportMessPairIndex)gBTransportMess).j;
                    Integer n4 = ((GBTransportMessPairIndex)gBTransportMess).s;
                    genPolynomial4 = this.theList.getWait(n2);
                    genPolynomial3 = this.theList.getWait(n3);
                    genPolynomial2 = this.theList.getWait(n4);
                }
                if (genPolynomial4 != null && genPolynomial3 != null) {
                    GenPolynomial genPolynomial5 = this.red.SPolynomial(genPolynomial4, genPolynomial3);
                    if (!genPolynomial5.isZERO()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ht(S) = " + genPolynomial5.leadingExpVector());
                        }
                        genPolynomial = this.red.normalform(this.theList, genPolynomial5);
                        ++n;
                        if (!genPolynomial.isZERO()) {
                            genPolynomial = genPolynomial.monic();
                            if (logger.isInfoEnabled()) {
                                logger.info("ht(H) = " + genPolynomial.leadingExpVector());
                            }
                        }
                    }
                } else {
                    logger.info("pi = " + genPolynomial4 + ", pj = " + genPolynomial3 + ", ps = " + genPolynomial2);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("#distributed list = " + this.theList.size());
                logger.debug("send H polynomial = " + genPolynomial);
            }
            try {
                this.pairChannel.send(new GBTransportMessPoly(genPolynomial));
            }
            catch (IOException iOException) {
                bl = false;
                iOException.printStackTrace();
            }
        }
        logger.info("terminated, " + n + " reductions, " + this.theList.size() + " polynomials");
        this.pairChannel.close();
    }
}

