/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPair;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.Pair;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistHashTable;
import edu.jas.util.TaggedSocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class HybridReducerClient<C extends RingElem<C>>
implements Runnable {
    private static final Logger logger = Logger.getLogger(HybridReducerClient.class);
    public final boolean debug = logger.isDebugEnabled();
    private final TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final ReductionPar<C> red;
    private final int threadsPerNode;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerClient(int n, TaggedSocketChannel taggedSocketChannel, Integer n2, DistHashTable<Integer, GenPolynomial<C>> distHashTable) {
        this.threadsPerNode = n;
        this.pairChannel = taggedSocketChannel;
        this.theList = distHashTable;
        this.red = new ReductionPar();
    }

    @Override
    public void run() {
        if (this.debug) {
            logger.info("pairChannel   = " + this.pairChannel + " reducer client running");
        }
        Pair pair = null;
        GenPolynomial<C> genPolynomial = null;
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (bl) {
            GBTransportMessReq gBTransportMessReq = new GBTransportMessReq();
            logger.info("send request = " + gBTransportMessReq);
            try {
                this.pairChannel.send(this.pairTag, gBTransportMessReq);
            }
            catch (IOException iOException) {
                bl = false;
                if (logger.isDebugEnabled()) {
                    iOException.printStackTrace();
                }
                logger.info("receive pair, exception ");
                break;
            }
            logger.debug("receive pair, goon = " + bl);
            bl2 = true;
            Object object = null;
            try {
                object = this.pairChannel.receive(this.pairTag);
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                interruptedException.printStackTrace();
            }
            catch (IOException iOException) {
                bl = false;
                if (!logger.isDebugEnabled()) break;
                iOException.printStackTrace();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
            if (this.debug) {
                logger.info("received pair = " + object);
            }
            genPolynomial = null;
            if (object == null) continue;
            if (object instanceof GBTransportMessEnd) {
                bl = false;
                continue;
            }
            if (object instanceof GBTransportMessPair || object instanceof GBTransportMessPairIndex) {
                GenPolynomial genPolynomial2;
                GenPolynomial<C> genPolynomial3 = null;
                GenPolynomial<C> genPolynomial4 = null;
                if (object instanceof GBTransportMessPair && (pair = ((GBTransportMessPair)object).pair) != null) {
                    genPolynomial4 = pair.pi;
                    genPolynomial3 = pair.pj;
                }
                if (object instanceof GBTransportMessPairIndex) {
                    Integer n2 = ((GBTransportMessPairIndex)object).i;
                    Integer n3 = ((GBTransportMessPairIndex)object).j;
                    genPolynomial4 = this.theList.getWait(n2);
                    genPolynomial3 = this.theList.getWait(n3);
                }
                if (genPolynomial4 != null && genPolynomial3 != null && !(genPolynomial2 = this.red.SPolynomial(genPolynomial4, genPolynomial3)).isZERO()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("ht(S) = " + genPolynomial2.leadingExpVector());
                    }
                    genPolynomial = this.red.normalform(this.theList, genPolynomial2);
                    ++n;
                    if (!genPolynomial.isZERO()) {
                        genPolynomial = genPolynomial.monic();
                        if (logger.isInfoEnabled()) {
                            logger.info("ht(H) = " + genPolynomial.leadingExpVector());
                        }
                    }
                }
            }
            if (object instanceof GBTransportMess) {
                logger.debug("null pair results in null H poly");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("#distributed list = " + this.theList.size());
                logger.debug("send H polynomial = " + genPolynomial);
            }
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessPoly(genPolynomial));
                bl2 = false;
            }
            catch (IOException iOException) {
                bl = false;
                iOException.printStackTrace();
            }
            logger.info("done send poly message of " + object);
            try {
                object = this.pairChannel.receive(this.ackTag);
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                interruptedException.printStackTrace();
            }
            catch (IOException iOException) {
                bl = false;
                if (!logger.isDebugEnabled()) break;
                iOException.printStackTrace();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                classNotFoundException.printStackTrace();
            }
            if (!(object instanceof GBTransportMess)) {
                logger.error("invalid acknowledgement " + object);
            }
            logger.info("received acknowledgment " + object);
        }
        logger.info("terminated, done " + n + " reductions");
        if (bl2) {
            try {
                this.pairChannel.send(this.resultTag, new GBTransportMessEnd());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info("terminated, send done");
        }
    }
}

