/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;

public abstract class SingletonIterator<T>
implements Iterator<T> {

    public static class OfDouble
    extends SingletonIterator<Double>
    implements PrimitiveIterator.OfDouble {
        private OptionalDouble element;

        public OfDouble(double d) {
            this.element = OptionalDouble.of(d);
        }

        @Override
        public boolean hasNext() {
            return this.element.isPresent();
        }

        @Override
        public double nextDouble() {
            OptionalDouble optionalDouble = this.element;
            this.element = OptionalDouble.empty();
            return optionalDouble.getAsDouble();
        }
    }

    public static class OfLong
    extends SingletonIterator<Long>
    implements PrimitiveIterator.OfLong {
        private OptionalLong element;

        public OfLong(Long l) {
            this.element = OptionalLong.of(l);
        }

        @Override
        public boolean hasNext() {
            return this.element.isPresent();
        }

        @Override
        public long nextLong() {
            OptionalLong optionalLong = this.element;
            this.element = OptionalLong.empty();
            return optionalLong.getAsLong();
        }
    }

    public static class OfInt
    extends SingletonIterator<Integer>
    implements PrimitiveIterator.OfInt {
        private OptionalInt element;

        public OfInt(int n) {
            this.element = OptionalInt.of(n);
        }

        @Override
        public boolean hasNext() {
            return this.element.isPresent();
        }

        @Override
        public int nextInt() {
            OptionalInt optionalInt = this.element;
            this.element = OptionalInt.empty();
            return optionalInt.getAsInt();
        }
    }

    public static class Of<T>
    extends SingletonIterator<T> {
        private Optional<T> element;

        public Of(T t) {
            this.element = Optional.of(t);
        }

        @Override
        public boolean hasNext() {
            return this.element.isPresent();
        }

        @Override
        public T next() {
            Optional<T> optional = this.element;
            this.element = Optional.empty();
            return optional.get();
        }
    }
}

